/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.internal;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.Channel;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ManagedChannel;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.Status;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.StatusException;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.StatusRuntimeException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.internal.ProtocolInternalUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.internal.api.LocationClient;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.utils.GrpcChannels;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.utils.GrpcUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.Backoff;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.ListenableFutures;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.Retries;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.Revisioned;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.storage.GetStorageContainerEndpointRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.storage.OneStorageContainerEndpointResponse;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.storage.StorageContainerServiceGrpc;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.protocol.util.ProtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationClientImpl
implements LocationClient {
    private static final Logger log = LoggerFactory.getLogger(LocationClientImpl.class);
    private final StorageClientSettings settings;
    private final OrderedScheduler scheduler;
    private final ManagedChannel channel;
    private final StorageContainerServiceGrpc.StorageContainerServiceFutureStub locationService;
    @VisibleForTesting
    static final Predicate<Throwable> LOCATE_STORAGE_CONTAINERS_RETRY_PREDICATE = cause -> LocationClientImpl.shouldRetryOnException(cause);

    public LocationClientImpl(StorageClientSettings settings, OrderedScheduler scheduler) {
        this.settings = settings;
        this.scheduler = scheduler;
        this.channel = GrpcChannels.createChannelBuilder(settings.serviceUri(), settings).build();
        this.locationService = GrpcUtils.configureGrpcStub(StorageContainerServiceGrpc.newFutureStub((Channel)this.channel), Optional.empty());
    }

    private Stream<Long> getDefaultBackoffs() {
        return Backoff.exponential(200L, 2, 1000L);
    }

    private static boolean shouldRetryOnException(Throwable cause) {
        log.error("Not able to locate storage container {}", cause);
        if (cause instanceof StatusRuntimeException || cause instanceof StatusException) {
            Status status = cause instanceof StatusException ? ((StatusException)cause).getStatus() : ((StatusRuntimeException)cause).getStatus();
            switch (status.getCode()) {
                case INVALID_ARGUMENT: 
                case ALREADY_EXISTS: 
                case PERMISSION_DENIED: 
                case UNAUTHENTICATED: {
                    return false;
                }
            }
            return true;
        }
        return !(cause instanceof RuntimeException);
    }

    @Override
    public CompletableFuture<List<OneStorageContainerEndpointResponse>> locateStorageContainers(List<Revisioned<Long>> storageContainerIds) {
        GetStorageContainerEndpointRequest request = ProtoUtils.createGetStorageContainerEndpointRequest(storageContainerIds);
        return Retries.run(this.getDefaultBackoffs(), LOCATE_STORAGE_CONTAINERS_RETRY_PREDICATE, () -> ListenableFutures.fromListenableFuture(this.locationService.getStorageContainerEndpoint(request), ProtocolInternalUtils.GetStorageContainerEndpointsFunction), this.scheduler, request);
    }

    @Override
    public void close() {
        this.channel.shutdown();
    }
}

