/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.container;

import java.util.Map;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Maps;
import org.apache.pulsar.functions.runtime.shaded.javax.annotation.Nullable;
import org.apache.pulsar.functions.runtime.shaded.javax.annotation.concurrent.GuardedBy;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.container.StorageContainerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageContainerManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(StorageContainerManager.class);
    @GuardedBy(value="storageContainers")
    private final Map<Long, StorageContainerInfo> storageContainers = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public StorageContainerInfo getStorageContainer(long groupId) {
        Map<Long, StorageContainerInfo> map = this.storageContainers;
        synchronized (map) {
            return this.storageContainers.get(groupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceStorageContainer(long groupId, StorageContainerInfo groupInfo) {
        Map<Long, StorageContainerInfo> map = this.storageContainers;
        synchronized (map) {
            StorageContainerInfo oldGroupInfo = this.storageContainers.get(groupId);
            if (null == oldGroupInfo || oldGroupInfo.getRevision() < groupInfo.getRevision()) {
                log.info("Updated the storage container info for group {} : ", (Object)groupId, (Object)groupInfo);
                this.storageContainers.put(groupId, groupInfo);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStorageContainer(long groupId) {
        Map<Long, StorageContainerInfo> map = this.storageContainers;
        synchronized (map) {
            this.storageContainers.remove(groupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<Long, StorageContainerInfo> map = this.storageContainers;
        synchronized (map) {
            this.storageContainers.clear();
        }
    }
}

