/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.protocol;

import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.CompositeByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.pulsar.functions.runtime.shaded.io.netty.handler.codec.ProtocolDetectionResult;
import org.apache.pulsar.functions.runtime.shaded.io.netty.handler.codec.ProtocolDetectionState;
import org.apache.pulsar.functions.runtime.shaded.io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import org.apache.pulsar.functions.runtime.shaded.io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionalProxyProtocolDecoder
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(OptionalProxyProtocolDecoder.class);
    public static final String NAME = "optional-proxy-protocol-decoder";
    public static final int MIN_BYTES_SIZE_TO_DETECT_PROTOCOL = 12;
    private CompositeByteBuf cumulatedByteBuf;

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ProtocolDetectionResult<HAProxyProtocolVersion> result;
            ByteBuf buf = (ByteBuf)msg;
            if (this.cumulatedByteBuf != null) {
                buf = this.cumulatedByteBuf.addComponent(true, buf);
            }
            if ((result = HAProxyMessageDecoder.detectProtocol(buf)).state() == ProtocolDetectionState.NEEDS_MORE_DATA) {
                if (this.cumulatedByteBuf == null) {
                    this.cumulatedByteBuf = new CompositeByteBuf(ctx.alloc(), false, 12, buf);
                }
                return;
            }
            this.cumulatedByteBuf = null;
            if (result.state() == ProtocolDetectionState.DETECTED) {
                ctx.pipeline().addAfter(NAME, null, new HAProxyMessageDecoder());
            }
            ctx.pipeline().remove(this);
            super.channelRead(ctx, buf);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (this.cumulatedByteBuf != null) {
            log.info("Release cumulated byte buffer when channel inactive.");
            this.cumulatedByteBuf = null;
        }
    }
}

