/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.JsonProcessingException;

public class EnsemblePlacementPolicyConfig {
    public static final String ENSEMBLE_PLACEMENT_POLICY_CONFIG = "EnsemblePlacementPolicyConfig";
    private final Class policyClass;
    private final Map<String, Object> properties;

    private EnsemblePlacementPolicyConfig() {
        this.policyClass = null;
        this.properties = Collections.emptyMap();
    }

    public EnsemblePlacementPolicyConfig(Class policyClass, Map<String, Object> properties) {
        this.policyClass = policyClass;
        this.properties = properties;
    }

    public Class getPolicyClass() {
        return this.policyClass;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        return Objects.hash(this.policyClass != null ? this.policyClass.getName() : "", this.properties);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EnsemblePlacementPolicyConfig) {
            EnsemblePlacementPolicyConfig other = (EnsemblePlacementPolicyConfig)obj;
            return Objects.equals(this.policyClass == null ? null : this.policyClass.getName(), other.policyClass == null ? null : other.policyClass.getName()) && Objects.equals(this.properties, other.properties);
        }
        return false;
    }

    public byte[] encode() throws ParseEnsemblePlacementPolicyConfigException {
        try {
            return ObjectMapperFactory.getThreadLocal().writerWithDefaultPrettyPrinter().writeValueAsString(this).getBytes(StandardCharsets.UTF_8);
        }
        catch (JsonProcessingException e) {
            throw new ParseEnsemblePlacementPolicyConfigException("Failed to encode to json", e);
        }
    }

    public static EnsemblePlacementPolicyConfig decode(byte[] data) throws ParseEnsemblePlacementPolicyConfigException {
        try {
            return ObjectMapperFactory.getThreadLocal().readValue(new String(data, StandardCharsets.UTF_8), EnsemblePlacementPolicyConfig.class);
        }
        catch (JsonProcessingException e) {
            throw new ParseEnsemblePlacementPolicyConfigException("Failed to decode from json", e);
        }
    }

    public static class ParseEnsemblePlacementPolicyConfigException
    extends Exception {
        ParseEnsemblePlacementPolicyConfigException(String message, Throwable throwable) {
            super(message, throwable);
        }
    }
}

