/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authentication.metrics.AuthenticationMetrics;
import org.apache.pulsar.client.api.url.URL;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.codec.digest.Crypt;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.codec.digest.Md5Crypt;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.io.IOUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;

public class AuthenticationProviderBasic
implements AuthenticationProvider {
    private static final String HTTP_HEADER_NAME = "Authorization";
    private static final String CONF_SYSTEM_PROPERTY_KEY = "pulsar.auth.basic.conf";
    private static final String CONF_PULSAR_PROPERTY_KEY = "basicAuthConf";
    private Map<String, String> users;

    @Override
    public void close() throws IOException {
    }

    public static byte[] readData(String data) throws IOException, URISyntaxException, InstantiationException, IllegalAccessException {
        if (data.startsWith("data:") || data.startsWith("file:")) {
            return IOUtils.toByteArray(URL.createURL(data));
        }
        if (Files.exists(Paths.get(data, new String[0]), new LinkOption[0])) {
            return Files.readAllBytes(Paths.get(data, new String[0]));
        }
        if (org.apache.pulsar.functions.runtime.shaded.org.apache.commons.codec.binary.Base64.isBase64(data)) {
            return Base64.getDecoder().decode(data);
        }
        String msg = "Not supported config";
        throw new IllegalArgumentException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(ServiceConfiguration config) throws IOException {
        String data = config.getProperties().getProperty(CONF_PULSAR_PROPERTY_KEY);
        if (StringUtils.isEmpty(data)) {
            data = System.getProperty(CONF_SYSTEM_PROPERTY_KEY);
        }
        if (StringUtils.isEmpty(data)) {
            throw new IOException("No basic authentication config provided");
        }
        BufferedReader reader = null;
        try {
            try {
                byte[] bytes = AuthenticationProviderBasic.readData(data);
                reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            this.users = new HashMap<String, String>();
            for (String line : (String[])reader.lines().toArray(String[]::new)) {
                List<String> splitLine = Arrays.asList(line.split(":"));
                if (splitLine.size() != 2) {
                    throw new IOException("The format of the password auth conf file is invalid");
                }
                this.users.put(splitLine.get(0), splitLine.get(1));
            }
        }
        finally {
            if (Collections.singletonList(reader).get(0) != null) {
                reader.close();
            }
        }
    }

    @Override
    public String getAuthMethodName() {
        return "basic";
    }

    @Override
    public String authenticate(AuthenticationDataSource authData) throws AuthenticationException {
        AuthParams authParams = new AuthParams(authData);
        String userId = authParams.getUserId();
        String password = authParams.getPassword();
        String msg = "Unknown user or invalid password";
        ErrorCode errorCode = ErrorCode.UNKNOWN;
        try {
            if (this.users.get(userId) == null) {
                errorCode = ErrorCode.INVALID_AUTH_DATA;
                throw new AuthenticationException(msg);
            }
            String encryptedPassword = this.users.get(userId);
            if (this.users.get(userId).startsWith("$apr1")) {
                List<String> splitEncryptedPassword = Arrays.asList(encryptedPassword.split("\\$"));
                if (splitEncryptedPassword.size() != 4 || !encryptedPassword.equals(Md5Crypt.apr1Crypt(password.getBytes(), splitEncryptedPassword.get(2)))) {
                    errorCode = ErrorCode.INVALID_TOKEN;
                    throw new AuthenticationException(msg);
                }
            } else if (!encryptedPassword.equals(Crypt.crypt(password.getBytes(), encryptedPassword.substring(0, 2)))) {
                errorCode = ErrorCode.INVALID_TOKEN;
                throw new AuthenticationException(msg);
            }
        }
        catch (AuthenticationException exception) {
            this.incrementFailureMetric(errorCode);
            throw exception;
        }
        AuthenticationMetrics.authenticateSuccess(this.getClass().getSimpleName(), this.getAuthMethodName());
        return userId;
    }

    private class AuthParams {
        private String userId;
        private String password;

        public AuthParams(AuthenticationDataSource authData) throws AuthenticationException {
            String authParams;
            if (authData.hasDataFromCommand()) {
                authParams = authData.getCommandData();
            } else if (authData.hasDataFromHttp()) {
                String rawAuthToken = authData.getHttpHeader(AuthenticationProviderBasic.HTTP_HEADER_NAME);
                if (StringUtils.isBlank(rawAuthToken) || !rawAuthToken.toUpperCase().startsWith("BASIC ")) {
                    AuthenticationProviderBasic.this.incrementFailureMetric(ErrorCode.INVALID_HEADER);
                    throw new AuthenticationException("Authentication token has to be started with \"Basic \"");
                }
                String[] splitRawAuthToken = rawAuthToken.split(" ");
                if (splitRawAuthToken.length != 2) {
                    AuthenticationProviderBasic.this.incrementFailureMetric(ErrorCode.INVALID_HEADER);
                    throw new AuthenticationException("Base64 encoded token is not found");
                }
                try {
                    authParams = new String(Base64.getDecoder().decode(splitRawAuthToken[1]));
                }
                catch (Exception e) {
                    AuthenticationProviderBasic.this.incrementFailureMetric(ErrorCode.INVALID_HEADER);
                    throw new AuthenticationException("Base64 decoding is failure: " + e.getMessage());
                }
            } else {
                AuthenticationProviderBasic.this.incrementFailureMetric(ErrorCode.EMPTY_AUTH_DATA);
                throw new AuthenticationException("Authentication data source does not have data");
            }
            String[] parsedAuthParams = authParams.split(":");
            if (parsedAuthParams.length != 2) {
                AuthenticationProviderBasic.this.incrementFailureMetric(ErrorCode.INVALID_AUTH_DATA);
                throw new AuthenticationException("Base64 decoded params are invalid");
            }
            this.userId = parsedAuthParams[0];
            this.password = parsedAuthParams[1];
        }

        public String getUserId() {
            return this.userId;
        }

        public String getPassword() {
            return this.password;
        }
    }

    private static enum ErrorCode {
        UNKNOWN,
        EMPTY_AUTH_DATA,
        INVALID_HEADER,
        INVALID_AUTH_DATA,
        INVALID_TOKEN;

    }
}

