/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.windowing;

import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.functions.windowing.Event;

public class EventImpl<T>
implements Event<T> {
    private final Record<?> record;
    private final T event;
    private final long ts;

    EventImpl(T event, long ts, Record<?> record) {
        this.event = event;
        this.ts = ts;
        this.record = record;
    }

    @Override
    public long getTimestamp() {
        return this.ts;
    }

    @Override
    public T get() {
        return this.event;
    }

    @Override
    public boolean isWatermark() {
        return false;
    }

    @Override
    public Record<?> getRecord() {
        return this.record;
    }

    public String toString() {
        return "EventImpl(record=" + this.getRecord() + ", event=" + this.event + ", ts=" + this.ts + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventImpl)) {
            return false;
        }
        EventImpl other = (EventImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Record<?> this$record = this.getRecord();
        Record<?> other$record = other.getRecord();
        if (this$record == null ? other$record != null : !this$record.equals(other$record)) {
            return false;
        }
        T this$event = this.event;
        T other$event = other.event;
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        return this.ts == other.ts;
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Record<?> $record = this.getRecord();
        result = result * 59 + ($record == null ? 43 : $record.hashCode());
        T $event = this.event;
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        long $ts = this.ts;
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        return result;
    }
}

