/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.source;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.functions.ConsumerConfig;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.util.ObjectMapperFactory;

public class PulsarSourceConfig {
    private FunctionConfig.ProcessingGuarantees processingGuarantees;
    SubscriptionType subscriptionType;
    private String subscriptionName;
    private Integer maxMessageRetries = -1;
    private String deadLetterTopic;
    private Map<String, ConsumerConfig> topicSchema = new TreeMap<String, ConsumerConfig>();
    private String typeClassName;
    private Long timeoutMs;

    public static PulsarSourceConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = ObjectMapperFactory.getThreadLocal();
        return (PulsarSourceConfig)mapper.readValue(new ObjectMapper().writeValueAsString(map), PulsarSourceConfig.class);
    }

    public FunctionConfig.ProcessingGuarantees getProcessingGuarantees() {
        return this.processingGuarantees;
    }

    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public Integer getMaxMessageRetries() {
        return this.maxMessageRetries;
    }

    public String getDeadLetterTopic() {
        return this.deadLetterTopic;
    }

    public Map<String, ConsumerConfig> getTopicSchema() {
        return this.topicSchema;
    }

    public String getTypeClassName() {
        return this.typeClassName;
    }

    public Long getTimeoutMs() {
        return this.timeoutMs;
    }

    public void setProcessingGuarantees(FunctionConfig.ProcessingGuarantees processingGuarantees) {
        this.processingGuarantees = processingGuarantees;
    }

    public void setSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public void setMaxMessageRetries(Integer maxMessageRetries) {
        this.maxMessageRetries = maxMessageRetries;
    }

    public void setDeadLetterTopic(String deadLetterTopic) {
        this.deadLetterTopic = deadLetterTopic;
    }

    public void setTopicSchema(Map<String, ConsumerConfig> topicSchema) {
        this.topicSchema = topicSchema;
    }

    public void setTypeClassName(String typeClassName) {
        this.typeClassName = typeClassName;
    }

    public void setTimeoutMs(Long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarSourceConfig)) {
            return false;
        }
        PulsarSourceConfig other = (PulsarSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FunctionConfig.ProcessingGuarantees this$processingGuarantees = this.getProcessingGuarantees();
        FunctionConfig.ProcessingGuarantees other$processingGuarantees = other.getProcessingGuarantees();
        if (this$processingGuarantees == null ? other$processingGuarantees != null : !this$processingGuarantees.equals(other$processingGuarantees)) {
            return false;
        }
        SubscriptionType this$subscriptionType = this.getSubscriptionType();
        SubscriptionType other$subscriptionType = other.getSubscriptionType();
        if (this$subscriptionType == null ? other$subscriptionType != null : !this$subscriptionType.equals(other$subscriptionType)) {
            return false;
        }
        String this$subscriptionName = this.getSubscriptionName();
        String other$subscriptionName = other.getSubscriptionName();
        if (this$subscriptionName == null ? other$subscriptionName != null : !this$subscriptionName.equals(other$subscriptionName)) {
            return false;
        }
        Integer this$maxMessageRetries = this.getMaxMessageRetries();
        Integer other$maxMessageRetries = other.getMaxMessageRetries();
        if (this$maxMessageRetries == null ? other$maxMessageRetries != null : !((Object)this$maxMessageRetries).equals(other$maxMessageRetries)) {
            return false;
        }
        String this$deadLetterTopic = this.getDeadLetterTopic();
        String other$deadLetterTopic = other.getDeadLetterTopic();
        if (this$deadLetterTopic == null ? other$deadLetterTopic != null : !this$deadLetterTopic.equals(other$deadLetterTopic)) {
            return false;
        }
        Map<String, ConsumerConfig> this$topicSchema = this.getTopicSchema();
        Map<String, ConsumerConfig> other$topicSchema = other.getTopicSchema();
        if (this$topicSchema == null ? other$topicSchema != null : !((Object)this$topicSchema).equals(other$topicSchema)) {
            return false;
        }
        String this$typeClassName = this.getTypeClassName();
        String other$typeClassName = other.getTypeClassName();
        if (this$typeClassName == null ? other$typeClassName != null : !this$typeClassName.equals(other$typeClassName)) {
            return false;
        }
        Long this$timeoutMs = this.getTimeoutMs();
        Long other$timeoutMs = other.getTimeoutMs();
        return !(this$timeoutMs == null ? other$timeoutMs != null : !((Object)this$timeoutMs).equals(other$timeoutMs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PulsarSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FunctionConfig.ProcessingGuarantees $processingGuarantees = this.getProcessingGuarantees();
        result = result * 59 + ($processingGuarantees == null ? 43 : $processingGuarantees.hashCode());
        SubscriptionType $subscriptionType = this.getSubscriptionType();
        result = result * 59 + ($subscriptionType == null ? 43 : $subscriptionType.hashCode());
        String $subscriptionName = this.getSubscriptionName();
        result = result * 59 + ($subscriptionName == null ? 43 : $subscriptionName.hashCode());
        Integer $maxMessageRetries = this.getMaxMessageRetries();
        result = result * 59 + ($maxMessageRetries == null ? 43 : ((Object)$maxMessageRetries).hashCode());
        String $deadLetterTopic = this.getDeadLetterTopic();
        result = result * 59 + ($deadLetterTopic == null ? 43 : $deadLetterTopic.hashCode());
        Map<String, ConsumerConfig> $topicSchema = this.getTopicSchema();
        result = result * 59 + ($topicSchema == null ? 43 : ((Object)$topicSchema).hashCode());
        String $typeClassName = this.getTypeClassName();
        result = result * 59 + ($typeClassName == null ? 43 : $typeClassName.hashCode());
        Long $timeoutMs = this.getTimeoutMs();
        result = result * 59 + ($timeoutMs == null ? 43 : ((Object)$timeoutMs).hashCode());
        return result;
    }

    public String toString() {
        return "PulsarSourceConfig(processingGuarantees=" + this.getProcessingGuarantees() + ", subscriptionType=" + this.getSubscriptionType() + ", subscriptionName=" + this.getSubscriptionName() + ", maxMessageRetries=" + this.getMaxMessageRetries() + ", deadLetterTopic=" + this.getDeadLetterTopic() + ", topicSchema=" + this.getTopicSchema() + ", typeClassName=" + this.getTypeClassName() + ", timeoutMs=" + this.getTimeoutMs() + ")";
    }
}

