/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance;

import java.util.Map;
import java.util.function.Function;
import org.apache.pulsar.functions.api.Context;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.functions.instance.ContextImpl;
import org.apache.pulsar.functions.instance.JavaExecutionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaInstance
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(JavaInstance.class);
    private final ContextImpl context;
    private org.apache.pulsar.functions.api.Function function;
    private Function javaUtilFunction;

    public JavaInstance(ContextImpl contextImpl, Object userClassObject) {
        this.context = contextImpl;
        if (userClassObject instanceof org.apache.pulsar.functions.api.Function) {
            this.function = (org.apache.pulsar.functions.api.Function)userClassObject;
        } else {
            this.javaUtilFunction = (Function)userClassObject;
        }
    }

    public JavaExecutionResult handleMessage(Record<?> record, Object input) {
        if (this.context != null) {
            this.context.setCurrentMessageContext(record);
        }
        JavaExecutionResult executionResult = new JavaExecutionResult();
        try {
            Object output = this.function != null ? this.function.process(input, (Context)this.context) : this.javaUtilFunction.apply(input);
            executionResult.setResult(output);
        }
        catch (Exception ex) {
            executionResult.setUserException(ex);
        }
        return executionResult;
    }

    @Override
    public void close() {
    }

    public Map<String, Double> getAndResetMetrics() {
        return this.context.getAndResetMetrics();
    }

    public void resetMetrics() {
        this.context.resetMetrics();
    }

    public Map<String, Double> getMetrics() {
        return this.context.getMetrics();
    }

    ContextImpl getContext() {
        return this.context;
    }
}

