/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance.state;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.api.kv.Table;
import org.apache.pulsar.functions.instance.state.StateContext;

public class StateContextImpl
implements StateContext {
    private final Table<ByteBuf, ByteBuf> table;

    public StateContextImpl(Table<ByteBuf, ByteBuf> table) {
        this.table = table;
    }

    @Override
    public CompletableFuture<Void> incrCounter(String key, long amount) {
        return this.table.increment((Object)Unpooled.wrappedBuffer((byte[])key.getBytes(StandardCharsets.UTF_8)), amount);
    }

    @Override
    public CompletableFuture<Void> put(String key, ByteBuffer value) {
        return this.table.put((Object)Unpooled.wrappedBuffer((byte[])key.getBytes(StandardCharsets.UTF_8)), (Object)Unpooled.wrappedBuffer((ByteBuffer)value));
    }

    @Override
    public CompletableFuture<ByteBuffer> get(String key) {
        return this.table.get((Object)Unpooled.wrappedBuffer((byte[])key.getBytes(StandardCharsets.UTF_8))).thenApply(data -> {
            try {
                ByteBuffer result = ByteBuffer.allocate(data.readableBytes());
                data.readBytes(result);
                ByteBuffer byteBuffer = result;
                return byteBuffer;
            }
            finally {
                data.release();
            }
        });
    }

    @Override
    public CompletableFuture<Long> getCounter(String key) {
        return this.table.getNumber((Object)Unpooled.wrappedBuffer((byte[])key.getBytes(StandardCharsets.UTF_8)));
    }
}

