/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.discovery.service.DiscoveryService;
import org.apache.pulsar.discovery.service.ServerConnection;
import org.apache.pulsar.discovery.service.server.ServiceConfig;

public class ServiceChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String TLS_HANDLER = "tls";
    private ServiceConfig serviceConfig;
    private DiscoveryService discoveryService;
    private boolean enableTLS;

    public ServiceChannelInitializer(DiscoveryService discoveryService, ServiceConfig serviceConfig, boolean enableTLS) {
        this.serviceConfig = serviceConfig;
        this.discoveryService = discoveryService;
        this.enableTLS = enableTLS;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.enableTLS) {
            SslContext sslCtx = SecurityUtility.createNettySslContextForServer((boolean)this.serviceConfig.isTlsAllowInsecureConnection(), (String)this.serviceConfig.getTlsTrustCertsFilePath(), (String)this.serviceConfig.getTlsCertificateFilePath(), (String)this.serviceConfig.getTlsKeyFilePath(), this.serviceConfig.getTlsCiphers(), this.serviceConfig.getTlsProtocols(), (boolean)this.serviceConfig.getTlsRequireTrustedClientCertOnConnect());
            ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)sslCtx.newHandler(ch.alloc()));
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x500000, 0, 4, 0, 4));
        ch.pipeline().addLast("handler", (ChannelHandler)new ServerConnection(this.discoveryService));
    }
}

