/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.connect.kafka;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

public class KafkaSinkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String bootstrapServers;
    private String acks;
    private Long batchSize;
    private Long maxRequestSize;
    private String topic;
    private String keySerializerClass = "org.apache.kafka.common.serialization.StringSerializer";
    private String valueSerializerClass = "org.apache.kafka.common.serialization.StringSerializer";

    public static KafkaSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (KafkaSinkConfig)mapper.readValue(new File(yamlFile), KafkaSinkConfig.class);
    }

    public static KafkaSinkConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (KafkaSinkConfig)mapper.readValue(new ObjectMapper().writeValueAsString(map), KafkaSinkConfig.class);
    }

    public KafkaSinkConfig setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return this;
    }

    public KafkaSinkConfig setAcks(String acks) {
        this.acks = acks;
        return this;
    }

    public KafkaSinkConfig setBatchSize(Long batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public KafkaSinkConfig setMaxRequestSize(Long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
        return this;
    }

    public KafkaSinkConfig setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public KafkaSinkConfig setKeySerializerClass(String keySerializerClass) {
        this.keySerializerClass = keySerializerClass;
        return this;
    }

    public KafkaSinkConfig setValueSerializerClass(String valueSerializerClass) {
        this.valueSerializerClass = valueSerializerClass;
        return this;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getAcks() {
        return this.acks;
    }

    public Long getBatchSize() {
        return this.batchSize;
    }

    public Long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getKeySerializerClass() {
        return this.keySerializerClass;
    }

    public String getValueSerializerClass() {
        return this.valueSerializerClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaSinkConfig)) {
            return false;
        }
        KafkaSinkConfig other = (KafkaSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$acks = this.getAcks();
        String other$acks = other.getAcks();
        if (this$acks == null ? other$acks != null : !this$acks.equals(other$acks)) {
            return false;
        }
        Long this$batchSize = this.getBatchSize();
        Long other$batchSize = other.getBatchSize();
        if (this$batchSize == null ? other$batchSize != null : !((Object)this$batchSize).equals(other$batchSize)) {
            return false;
        }
        Long this$maxRequestSize = this.getMaxRequestSize();
        Long other$maxRequestSize = other.getMaxRequestSize();
        if (this$maxRequestSize == null ? other$maxRequestSize != null : !((Object)this$maxRequestSize).equals(other$maxRequestSize)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$keySerializerClass = this.getKeySerializerClass();
        String other$keySerializerClass = other.getKeySerializerClass();
        if (this$keySerializerClass == null ? other$keySerializerClass != null : !this$keySerializerClass.equals(other$keySerializerClass)) {
            return false;
        }
        String this$valueSerializerClass = this.getValueSerializerClass();
        String other$valueSerializerClass = other.getValueSerializerClass();
        return !(this$valueSerializerClass == null ? other$valueSerializerClass != null : !this$valueSerializerClass.equals(other$valueSerializerClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaSinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $acks = this.getAcks();
        result = result * 59 + ($acks == null ? 43 : $acks.hashCode());
        Long $batchSize = this.getBatchSize();
        result = result * 59 + ($batchSize == null ? 43 : ((Object)$batchSize).hashCode());
        Long $maxRequestSize = this.getMaxRequestSize();
        result = result * 59 + ($maxRequestSize == null ? 43 : ((Object)$maxRequestSize).hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $keySerializerClass = this.getKeySerializerClass();
        result = result * 59 + ($keySerializerClass == null ? 43 : $keySerializerClass.hashCode());
        String $valueSerializerClass = this.getValueSerializerClass();
        result = result * 59 + ($valueSerializerClass == null ? 43 : $valueSerializerClass.hashCode());
        return result;
    }

    public String toString() {
        return "KafkaSinkConfig(bootstrapServers=" + this.getBootstrapServers() + ", acks=" + this.getAcks() + ", batchSize=" + this.getBatchSize() + ", maxRequestSize=" + this.getMaxRequestSize() + ", topic=" + this.getTopic() + ", keySerializerClass=" + this.getKeySerializerClass() + ", valueSerializerClass=" + this.getValueSerializerClass() + ")";
    }
}

