/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.connect.kafka;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

public class KafkaSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String bootstrapServers;
    private String groupId;
    private Long fetchMinBytes;
    private Long autoCommitIntervalMs;
    private Long sessionTimeoutMs;
    private boolean autoCommitEnabled = true;
    private String topic;
    private String keyDeserializationClass = "org.apache.kafka.common.serialization.StringDeserializer";
    private String valueDeserializationClass = "org.apache.kafka.common.serialization.StringDeserializer";

    public static KafkaSourceConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (KafkaSourceConfig)mapper.readValue(new File(yamlFile), KafkaSourceConfig.class);
    }

    public static KafkaSourceConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (KafkaSourceConfig)mapper.readValue(new ObjectMapper().writeValueAsString(map), KafkaSourceConfig.class);
    }

    public KafkaSourceConfig setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return this;
    }

    public KafkaSourceConfig setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public KafkaSourceConfig setFetchMinBytes(Long fetchMinBytes) {
        this.fetchMinBytes = fetchMinBytes;
        return this;
    }

    public KafkaSourceConfig setAutoCommitIntervalMs(Long autoCommitIntervalMs) {
        this.autoCommitIntervalMs = autoCommitIntervalMs;
        return this;
    }

    public KafkaSourceConfig setSessionTimeoutMs(Long sessionTimeoutMs) {
        this.sessionTimeoutMs = sessionTimeoutMs;
        return this;
    }

    public KafkaSourceConfig setAutoCommitEnabled(boolean autoCommitEnabled) {
        this.autoCommitEnabled = autoCommitEnabled;
        return this;
    }

    public KafkaSourceConfig setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public KafkaSourceConfig setKeyDeserializationClass(String keyDeserializationClass) {
        this.keyDeserializationClass = keyDeserializationClass;
        return this;
    }

    public KafkaSourceConfig setValueDeserializationClass(String valueDeserializationClass) {
        this.valueDeserializationClass = valueDeserializationClass;
        return this;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Long getFetchMinBytes() {
        return this.fetchMinBytes;
    }

    public Long getAutoCommitIntervalMs() {
        return this.autoCommitIntervalMs;
    }

    public Long getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public boolean isAutoCommitEnabled() {
        return this.autoCommitEnabled;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getKeyDeserializationClass() {
        return this.keyDeserializationClass;
    }

    public String getValueDeserializationClass() {
        return this.valueDeserializationClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaSourceConfig)) {
            return false;
        }
        KafkaSourceConfig other = (KafkaSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        Long this$fetchMinBytes = this.getFetchMinBytes();
        Long other$fetchMinBytes = other.getFetchMinBytes();
        if (this$fetchMinBytes == null ? other$fetchMinBytes != null : !((Object)this$fetchMinBytes).equals(other$fetchMinBytes)) {
            return false;
        }
        Long this$autoCommitIntervalMs = this.getAutoCommitIntervalMs();
        Long other$autoCommitIntervalMs = other.getAutoCommitIntervalMs();
        if (this$autoCommitIntervalMs == null ? other$autoCommitIntervalMs != null : !((Object)this$autoCommitIntervalMs).equals(other$autoCommitIntervalMs)) {
            return false;
        }
        Long this$sessionTimeoutMs = this.getSessionTimeoutMs();
        Long other$sessionTimeoutMs = other.getSessionTimeoutMs();
        if (this$sessionTimeoutMs == null ? other$sessionTimeoutMs != null : !((Object)this$sessionTimeoutMs).equals(other$sessionTimeoutMs)) {
            return false;
        }
        if (this.isAutoCommitEnabled() != other.isAutoCommitEnabled()) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$keyDeserializationClass = this.getKeyDeserializationClass();
        String other$keyDeserializationClass = other.getKeyDeserializationClass();
        if (this$keyDeserializationClass == null ? other$keyDeserializationClass != null : !this$keyDeserializationClass.equals(other$keyDeserializationClass)) {
            return false;
        }
        String this$valueDeserializationClass = this.getValueDeserializationClass();
        String other$valueDeserializationClass = other.getValueDeserializationClass();
        return !(this$valueDeserializationClass == null ? other$valueDeserializationClass != null : !this$valueDeserializationClass.equals(other$valueDeserializationClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        Long $fetchMinBytes = this.getFetchMinBytes();
        result = result * 59 + ($fetchMinBytes == null ? 43 : ((Object)$fetchMinBytes).hashCode());
        Long $autoCommitIntervalMs = this.getAutoCommitIntervalMs();
        result = result * 59 + ($autoCommitIntervalMs == null ? 43 : ((Object)$autoCommitIntervalMs).hashCode());
        Long $sessionTimeoutMs = this.getSessionTimeoutMs();
        result = result * 59 + ($sessionTimeoutMs == null ? 43 : ((Object)$sessionTimeoutMs).hashCode());
        result = result * 59 + (this.isAutoCommitEnabled() ? 79 : 97);
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $keyDeserializationClass = this.getKeyDeserializationClass();
        result = result * 59 + ($keyDeserializationClass == null ? 43 : $keyDeserializationClass.hashCode());
        String $valueDeserializationClass = this.getValueDeserializationClass();
        result = result * 59 + ($valueDeserializationClass == null ? 43 : $valueDeserializationClass.hashCode());
        return result;
    }

    public String toString() {
        return "KafkaSourceConfig(bootstrapServers=" + this.getBootstrapServers() + ", groupId=" + this.getGroupId() + ", fetchMinBytes=" + this.getFetchMinBytes() + ", autoCommitIntervalMs=" + this.getAutoCommitIntervalMs() + ", sessionTimeoutMs=" + this.getSessionTimeoutMs() + ", autoCommitEnabled=" + this.isAutoCommitEnabled() + ", topic=" + this.getTopic() + ", keyDeserializationClass=" + this.getKeyDeserializationClass() + ", valueDeserializationClass=" + this.getValueDeserializationClass() + ")";
    }
}

