/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;

public final class OffloadUtils {
    private OffloadUtils() {
    }

    public static Map<String, String> getOffloadDriverMetadata(MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo) {
        MLDataFormats.OffloadDriverMetadata driverMetadata;
        MLDataFormats.OffloadContext ctx;
        HashMap metadata = Maps.newHashMap();
        if (ledgerInfo.hasOffloadContext() && (ctx = ledgerInfo.getOffloadContext()).hasDriverMetadata() && (driverMetadata = ctx.getDriverMetadata()).getPropertiesCount() > 0) {
            driverMetadata.getPropertiesList().forEach(kv -> metadata.put(kv.getKey(), kv.getValue()));
        }
        return metadata;
    }

    public static Map<String, String> getOffloadDriverMetadata(MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo, Map<String, String> defaultOffloadDriverMetadata) {
        MLDataFormats.OffloadDriverMetadata driverMetadata;
        MLDataFormats.OffloadContext ctx;
        if (ledgerInfo.hasOffloadContext() && (ctx = ledgerInfo.getOffloadContext()).hasDriverMetadata() && (driverMetadata = ctx.getDriverMetadata()).getPropertiesCount() > 0) {
            HashMap metadata = Maps.newHashMap();
            driverMetadata.getPropertiesList().forEach(kv -> metadata.put(kv.getKey(), kv.getValue()));
            return metadata;
        }
        return defaultOffloadDriverMetadata;
    }

    public static String getOffloadDriverName(MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo, String defaultDriverName) {
        MLDataFormats.OffloadDriverMetadata driverMetadata;
        MLDataFormats.OffloadContext ctx;
        if (ledgerInfo.hasOffloadContext() && (ctx = ledgerInfo.getOffloadContext()).hasDriverMetadata() && (driverMetadata = ctx.getDriverMetadata()).hasName()) {
            return driverMetadata.getName();
        }
        return defaultDriverName;
    }

    public static void setOffloadDriverMetadata(MLDataFormats.ManagedLedgerInfo.LedgerInfo.Builder infoBuilder, String driverName, Map<String, String> offloadDriverMetadata) {
        infoBuilder.getOffloadContextBuilder().getDriverMetadataBuilder().setName(driverName);
        offloadDriverMetadata.forEach((k, v) -> infoBuilder.getOffloadContextBuilder().getDriverMetadataBuilder().addProperties(MLDataFormats.KeyValue.newBuilder().setKey((String)k).setValue((String)v).build()));
    }
}

