/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.collect.Range;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ReadOnlyCursor;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyCursorImpl
extends ManagedCursorImpl
implements ReadOnlyCursor {
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyCursorImpl.class);

    public ReadOnlyCursorImpl(BookKeeper bookkeeper, ManagedLedgerConfig config, ManagedLedgerImpl ledger, PositionImpl startPosition, String cursorName) {
        super(bookkeeper, config, ledger, cursorName);
        this.readPosition = startPosition.equals(PositionImpl.earliest) ? ledger.getFirstPosition().getNext() : startPosition;
        this.messagesConsumedCounter = ledger.getLastPosition().compareTo(this.readPosition) <= 0 ? 0L : -this.getNumberOfEntries((Range<PositionImpl>)Range.closed((Comparable)this.readPosition, (Comparable)ledger.getLastPosition()));
        this.state = ManagedCursorImpl.State.NoLedger;
    }

    @Override
    public void skipEntries(int numEntriesToSkip) {
        log.info("[{}] Skipping {} entries on read-only cursor {}", (Object)this.ledger.getName(), (Object)numEntriesToSkip);
        this.readPosition = this.ledger.getPositionAfterN(this.readPosition, numEntriesToSkip, ManagedLedgerImpl.PositionBound.startIncluded).getNext();
    }

    @Override
    public void asyncClose(AsyncCallbacks.CloseCallback callback, Object ctx) {
        this.state = ManagedCursorImpl.State.Closed;
        callback.closeComplete(ctx);
    }

    @Override
    public long getNumberOfEntries(Range<PositionImpl> range) {
        return this.ledger.getNumberOfEntries(range);
    }
}

