/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

public class ManagedLedgerFactoryConfig {
    private static final long MB = 0x100000L;
    private long maxCacheSize = 0x8000000L;
    private double cacheEvictionWatermark = 0.9;
    private int numManagedLedgerWorkerThreads = Runtime.getRuntime().availableProcessors();
    private int numManagedLedgerSchedulerThreads = Runtime.getRuntime().availableProcessors();

    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public double getCacheEvictionWatermark() {
        return this.cacheEvictionWatermark;
    }

    public int getNumManagedLedgerWorkerThreads() {
        return this.numManagedLedgerWorkerThreads;
    }

    public int getNumManagedLedgerSchedulerThreads() {
        return this.numManagedLedgerSchedulerThreads;
    }

    public void setMaxCacheSize(long maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public void setCacheEvictionWatermark(double cacheEvictionWatermark) {
        this.cacheEvictionWatermark = cacheEvictionWatermark;
    }

    public void setNumManagedLedgerWorkerThreads(int numManagedLedgerWorkerThreads) {
        this.numManagedLedgerWorkerThreads = numManagedLedgerWorkerThreads;
    }

    public void setNumManagedLedgerSchedulerThreads(int numManagedLedgerSchedulerThreads) {
        this.numManagedLedgerSchedulerThreads = numManagedLedgerSchedulerThreads;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManagedLedgerFactoryConfig)) {
            return false;
        }
        ManagedLedgerFactoryConfig other = (ManagedLedgerFactoryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxCacheSize() != other.getMaxCacheSize()) {
            return false;
        }
        if (Double.compare(this.getCacheEvictionWatermark(), other.getCacheEvictionWatermark()) != 0) {
            return false;
        }
        if (this.getNumManagedLedgerWorkerThreads() != other.getNumManagedLedgerWorkerThreads()) {
            return false;
        }
        return this.getNumManagedLedgerSchedulerThreads() == other.getNumManagedLedgerSchedulerThreads();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ManagedLedgerFactoryConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxCacheSize = this.getMaxCacheSize();
        result = result * 59 + (int)($maxCacheSize >>> 32 ^ $maxCacheSize);
        long $cacheEvictionWatermark = Double.doubleToLongBits(this.getCacheEvictionWatermark());
        result = result * 59 + (int)($cacheEvictionWatermark >>> 32 ^ $cacheEvictionWatermark);
        result = result * 59 + this.getNumManagedLedgerWorkerThreads();
        result = result * 59 + this.getNumManagedLedgerSchedulerThreads();
        return result;
    }

    public String toString() {
        return "ManagedLedgerFactoryConfig(maxCacheSize=" + this.getMaxCacheSize() + ", cacheEvictionWatermark=" + this.getCacheEvictionWatermark() + ", numManagedLedgerWorkerThreads=" + this.getNumManagedLedgerWorkerThreads() + ", numManagedLedgerSchedulerThreads=" + this.getNumManagedLedgerSchedulerThreads() + ")";
    }
}

