/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.ReflectionFactory;

public class MockZooKeeper
extends ZooKeeper {
    private TreeMap<String, Pair<byte[], Integer>> tree;
    private SetMultimap<String, Watcher> watchers;
    private volatile boolean stopped;
    private boolean alwaysFail = false;
    private ExecutorService executor;
    private AtomicInteger stepsToFail;
    private KeeperException.Code failReturnCode;
    private Watcher sessionWatcher;
    private long sessionId = 0L;
    private int readOpDelayMs;
    private ReentrantLock mutex;
    private static final Logger log = LoggerFactory.getLogger(MockZooKeeper.class);

    public static MockZooKeeper newInstance() {
        return MockZooKeeper.newInstance(null);
    }

    public static MockZooKeeper newInstance(ExecutorService executor) {
        return MockZooKeeper.newInstance(executor, -1);
    }

    public static MockZooKeeper newInstance(ExecutorService executor, int readOpDelayMs) {
        try {
            ReflectionFactory rf = ReflectionFactory.getReflectionFactory();
            Constructor objDef = Object.class.getDeclaredConstructor(new Class[0]);
            Constructor<?> intConstr = rf.newConstructorForSerialization(MockZooKeeper.class, objDef);
            MockZooKeeper zk = (MockZooKeeper)((Object)MockZooKeeper.class.cast(intConstr.newInstance(new Object[0])));
            zk.init(executor);
            zk.readOpDelayMs = readOpDelayMs;
            zk.mutex = new ReentrantLock();
            return zk;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create object", e);
        }
    }

    private void init(ExecutorService executor) {
        this.tree = Maps.newTreeMap();
        this.executor = executor != null ? executor : Executors.newFixedThreadPool(1, (ThreadFactory)new DefaultThreadFactory("mock-zookeeper"));
        HashMultimap w = HashMultimap.create();
        this.watchers = Multimaps.synchronizedSetMultimap((SetMultimap)w);
        this.stopped = false;
        this.stepsToFail = new AtomicInteger(-1);
        this.failReturnCode = KeeperException.Code.OK;
    }

    private MockZooKeeper(String quorum) throws Exception {
        super(quorum, 1, new Watcher(){

            public void process(WatchedEvent event) {
            }
        });
        assert (false);
    }

    public ZooKeeper.States getState() {
        return ZooKeeper.States.CONNECTED;
    }

    public void register(Watcher watcher) {
        this.mutex.lock();
        this.sessionWatcher = watcher;
        this.mutex.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        this.mutex.lock();
        try {
            this.checkProgrammedFail();
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (this.tree.containsKey(path)) {
                throw new KeeperException.NodeExistsException(path);
            }
            String parent = path.substring(0, path.lastIndexOf("/"));
            if (!parent.isEmpty() && !this.tree.containsKey(parent)) {
                throw new KeeperException.NoNodeException();
            }
            if (createMode == CreateMode.EPHEMERAL_SEQUENTIAL || createMode == CreateMode.PERSISTENT_SEQUENTIAL) {
                byte[] parentData = (byte[])this.tree.get(parent).getLeft();
                int parentVersion = (Integer)this.tree.get(parent).getRight();
                path = path + parentVersion;
                this.tree.put(parent, (Pair<byte[], Integer>)Pair.of((Object)parentData, (Object)(parentVersion + 1)));
            }
            this.tree.put(path, (Pair<byte[], Integer>)Pair.of((Object)data, (Object)0));
            HashSet toNotifyCreate = Sets.newHashSet();
            toNotifyCreate.addAll(this.watchers.get((Object)path));
            HashSet toNotifyParent = Sets.newHashSet();
            if (!parent.isEmpty()) {
                toNotifyParent.addAll(this.watchers.get((Object)parent));
            }
            this.watchers.removeAll((Object)path);
            String finalPath = path;
            this.executor.execute(() -> {
                toNotifyCreate.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, finalPath)));
                toNotifyParent.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent)));
            });
            String string = path;
            return string;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void create(String path, byte[] data, List<ACL> acl, CreateMode createMode, AsyncCallback.StringCallback cb, Object ctx) {
        if (this.stopped) {
            cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
            return;
        }
        HashSet toNotifyCreate = Sets.newHashSet();
        toNotifyCreate.addAll(this.watchers.get((Object)path));
        HashSet toNotifyParent = Sets.newHashSet();
        String parent = path.substring(0, path.lastIndexOf("/"));
        if (!parent.isEmpty()) {
            toNotifyParent.addAll(this.watchers.get((Object)parent));
        }
        this.watchers.removeAll((Object)path);
        this.executor.execute(() -> {
            this.mutex.lock();
            if (this.getProgrammedFailStatus()) {
                this.mutex.unlock();
                cb.processResult(this.failReturnCode.intValue(), path, ctx, null);
            } else if (this.stopped) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
            } else if (this.tree.containsKey(path)) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.NODEEXISTS.intValue(), path, ctx, null);
            } else if (!parent.isEmpty() && !this.tree.containsKey(parent)) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null);
            } else {
                this.tree.put(path, (Pair<byte[], Integer>)Pair.of((Object)data, (Object)0));
                this.mutex.unlock();
                cb.processResult(0, path, ctx, null);
                toNotifyCreate.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, path)));
                toNotifyParent.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent)));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException {
        this.mutex.lock();
        try {
            this.checkProgrammedFail();
            Pair<byte[], Integer> value = this.tree.get(path);
            if (value == null) {
                throw new KeeperException.NoNodeException(path);
            }
            if (watcher != null) {
                this.watchers.put((Object)path, (Object)watcher);
            }
            if (stat != null) {
                stat.setVersion(((Integer)value.getRight()).intValue());
            }
            byte[] byArray = (byte[])value.getLeft();
            return byArray;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void getData(String path, boolean watch, AsyncCallback.DataCallback cb, Object ctx) {
        this.executor.execute(() -> {
            Pair<byte[], Integer> value;
            this.checkReadOpDelay();
            if (this.getProgrammedFailStatus()) {
                cb.processResult(this.failReturnCode.intValue(), path, ctx, null, null);
                return;
            }
            if (this.stopped) {
                cb.processResult(-4, path, ctx, null, null);
                return;
            }
            this.mutex.lock();
            try {
                value = this.tree.get(path);
            }
            finally {
                this.mutex.unlock();
            }
            if (value == null) {
                cb.processResult(-101, path, ctx, null, null);
            } else {
                Stat stat = new Stat();
                stat.setVersion(((Integer)value.getRight()).intValue());
                cb.processResult(0, path, ctx, (byte[])value.getLeft(), stat);
            }
        });
    }

    public void getData(String path, Watcher watcher, AsyncCallback.DataCallback cb, Object ctx) {
        this.executor.execute(() -> {
            this.checkReadOpDelay();
            this.mutex.lock();
            if (this.getProgrammedFailStatus()) {
                this.mutex.unlock();
                cb.processResult(this.failReturnCode.intValue(), path, ctx, null, null);
                return;
            }
            if (this.stopped) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null, null);
                return;
            }
            Pair<byte[], Integer> value = this.tree.get(path);
            if (value == null) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null, null);
            } else {
                if (watcher != null) {
                    this.watchers.put((Object)path, (Object)watcher);
                }
                Stat stat = new Stat();
                stat.setVersion(((Integer)value.getRight()).intValue());
                this.mutex.unlock();
                cb.processResult(0, path, ctx, (byte[])value.getLeft(), stat);
            }
        });
    }

    public void getChildren(String path, Watcher watcher, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this.executor.execute(() -> {
            this.mutex.lock();
            if (this.getProgrammedFailStatus()) {
                this.mutex.unlock();
                cb.processResult(this.failReturnCode.intValue(), path, ctx, null);
                return;
            }
            if (this.stopped) {
                this.mutex.unlock();
                cb.processResult(-4, path, ctx, null);
                return;
            }
            ArrayList children = Lists.newArrayList();
            for (String item : this.tree.tailMap(path).keySet()) {
                String child;
                if (!item.startsWith(path)) break;
                if (path.length() >= item.length() || (child = item.substring(path.length() + 1)).contains("/")) continue;
                children.add(child);
            }
            this.mutex.unlock();
            cb.processResult(0, path, ctx, (List)children);
            if (watcher != null) {
                this.watchers.put((Object)path, (Object)watcher);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildren(String path, Watcher watcher) throws KeeperException {
        this.mutex.lock();
        try {
            this.checkProgrammedFail();
            if (!this.tree.containsKey(path)) {
                throw new KeeperException.NoNodeException();
            }
            ArrayList children = Lists.newArrayList();
            for (String item : this.tree.tailMap(path).keySet()) {
                String child;
                if (!item.startsWith(path)) break;
                if (path.length() >= item.length() || (child = item.substring(path.length() + 1)).contains("/")) continue;
                children.add(child);
            }
            if (watcher != null) {
                this.watchers.put((Object)path, (Object)watcher);
            }
            ArrayList arrayList = children;
            return arrayList;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        this.mutex.lock();
        try {
            this.checkProgrammedFail();
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (!this.tree.containsKey(path)) {
                throw new KeeperException.NoNodeException();
            }
            ArrayList children = Lists.newArrayList();
            for (String item : this.tree.tailMap(path).keySet()) {
                String child;
                if (!item.startsWith(path)) break;
                if (path.length() >= item.length() || (child = item.substring(path.length() + 1)).contains("/")) continue;
                children.add(child);
            }
            ArrayList arrayList = children;
            return arrayList;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void getChildren(String path, boolean watcher, AsyncCallback.Children2Callback cb, Object ctx) {
        this.executor.execute(() -> {
            this.mutex.lock();
            if (this.getProgrammedFailStatus()) {
                this.mutex.unlock();
                cb.processResult(this.failReturnCode.intValue(), path, ctx, null, null);
                return;
            }
            if (this.stopped) {
                this.mutex.unlock();
                cb.processResult(-4, path, ctx, null, null);
                return;
            }
            if (!this.tree.containsKey(path)) {
                this.mutex.unlock();
                cb.processResult(-101, path, ctx, null, null);
                return;
            }
            log.debug("getChildren path={}", (Object)path);
            ArrayList children = Lists.newArrayList();
            for (String item : this.tree.tailMap(path).keySet()) {
                log.debug("Checking path {}", (Object)item);
                if (!item.startsWith(path)) break;
                if (item.equals(path)) continue;
                String child = item.substring(path.length() + 1);
                log.debug("child: '{}'", (Object)child);
                if (child.contains("/")) continue;
                children.add(child);
            }
            log.debug("getChildren done path={} result={}", (Object)path, (Object)children);
            this.mutex.unlock();
            cb.processResult(0, path, ctx, (List)children, new Stat());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        this.mutex.lock();
        try {
            this.checkProgrammedFail();
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (this.tree.containsKey(path)) {
                Stat stat = new Stat();
                stat.setVersion(((Integer)this.tree.get(path).getRight()).intValue());
                Stat stat2 = stat;
                return stat2;
            }
            Stat stat = null;
            return stat;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        this.mutex.lock();
        try {
            this.checkProgrammedFail();
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (watcher != null) {
                this.watchers.put((Object)path, (Object)watcher);
            }
            if (this.tree.containsKey(path)) {
                Stat stat = new Stat();
                stat.setVersion(((Integer)this.tree.get(path).getRight()).intValue());
                Stat stat2 = stat;
                return stat2;
            }
            Stat stat = null;
            return stat;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void exists(String path, boolean watch, AsyncCallback.StatCallback cb, Object ctx) {
        this.executor.execute(() -> {
            this.mutex.lock();
            if (this.getProgrammedFailStatus()) {
                this.mutex.unlock();
                cb.processResult(this.failReturnCode.intValue(), path, ctx, null);
                return;
            }
            if (this.stopped) {
                this.mutex.unlock();
                cb.processResult(-4, path, ctx, null);
                return;
            }
            if (this.tree.containsKey(path)) {
                this.mutex.unlock();
                cb.processResult(0, path, ctx, new Stat());
            } else {
                this.mutex.unlock();
                cb.processResult(-101, path, ctx, null);
            }
        });
    }

    public void exists(String path, Watcher watcher, AsyncCallback.StatCallback cb, Object ctx) {
        this.executor.execute(() -> {
            this.mutex.lock();
            if (this.getProgrammedFailStatus()) {
                this.mutex.unlock();
                cb.processResult(this.failReturnCode.intValue(), path, ctx, null);
                return;
            }
            if (this.stopped) {
                this.mutex.unlock();
                cb.processResult(-4, path, ctx, null);
                return;
            }
            if (watcher != null) {
                this.watchers.put((Object)path, (Object)watcher);
            }
            if (this.tree.containsKey(path)) {
                this.mutex.unlock();
                cb.processResult(0, path, ctx, new Stat());
            } else {
                this.mutex.unlock();
                cb.processResult(-101, path, ctx, null);
            }
        });
    }

    public void sync(String path, AsyncCallback.VoidCallback cb, Object ctx) {
        this.executor.execute(() -> {
            if (this.getProgrammedFailStatus()) {
                cb.processResult(this.failReturnCode.intValue(), path, ctx);
                return;
            }
            if (this.stopped) {
                cb.processResult(-4, path, ctx);
                return;
            }
            cb.processResult(0, path, ctx);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        int newVersion;
        this.mutex.lock();
        HashSet toNotify = Sets.newHashSet();
        try {
            this.checkProgrammedFail();
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (!this.tree.containsKey(path)) {
                throw new KeeperException.NoNodeException();
            }
            int currentVersion = (Integer)this.tree.get(path).getRight();
            if (version != -1 && version != currentVersion) {
                throw new KeeperException.BadVersionException(path);
            }
            newVersion = currentVersion + 1;
            log.debug("[{}] Updating -- current version: {}", (Object)path, (Object)currentVersion);
            this.tree.put(path, (Pair<byte[], Integer>)Pair.of((Object)data, (Object)newVersion));
            toNotify.addAll(this.watchers.get((Object)path));
            this.watchers.removeAll((Object)path);
        }
        finally {
            this.mutex.unlock();
        }
        this.executor.execute(() -> toNotify.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, path))));
        Stat stat = new Stat();
        stat.setVersion(newVersion);
        return stat;
    }

    public void setData(String path, byte[] data, int version, AsyncCallback.StatCallback cb, Object ctx) {
        if (this.stopped) {
            cb.processResult(-4, path, ctx, null);
            return;
        }
        this.executor.execute(() -> {
            HashSet toNotify = Sets.newHashSet();
            this.mutex.lock();
            if (this.getProgrammedFailStatus()) {
                this.mutex.unlock();
                cb.processResult(this.failReturnCode.intValue(), path, ctx, null);
                return;
            }
            if (this.stopped) {
                this.mutex.unlock();
                cb.processResult(-4, path, ctx, null);
                return;
            }
            if (!this.tree.containsKey(path)) {
                this.mutex.unlock();
                cb.processResult(-101, path, ctx, null);
                return;
            }
            int currentVersion = (Integer)this.tree.get(path).getRight();
            if (version != -1 && version != currentVersion) {
                log.debug("[{}] Current version: {} -- Expected: {}", new Object[]{path, currentVersion, version});
                this.mutex.unlock();
                cb.processResult(-103, path, ctx, null);
                return;
            }
            int newVersion = currentVersion + 1;
            log.debug("[{}] Updating -- current version: {}", (Object)path, (Object)currentVersion);
            this.tree.put(path, (Pair<byte[], Integer>)Pair.of((Object)data, (Object)newVersion));
            Stat stat = new Stat();
            stat.setVersion(newVersion);
            this.mutex.unlock();
            cb.processResult(0, path, ctx, stat);
            toNotify.addAll(this.watchers.get((Object)path));
            this.watchers.removeAll((Object)path);
            for (Watcher watcher : toNotify) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, path));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String path, int version) throws InterruptedException, KeeperException {
        String parent;
        HashSet toNotifyParent;
        HashSet toNotifyDelete;
        this.checkProgrammedFail();
        this.mutex.lock();
        try {
            int currentVersion;
            if (this.stopped) {
                throw new KeeperException.ConnectionLossException();
            }
            if (!this.tree.containsKey(path)) {
                throw new KeeperException.NoNodeException(path);
            }
            if (this.hasChildren(path)) {
                throw new KeeperException.NotEmptyException(path);
            }
            if (version != -1 && version != (currentVersion = ((Integer)this.tree.get(path).getRight()).intValue())) {
                throw new KeeperException.BadVersionException(path);
            }
            this.tree.remove(path);
            toNotifyDelete = Sets.newHashSet();
            toNotifyDelete.addAll(this.watchers.get((Object)path));
            toNotifyParent = Sets.newHashSet();
            parent = path.substring(0, path.lastIndexOf("/"));
            if (!parent.isEmpty()) {
                toNotifyParent.addAll(this.watchers.get((Object)parent));
            }
            this.watchers.removeAll((Object)path);
        }
        finally {
            this.mutex.unlock();
        }
        this.executor.execute(() -> {
            if (this.stopped) {
                return;
            }
            for (Watcher watcher1 : toNotifyDelete) {
                watcher1.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path));
            }
            for (Watcher watcher2 : toNotifyParent) {
                watcher2.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent));
            }
        });
    }

    public void delete(String path, int version, AsyncCallback.VoidCallback cb, Object ctx) {
        this.mutex.lock();
        if (this.executor.isShutdown()) {
            this.mutex.unlock();
            cb.processResult(KeeperException.Code.SESSIONEXPIRED.intValue(), path, ctx);
            return;
        }
        HashSet toNotifyDelete = Sets.newHashSet();
        toNotifyDelete.addAll(this.watchers.get((Object)path));
        HashSet toNotifyParent = Sets.newHashSet();
        String parent = path.substring(0, path.lastIndexOf("/"));
        if (!parent.isEmpty()) {
            toNotifyParent.addAll(this.watchers.get((Object)parent));
        }
        this.executor.execute(() -> {
            this.mutex.lock();
            if (this.getProgrammedFailStatus()) {
                this.mutex.unlock();
                cb.processResult(this.failReturnCode.intValue(), path, ctx);
            } else if (this.stopped) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx);
            } else if (!this.tree.containsKey(path)) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx);
            } else if (this.hasChildren(path)) {
                this.mutex.unlock();
                cb.processResult(KeeperException.Code.NOTEMPTY.intValue(), path, ctx);
            } else {
                int currentVersion;
                if (version != -1 && version != (currentVersion = ((Integer)this.tree.get(path).getRight()).intValue())) {
                    cb.processResult(KeeperException.Code.BADVERSION.intValue(), path, ctx);
                    return;
                }
                this.tree.remove(path);
                this.mutex.unlock();
                cb.processResult(0, path, ctx);
                toNotifyDelete.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path)));
                toNotifyParent.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent)));
            }
        });
        this.watchers.removeAll((Object)path);
        this.mutex.unlock();
    }

    public void close() throws InterruptedException {
    }

    public void shutdown() throws InterruptedException {
        this.mutex.lock();
        try {
            this.stopped = true;
            this.tree.clear();
            this.watchers.clear();
            this.executor.shutdownNow();
        }
        finally {
            this.mutex.unlock();
        }
    }

    void checkProgrammedFail() throws KeeperException {
        if (this.stepsToFail.getAndDecrement() == 0 || this.alwaysFail) {
            throw KeeperException.create((KeeperException.Code)this.failReturnCode);
        }
    }

    boolean getProgrammedFailStatus() {
        return this.stepsToFail.getAndDecrement() == 0;
    }

    public void failNow(KeeperException.Code rc) {
        this.failAfter(0, rc);
    }

    public void setAlwaysFail(KeeperException.Code rc) {
        this.alwaysFail = true;
        this.failReturnCode = rc;
    }

    public void unsetAlwaysFail() {
        this.alwaysFail = false;
    }

    public void failAfter(int steps, KeeperException.Code rc) {
        this.stepsToFail.set(steps);
        this.failReturnCode = rc;
    }

    public void setSessionId(long id) {
        this.sessionId = id;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    private boolean hasChildren(String path) {
        return !this.tree.subMap(path + '/', path + '0').isEmpty();
    }

    public String toString() {
        return "MockZookeeper";
    }

    private void checkReadOpDelay() {
        if (this.readOpDelayMs > 0) {
            try {
                Thread.sleep(this.readOpDelayMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

