/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class PortManager {
    private static final String lockFilename = System.getProperty("test.lockFilename", "/tmp/pulsar-test-port-manager.lock");
    private static final int basePort = Integer.valueOf(System.getProperty("test.basePort", "15000"));
    private static final int maxPort = 32000;
    private static final int MAX_PORT_CONFLICTS = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int nextFreePort() {
        int n;
        Path path = Paths.get(lockFilename, new String[0]);
        FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        FileLock lock = fileChannel.lock();
        try {
            FileReader reader = new FileReader(lockFilename);
            CharBuffer buffer = CharBuffer.allocate(16);
            int len = reader.read(buffer);
            buffer.flip();
            int lastUsedPort = basePort;
            if (len > 0) {
                String lastUsedPortStr = buffer.toString();
                lastUsedPort = Integer.parseInt(lastUsedPortStr);
            }
            int freePort = PortManager.probeFreePort(lastUsedPort + 1);
            FileWriter writer = new FileWriter(lockFilename);
            writer.write(Integer.toString(freePort));
            reader.close();
            writer.close();
            n = freePort;
        }
        catch (Throwable throwable) {
            try {
                lock.release();
                fileChannel.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        lock.release();
        fileChannel.close();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized int probeFreePort(int port) {
        int exceptionCount = 0;
        while (true) {
            if (port == 32000) {
                port = basePort;
            }
            try (ServerSocket ss = new ServerSocket(port);){
                ss.close();
                Thread.sleep(100L);
                int n = port;
                return n;
            }
            catch (Exception e) {
                ++port;
                if (++exceptionCount <= 10) continue;
                throw new RuntimeException(e);
            }
            break;
        }
    }
}

