/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.util;

import org.apache.bookkeeper.mledger.util.StatsBuckets;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStatsBuckets {
    @Test
    public void testInvalidConstructor() {
        try {
            new StatsBuckets(new long[0]);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnorderedBoundaries() {
        try {
            new StatsBuckets(new long[]{2L, 1L});
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test() {
        StatsBuckets stats = new StatsBuckets(new long[]{10L, 20L, 30L});
        Assert.assertEquals((Object)stats.getAvg(), (Object)Double.NaN);
        Assert.assertEquals((long)stats.getSum(), (long)0L);
        Assert.assertEquals((long)stats.getCount(), (long)0L);
        Assert.assertEquals((long[])stats.getBuckets(), (long[])new long[]{0L, 0L, 0L, 0L});
        stats.addValue(5L);
        Assert.assertEquals((Object)stats.getAvg(), (Object)Double.NaN);
        Assert.assertEquals((long)stats.getSum(), (long)0L);
        Assert.assertEquals((long)stats.getCount(), (long)0L);
        Assert.assertEquals((long[])stats.getBuckets(), (long[])new long[]{0L, 0L, 0L, 0L});
        stats.refresh();
        Assert.assertEquals((Object)stats.getAvg(), (Object)5.0);
        Assert.assertEquals((long)stats.getSum(), (long)5L);
        Assert.assertEquals((long)stats.getCount(), (long)1L);
        Assert.assertEquals((long[])stats.getBuckets(), (long[])new long[]{1L, 0L, 0L, 0L});
        stats.addValue(15L);
        Assert.assertEquals((Object)stats.getAvg(), (Object)5.0);
        Assert.assertEquals((long)stats.getSum(), (long)5L);
        Assert.assertEquals((long)stats.getCount(), (long)1L);
        Assert.assertEquals((long[])stats.getBuckets(), (long[])new long[]{1L, 0L, 0L, 0L});
        stats.refresh();
        Assert.assertEquals((Object)stats.getAvg(), (Object)15.0);
        Assert.assertEquals((long)stats.getSum(), (long)15L);
        Assert.assertEquals((long)stats.getCount(), (long)1L);
        Assert.assertEquals((long[])stats.getBuckets(), (long[])new long[]{0L, 1L, 0L, 0L});
        stats.addValue(50L);
        Assert.assertEquals((long)stats.getSum(), (long)15L);
        Assert.assertEquals((long)stats.getCount(), (long)1L);
        stats.addValue(10L);
        stats.addValue(30L);
        stats.refresh();
        Assert.assertEquals((Object)stats.getAvg(), (Object)30.0);
        Assert.assertEquals((long)stats.getSum(), (long)90L);
        Assert.assertEquals((long)stats.getCount(), (long)3L);
        Assert.assertEquals((long[])stats.getBuckets(), (long[])new long[]{1L, 0L, 1L, 1L});
    }
}

