/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.util;

import com.google.common.collect.Lists;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCounted;
import java.util.Collection;
import org.apache.bookkeeper.mledger.util.RangeCache;
import org.apache.commons.lang3.tuple.Pair;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class RangeCacheTest {
    @Test
    void simple() {
        RangeCache cache = new RangeCache();
        cache.put((Comparable)Integer.valueOf(0), (ReferenceCounted)new RefString("0"));
        cache.put((Comparable)Integer.valueOf(1), (ReferenceCounted)new RefString("1"));
        Assert.assertEquals((long)cache.getSize(), (long)2L);
        Assert.assertEquals((long)cache.getNumberOfEntries(), (long)2L);
        RefString s = (RefString)cache.get((Comparable)Integer.valueOf(0));
        Assert.assertEquals((String)s.s, (String)"0");
        Assert.assertEquals((int)s.refCnt(), (int)2);
        s.release();
        RefString s1 = (RefString)cache.get((Comparable)Integer.valueOf(0));
        RefString s2 = (RefString)cache.get((Comparable)Integer.valueOf(0));
        Assert.assertEquals((Object)((Object)s1), (Object)((Object)s2));
        Assert.assertEquals((int)s1.refCnt(), (int)3);
        s1.release();
        s2.release();
        Assert.assertEquals((Object)cache.get((Comparable)Integer.valueOf(2)), null);
        cache.put((Comparable)Integer.valueOf(2), (ReferenceCounted)new RefString("2"));
        cache.put((Comparable)Integer.valueOf(8), (ReferenceCounted)new RefString("8"));
        cache.put((Comparable)Integer.valueOf(11), (ReferenceCounted)new RefString("11"));
        Assert.assertEquals((long)cache.getSize(), (long)5L);
        Assert.assertEquals((long)cache.getNumberOfEntries(), (long)5L);
        cache.removeRange((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5), true);
        Assert.assertEquals((long)cache.getSize(), (long)3L);
        Assert.assertEquals((long)cache.getNumberOfEntries(), (long)3L);
        cache.removeRange((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8), false);
        Assert.assertEquals((long)cache.getSize(), (long)3L);
        Assert.assertEquals((long)cache.getNumberOfEntries(), (long)3L);
        cache.removeRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100), false);
        Assert.assertEquals((long)cache.getSize(), (long)0L);
        Assert.assertEquals((long)cache.getNumberOfEntries(), (long)0L);
        cache.removeRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100), false);
        Assert.assertEquals((long)cache.getSize(), (long)0L);
        Assert.assertEquals((long)cache.getNumberOfEntries(), (long)0L);
    }

    @Test
    void customWeighter() {
        RangeCache cache = new RangeCache(value -> value.s.length());
        cache.put((Comparable)Integer.valueOf(0), (ReferenceCounted)new RefString("zero"));
        cache.put((Comparable)Integer.valueOf(1), (ReferenceCounted)new RefString("one"));
        Assert.assertEquals((long)cache.getSize(), (long)7L);
        Assert.assertEquals((long)cache.getNumberOfEntries(), (long)2L);
    }

    @Test
    void doubleInsert() {
        RangeCache cache = new RangeCache();
        RefString s0 = new RefString("zero");
        Assert.assertEquals((int)s0.refCnt(), (int)1);
        Assert.assertEquals((boolean)cache.put((Comparable)Integer.valueOf(0), (ReferenceCounted)s0), (boolean)true);
        Assert.assertEquals((int)s0.refCnt(), (int)1);
        cache.put((Comparable)Integer.valueOf(1), (ReferenceCounted)new RefString("one"));
        Assert.assertEquals((long)cache.getSize(), (long)2L);
        Assert.assertEquals((long)cache.getNumberOfEntries(), (long)2L);
        RefString s = (RefString)cache.get((Comparable)Integer.valueOf(1));
        Assert.assertEquals((String)s.s, (String)"one");
        Assert.assertEquals((int)s.refCnt(), (int)2);
        RefString s1 = new RefString("uno");
        Assert.assertEquals((int)s1.refCnt(), (int)1);
        Assert.assertEquals((boolean)cache.put((Comparable)Integer.valueOf(1), (ReferenceCounted)s1), (boolean)false);
        Assert.assertEquals((int)s1.refCnt(), (int)1);
        s1.release();
        Assert.assertEquals((long)cache.getSize(), (long)2L);
        Assert.assertEquals((long)cache.getNumberOfEntries(), (long)2L);
        Assert.assertEquals((String)((RefString)cache.get((Comparable)Integer.valueOf((int)1))).s, (String)"one");
    }

    @Test
    void getRange() {
        RangeCache cache = new RangeCache();
        cache.put((Comparable)Integer.valueOf(0), (ReferenceCounted)new RefString("0"));
        cache.put((Comparable)Integer.valueOf(1), (ReferenceCounted)new RefString("1"));
        cache.put((Comparable)Integer.valueOf(3), (ReferenceCounted)new RefString("3"));
        cache.put((Comparable)Integer.valueOf(5), (ReferenceCounted)new RefString("5"));
        Assert.assertEquals((Collection)cache.getRange((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(8)), (Collection)Lists.newArrayList((Object[])new RefString[]{new RefString("1"), new RefString("3"), new RefString("5")}));
        cache.put((Comparable)Integer.valueOf(8), (ReferenceCounted)new RefString("8"));
        Assert.assertEquals((Collection)cache.getRange((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(8)), (Collection)Lists.newArrayList((Object[])new RefString[]{new RefString("1"), new RefString("3"), new RefString("5"), new RefString("8")}));
        cache.clear();
        Assert.assertEquals((long)cache.getSize(), (long)0L);
        Assert.assertEquals((long)cache.getNumberOfEntries(), (long)0L);
    }

    @Test
    void eviction() {
        RangeCache cache = new RangeCache(value -> value.s.length());
        cache.put((Comparable)Integer.valueOf(0), (ReferenceCounted)new RefString("zero"));
        cache.put((Comparable)Integer.valueOf(1), (ReferenceCounted)new RefString("one"));
        cache.put((Comparable)Integer.valueOf(2), (ReferenceCounted)new RefString("two"));
        cache.put((Comparable)Integer.valueOf(3), (ReferenceCounted)new RefString("three"));
        Assert.assertEquals((Object)cache.evictLeastAccessedEntries(5L), (Object)Pair.of((Object)2, (Object)7L));
        Assert.assertEquals((long)cache.getNumberOfEntries(), (long)2L);
        Assert.assertEquals((long)cache.getSize(), (long)8L);
        Assert.assertEquals((Object)cache.get((Comparable)Integer.valueOf(0)), null);
        Assert.assertEquals((Object)cache.get((Comparable)Integer.valueOf(1)), null);
        Assert.assertEquals((String)((RefString)cache.get((Comparable)Integer.valueOf((int)2))).s, (String)"two");
        Assert.assertEquals((String)((RefString)cache.get((Comparable)Integer.valueOf((int)3))).s, (String)"three");
        Assert.assertEquals((Object)cache.evictLeastAccessedEntries(100L), (Object)Pair.of((Object)2, (Object)8L));
        Assert.assertEquals((long)cache.getNumberOfEntries(), (long)0L);
        Assert.assertEquals((long)cache.getSize(), (long)0L);
        Assert.assertEquals((Object)cache.get((Comparable)Integer.valueOf(0)), null);
        Assert.assertEquals((Object)cache.get((Comparable)Integer.valueOf(1)), null);
        Assert.assertEquals((Object)cache.get((Comparable)Integer.valueOf(2)), null);
        Assert.assertEquals((Object)cache.get((Comparable)Integer.valueOf(3)), null);
        try {
            cache.evictLeastAccessedEntries(0L);
            Assert.fail((String)"should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            cache.evictLeastAccessedEntries(-1L);
            Assert.fail((String)"should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void evictions() {
        RangeCache cache = new RangeCache();
        for (int i = 0; i < 100; ++i) {
            cache.put((Comparable)Integer.valueOf(i), (ReferenceCounted)new RefString(Integer.toString(i)));
        }
        Assert.assertEquals((long)cache.getSize(), (long)100L);
        Pair res = cache.evictLeastAccessedEntries(1L);
        Assert.assertEquals((int)((Integer)res.getLeft()), (int)1);
        Assert.assertEquals((long)((Long)res.getRight()), (long)1L);
        Assert.assertEquals((long)cache.getSize(), (long)99L);
        res = cache.evictLeastAccessedEntries(10L);
        Assert.assertEquals((int)((Integer)res.getLeft()), (int)10);
        Assert.assertEquals((long)((Long)res.getRight()), (long)10L);
        Assert.assertEquals((long)cache.getSize(), (long)89L);
        res = cache.evictLeastAccessedEntries(100L);
        Assert.assertEquals((int)((Integer)res.getLeft()), (int)89);
        Assert.assertEquals((long)((Long)res.getRight()), (long)89L);
        Assert.assertEquals((long)cache.getSize(), (long)0L);
        for (int i = 0; i < 100; ++i) {
            cache.put((Comparable)Integer.valueOf(i), (ReferenceCounted)new RefString(Integer.toString(i)));
        }
        Assert.assertEquals((long)cache.getSize(), (long)100L);
        res = cache.removeRange((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20), false);
        Assert.assertEquals((int)((Integer)res.getLeft()), (int)10);
        Assert.assertEquals((long)((Long)res.getRight()), (long)10L);
        Assert.assertEquals((long)cache.getSize(), (long)90L);
    }

    class RefString
    extends AbstractReferenceCounted
    implements ReferenceCounted {
        final String s;

        RefString(String s) {
            this.s = s;
            this.setRefCnt(1);
        }

        protected void deallocate() {
        }

        public ReferenceCounted touch(Object hint) {
            return this;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RefString) {
                return this.s.equals(((RefString)((Object)obj)).s);
            }
            if (obj instanceof String) {
                return this.s.equals((String)obj);
            }
            return false;
        }
    }
}

