/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.ReadOnlyCursor;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReadOnlyCursorTest
extends MockedBookKeeperTestCase {
    @Test
    void notFound() throws Exception {
        try {
            this.factory.openReadOnlyCursor("notFound", (Position)PositionImpl.earliest, new ManagedLedgerConfig());
            Assert.fail((String)"Should have failed");
        }
        catch (ManagedLedgerException.ManagedLedgerNotFoundException managedLedgerNotFoundException) {
            // empty catch block
        }
        this.factory.shutdown();
    }

    @Test
    void simple() throws Exception {
        ManagedLedger ledger = this.factory.open("simple", new ManagedLedgerConfig().setRetentionTime(1, TimeUnit.HOURS));
        int N = 10;
        for (int i = 0; i < N; ++i) {
            ledger.addEntry(("entry-" + i).getBytes());
        }
        ReadOnlyCursor cursor = this.factory.openReadOnlyCursor("simple", (Position)PositionImpl.earliest, new ManagedLedgerConfig());
        Assert.assertEquals((long)cursor.getNumberOfEntries(), (long)N);
        Assert.assertTrue((boolean)cursor.hasMoreEntries());
        List entries = cursor.readEntries(N);
        Assert.assertEquals((int)entries.size(), (int)N);
        Assert.assertEquals((long)cursor.getNumberOfEntries(), (long)0L);
        Assert.assertFalse((boolean)cursor.hasMoreEntries());
        entries.forEach(Entry::release);
        cursor.close();
        for (int i = 0; i < N; ++i) {
            ledger.addEntry(("entry-" + i).getBytes());
        }
        cursor = this.factory.openReadOnlyCursor("simple", (Position)PositionImpl.earliest, new ManagedLedgerConfig());
        Assert.assertEquals((long)cursor.getNumberOfEntries(), (long)(2 * N));
        Assert.assertTrue((boolean)cursor.hasMoreEntries());
        entries = cursor.readEntries(N);
        Assert.assertEquals((int)entries.size(), (int)N);
        Assert.assertEquals((long)cursor.getNumberOfEntries(), (long)N);
        Assert.assertTrue((boolean)cursor.hasMoreEntries());
        entries.forEach(Entry::release);
        entries = cursor.readEntries(N);
        Assert.assertEquals((int)entries.size(), (int)N);
        Assert.assertEquals((long)cursor.getNumberOfEntries(), (long)0L);
        Assert.assertFalse((boolean)cursor.hasMoreEntries());
        entries.forEach(Entry::release);
        cursor.close();
    }

    @Test
    void skip() throws Exception {
        ManagedLedger ledger = this.factory.open("skip", new ManagedLedgerConfig().setMaxEntriesPerLedger(2).setRetentionTime(1, TimeUnit.HOURS));
        int N = 10;
        for (int i = 0; i < N; ++i) {
            ledger.addEntry(("entry-" + i).getBytes());
        }
        ReadOnlyCursor cursor = this.factory.openReadOnlyCursor("skip", (Position)PositionImpl.earliest, new ManagedLedgerConfig());
        Assert.assertEquals((long)cursor.getNumberOfEntries(), (long)N);
        Assert.assertTrue((boolean)cursor.hasMoreEntries());
        cursor.skipEntries(5);
        Assert.assertEquals((long)cursor.getNumberOfEntries(), (long)(N - 5));
        Assert.assertTrue((boolean)cursor.hasMoreEntries());
        cursor.close();
    }

    @Test
    void skipAll() throws Exception {
        ManagedLedger ledger = this.factory.open("skip-all", new ManagedLedgerConfig().setMaxEntriesPerLedger(7).setRetentionTime(1, TimeUnit.HOURS));
        int N = 10;
        for (int i = 0; i < N; ++i) {
            ledger.addEntry(("entry-" + i).getBytes());
        }
        ReadOnlyCursor cursor = this.factory.openReadOnlyCursor("skip-all", (Position)PositionImpl.earliest, new ManagedLedgerConfig());
        Assert.assertEquals((long)cursor.getNumberOfEntries(), (long)N);
        Assert.assertTrue((boolean)cursor.hasMoreEntries());
        cursor.skipEntries(N);
        Assert.assertEquals((long)cursor.getNumberOfEntries(), (long)0L);
        Assert.assertFalse((boolean)cursor.hasMoreEntries());
        cursor.close();
    }

    @Test
    void skipMultiple() throws Exception {
        ManagedLedger ledger = this.factory.open("skip", new ManagedLedgerConfig().setMaxEntriesPerLedger(7).setRetentionTime(1, TimeUnit.HOURS));
        int N = 30;
        for (int i = 0; i < N; ++i) {
            ledger.addEntry(("entry-" + i).getBytes());
        }
        ReadOnlyCursor cursor = this.factory.openReadOnlyCursor("skip", (Position)PositionImpl.earliest, new ManagedLedgerConfig());
        Assert.assertEquals((long)cursor.getNumberOfEntries(), (long)N);
        Assert.assertTrue((boolean)cursor.hasMoreEntries());
        cursor.skipEntries(25);
        Assert.assertEquals((long)cursor.getNumberOfEntries(), (long)5L);
        Assert.assertTrue((boolean)cursor.hasMoreEntries());
        cursor.skipEntries(5);
        Assert.assertEquals((long)cursor.getNumberOfEntries(), (long)0L);
        Assert.assertFalse((boolean)cursor.hasMoreEntries());
        cursor.close();
    }

    @Test
    void empty() throws Exception {
        this.factory.open("empty", new ManagedLedgerConfig().setRetentionTime(1, TimeUnit.HOURS));
        ReadOnlyCursor cursor = this.factory.openReadOnlyCursor("empty", (Position)PositionImpl.earliest, new ManagedLedgerConfig());
        Assert.assertEquals((long)cursor.getNumberOfEntries(), (long)0L);
        Assert.assertFalse((boolean)cursor.hasMoreEntries());
        cursor.close();
    }

    @Test
    void specifyStartPosition() throws Exception {
        ManagedLedger ledger = this.factory.open("simple", new ManagedLedgerConfig().setRetentionTime(1, TimeUnit.HOURS));
        int N = 10;
        for (int i = 0; i < N; ++i) {
            ledger.addEntry(("entry-" + i).getBytes());
        }
        ReadOnlyCursor cursor = this.factory.openReadOnlyCursor("simple", (Position)PositionImpl.earliest, new ManagedLedgerConfig());
        Assert.assertEquals((long)cursor.getNumberOfEntries(), (long)N);
        Assert.assertTrue((boolean)cursor.hasMoreEntries());
        Position readPosition = cursor.getReadPosition();
        cursor = this.factory.openReadOnlyCursor("simple", readPosition, new ManagedLedgerConfig());
        Assert.assertEquals((long)cursor.getNumberOfEntries(), (long)N);
        Assert.assertTrue((boolean)cursor.hasMoreEntries());
        cursor.skipEntries(5);
        Position newReadPosition = cursor.getReadPosition();
        cursor = this.factory.openReadOnlyCursor("simple", newReadPosition, new ManagedLedgerConfig());
        Assert.assertEquals((long)cursor.getNumberOfEntries(), (long)(N - 5));
        Assert.assertTrue((boolean)cursor.hasMoreEntries());
    }
}

