/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.time.Clock;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.bookkeeper.mledger.LedgerOffloader;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.OffloadPrefixTest;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.mledger.util.MockClock;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class OffloadLedgerDeleteTest
extends MockedBookKeeperTestCase {
    private static final Logger log = LoggerFactory.getLogger(OffloadLedgerDeleteTest.class);

    @Test
    public void testLaggedDelete() throws Exception {
        OffloadPrefixTest.MockLedgerOffloader offloader = new OffloadPrefixTest.MockLedgerOffloader();
        ManagedLedgerConfig config = new ManagedLedgerConfig();
        MockClock clock = new MockClock();
        config.setMaxEntriesPerLedger(10);
        config.setMinimumRolloverTime(0, TimeUnit.SECONDS);
        config.setRetentionTime(10, TimeUnit.MINUTES);
        config.setOffloadLedgerDeletionLag(5L, TimeUnit.MINUTES);
        config.setLedgerOffloader((LedgerOffloader)offloader);
        config.setClock((Clock)clock);
        ManagedLedgerImpl ledger = (ManagedLedgerImpl)this.factory.open("my_test_ledger", config);
        for (int i = 0; i < 15; ++i) {
            String content = "entry-" + i;
            ledger.addEntry(content.getBytes());
        }
        Assert.assertEquals((int)ledger.getLedgersInfoAsList().size(), (int)2);
        long firstLedgerId = ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledger.getLedgersInfoAsList().get(0)).getLedgerId();
        ledger.offloadPrefix(ledger.getLastConfirmedEntry());
        Assert.assertEquals((int)ledger.getLedgersInfoAsList().size(), (int)2);
        Assert.assertEquals(ledger.getLedgersInfoAsList().stream().filter(e -> e.getOffloadContext().getComplete()).map(e -> e.getLedgerId()).collect(Collectors.toSet()), offloader.offloadedLedgers());
        Assert.assertTrue((boolean)this.bkc.getLedgers().contains(firstLedgerId));
        clock.advance(2L, TimeUnit.MINUTES);
        CompletableFuture promise = new CompletableFuture();
        ledger.internalTrimConsumedLedgers(promise);
        promise.join();
        Assert.assertTrue((boolean)this.bkc.getLedgers().contains(firstLedgerId));
        clock.advance(5L, TimeUnit.MINUTES);
        CompletableFuture promise2 = new CompletableFuture();
        ledger.internalTrimConsumedLedgers(promise2);
        promise2.join();
        OffloadPrefixTest.assertEventuallyTrue(() -> !this.bkc.getLedgers().contains(firstLedgerId));
        Assert.assertEquals(ledger.getLedgersInfoAsList().stream().filter(e -> e.getOffloadContext().getComplete()).map(e -> e.getLedgerId()).collect(Collectors.toSet()), offloader.offloadedLedgers());
        clock.advance(5L, TimeUnit.MINUTES);
        CompletableFuture promise3 = new CompletableFuture();
        ledger.internalTrimConsumedLedgers(promise3);
        promise3.join();
        Assert.assertEquals((int)ledger.getLedgersInfoAsList().size(), (int)1);
        OffloadPrefixTest.assertEventuallyTrue(() -> offloader.deletedOffloads().contains(firstLedgerId));
    }

    @Test
    public void testLaggedDeleteRetentionSetLower() throws Exception {
        OffloadPrefixTest.MockLedgerOffloader offloader = new OffloadPrefixTest.MockLedgerOffloader();
        ManagedLedgerConfig config = new ManagedLedgerConfig();
        MockClock clock = new MockClock();
        config.setMaxEntriesPerLedger(10);
        config.setMinimumRolloverTime(0, TimeUnit.SECONDS);
        config.setRetentionTime(5, TimeUnit.MINUTES);
        config.setOffloadLedgerDeletionLag(10L, TimeUnit.MINUTES);
        config.setLedgerOffloader((LedgerOffloader)offloader);
        config.setClock((Clock)clock);
        ManagedLedgerImpl ledger = (ManagedLedgerImpl)this.factory.open("my_test_ledger", config);
        for (int i = 0; i < 15; ++i) {
            String content = "entry-" + i;
            ledger.addEntry(content.getBytes());
        }
        Assert.assertEquals((int)ledger.getLedgersInfoAsList().size(), (int)2);
        long firstLedgerId = ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledger.getLedgersInfoAsList().get(0)).getLedgerId();
        ledger.offloadPrefix(ledger.getLastConfirmedEntry());
        Assert.assertEquals((int)ledger.getLedgersInfoAsList().size(), (int)2);
        Assert.assertEquals(ledger.getLedgersInfoAsList().stream().filter(e -> e.getOffloadContext().getComplete()).map(e -> e.getLedgerId()).collect(Collectors.toSet()), offloader.offloadedLedgers());
        Assert.assertTrue((boolean)this.bkc.getLedgers().contains(firstLedgerId));
        clock.advance(2L, TimeUnit.MINUTES);
        CompletableFuture promise = new CompletableFuture();
        ledger.internalTrimConsumedLedgers(promise);
        promise.join();
        Assert.assertTrue((boolean)this.bkc.getLedgers().contains(firstLedgerId));
        clock.advance(5L, TimeUnit.MINUTES);
        CompletableFuture promise2 = new CompletableFuture();
        ledger.internalTrimConsumedLedgers(promise2);
        promise2.join();
        OffloadPrefixTest.assertEventuallyTrue(() -> !this.bkc.getLedgers().contains(firstLedgerId));
        OffloadPrefixTest.assertEventuallyTrue(() -> offloader.deletedOffloads().contains(firstLedgerId));
    }

    @Test
    public void testLaggedDeleteSlowConsumer() throws Exception {
        OffloadPrefixTest.MockLedgerOffloader offloader = new OffloadPrefixTest.MockLedgerOffloader();
        ManagedLedgerConfig config = new ManagedLedgerConfig();
        MockClock clock = new MockClock();
        config.setMaxEntriesPerLedger(10);
        config.setMinimumRolloverTime(0, TimeUnit.SECONDS);
        config.setRetentionTime(10, TimeUnit.MINUTES);
        config.setOffloadLedgerDeletionLag(5L, TimeUnit.MINUTES);
        config.setLedgerOffloader((LedgerOffloader)offloader);
        config.setClock((Clock)clock);
        ManagedLedgerImpl ledger = (ManagedLedgerImpl)this.factory.open("my_test_ledger", config);
        ManagedCursor cursor = ledger.openCursor("sub1");
        for (int i = 0; i < 15; ++i) {
            String content = "entry-" + i;
            ledger.addEntry(content.getBytes());
        }
        Assert.assertEquals((int)ledger.getLedgersInfoAsList().size(), (int)2);
        long firstLedgerId = ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledger.getLedgersInfoAsList().get(0)).getLedgerId();
        ledger.offloadPrefix(ledger.getLastConfirmedEntry());
        Assert.assertEquals((int)ledger.getLedgersInfoAsList().size(), (int)2);
        Assert.assertEquals(ledger.getLedgersInfoAsList().stream().filter(e -> e.getOffloadContext().getComplete()).map(e -> e.getLedgerId()).collect(Collectors.toSet()), offloader.offloadedLedgers());
        Assert.assertTrue((boolean)this.bkc.getLedgers().contains(firstLedgerId));
        clock.advance(2L, TimeUnit.MINUTES);
        CompletableFuture promise = new CompletableFuture();
        ledger.internalTrimConsumedLedgers(promise);
        promise.join();
        Assert.assertTrue((boolean)this.bkc.getLedgers().contains(firstLedgerId));
        clock.advance(5L, TimeUnit.MINUTES);
        CompletableFuture promise2 = new CompletableFuture();
        ledger.internalTrimConsumedLedgers(promise2);
        promise2.join();
        OffloadPrefixTest.assertEventuallyTrue(() -> !this.bkc.getLedgers().contains(firstLedgerId));
        Assert.assertEquals(ledger.getLedgersInfoAsList().stream().filter(e -> e.getOffloadContext().getComplete()).map(e -> e.getLedgerId()).collect(Collectors.toSet()), offloader.offloadedLedgers());
    }
}

