/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.impl.MetaStore;
import org.apache.bookkeeper.mledger.impl.MetaStoreImplZookeeper;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MetaStoreImplZookeeperTest
extends MockedBookKeeperTestCase {
    @Test
    void getMLList() throws Exception {
        MetaStoreImplZookeeper store = new MetaStoreImplZookeeper((ZooKeeper)this.zkc, (OrderedExecutor)this.executor);
        this.zkc.failNow(KeeperException.Code.CONNECTIONLOSS);
        try {
            store.getManagedLedgers();
            Assert.fail((String)"should fail in getting the list");
        }
        catch (ManagedLedgerException.MetaStoreException metaStoreException) {
            // empty catch block
        }
    }

    @Test
    void deleteNonExistingML() throws Exception {
        MetaStoreImplZookeeper store = new MetaStoreImplZookeeper((ZooKeeper)this.zkc, (OrderedExecutor)this.executor);
        final AtomicReference exception = new AtomicReference();
        final CountDownLatch counter = new CountDownLatch(1);
        store.removeManagedLedger("non-existing", (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<Void>(){

            public void operationComplete(Void result, MetaStore.Stat version) {
                counter.countDown();
            }

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                exception.set(e);
                counter.countDown();
            }
        });
        counter.await();
        Assert.assertNotNull(exception.get());
    }

    @Test(timeOut=20000L)
    void readMalformedML() throws Exception {
        MetaStoreImplZookeeper store = new MetaStoreImplZookeeper((ZooKeeper)this.zkc, (OrderedExecutor)this.executor);
        this.zkc.create("/managed-ledgers/my_test", "non-valid".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        final CountDownLatch latch = new CountDownLatch(1);
        store.getManagedLedgerInfo("my_test", false, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>(){

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                latch.countDown();
            }

            public void operationComplete(MLDataFormats.ManagedLedgerInfo result, MetaStore.Stat version) {
                Assert.fail((String)"Operation should have failed");
            }
        });
        latch.await();
    }

    @Test(timeOut=20000L)
    void readMalformedCursorNode() throws Exception {
        MetaStoreImplZookeeper store = new MetaStoreImplZookeeper((ZooKeeper)this.zkc, (OrderedExecutor)this.executor);
        this.zkc.create("/managed-ledgers/my_test", "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zkc.create("/managed-ledgers/my_test/c1", "non-valid".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        final CountDownLatch latch = new CountDownLatch(1);
        store.asyncGetCursorInfo("my_test", "c1", (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<MLDataFormats.ManagedCursorInfo>(){

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                latch.countDown();
            }

            public void operationComplete(MLDataFormats.ManagedCursorInfo result, MetaStore.Stat version) {
                Assert.fail((String)"Operation should have failed");
            }
        });
        latch.await();
    }

    @Test(timeOut=20000L)
    void failInCreatingMLnode() throws Exception {
        MetaStoreImplZookeeper store = new MetaStoreImplZookeeper((ZooKeeper)this.zkc, (OrderedExecutor)this.executor);
        final CountDownLatch latch = new CountDownLatch(1);
        this.zkc.failAfter(1, KeeperException.Code.CONNECTIONLOSS);
        store.getManagedLedgerInfo("my_test", false, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>(){

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                latch.countDown();
            }

            public void operationComplete(MLDataFormats.ManagedLedgerInfo result, MetaStore.Stat version) {
                Assert.fail((String)"Operation should have failed");
            }
        });
        latch.await();
    }

    @Test(timeOut=20000L)
    void updatingCursorNode() throws Exception {
        MetaStoreImplZookeeper store = new MetaStoreImplZookeeper((ZooKeeper)this.zkc, (OrderedExecutor)this.executor);
        this.zkc.create("/managed-ledgers/my_test", "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CountDownLatch latch = new CountDownLatch(1);
        MLDataFormats.ManagedCursorInfo info = MLDataFormats.ManagedCursorInfo.newBuilder().setCursorsLedgerId(1L).build();
        store.asyncUpdateCursorInfo("my_test", "c1", info, null, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<Void>((MetaStore)store, latch){
            final /* synthetic */ MetaStore val$store;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$store = metaStore;
                this.val$latch = countDownLatch;
            }

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                Assert.fail((String)"should have succeeded");
            }

            public void operationComplete(Void result, MetaStore.Stat version) {
                MetaStoreImplZookeeperTest.this.zkc.failNow(KeeperException.Code.CONNECTIONLOSS);
                MLDataFormats.ManagedCursorInfo info = MLDataFormats.ManagedCursorInfo.newBuilder().setCursorsLedgerId(2L).build();
                this.val$store.asyncUpdateCursorInfo("my_test", "c1", info, version, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<Void>(){

                    public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                        val$latch.countDown();
                    }

                    public void operationComplete(Void result, MetaStore.Stat version) {
                        Assert.fail((String)"should have failed");
                    }
                });
            }
        });
        latch.await();
    }

    @Test(timeOut=20000L)
    void updatingMLNode() throws Exception {
        MetaStoreImplZookeeper store = new MetaStoreImplZookeeper((ZooKeeper)this.zkc, (OrderedExecutor)this.executor);
        this.zkc.create("/managed-ledgers/my_test", "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CountDownLatch latch = new CountDownLatch(1);
        store.getManagedLedgerInfo("my_test", false, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>((MetaStore)store, latch){
            final /* synthetic */ MetaStore val$store;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$store = metaStore;
                this.val$latch = countDownLatch;
            }

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                Assert.fail((String)"should have succeeded");
            }

            public void operationComplete(MLDataFormats.ManagedLedgerInfo mlInfo, MetaStore.Stat version) {
                MetaStoreImplZookeeperTest.this.zkc.failNow(KeeperException.Code.BADVERSION);
                this.val$store.asyncUpdateLedgerIds("my_test", mlInfo, version, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<Void>(){

                    public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                        val$latch.countDown();
                    }

                    public void operationComplete(Void result, MetaStore.Stat version) {
                        Assert.fail((String)"should have failed");
                    }
                });
            }
        });
        latch.await();
    }

    @Test(timeOut=20000L)
    public void createOptimisticBaseNotExist() throws Exception {
        CompletableFuture promise = new CompletableFuture();
        MetaStoreImplZookeeper store = new MetaStoreImplZookeeper((ZooKeeper)this.zkc, (OrderedExecutor)this.executor);
        store.asyncCreateFullPathOptimistic("/foo", "bar/zar/gar", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, (rc, path, ctx, name) -> {
            if (rc != KeeperException.Code.OK.intValue()) {
                promise.completeExceptionally((Throwable)KeeperException.create((int)rc));
            } else {
                promise.complete(null);
            }
        });
        try {
            promise.get();
            Assert.fail((String)"should have failed");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(ee.getCause().getClass(), KeeperException.NoNodeException.class);
        }
    }

    @Test(timeOut=20000L)
    public void createOptimisticBaseExists() throws Exception {
        MetaStoreImplZookeeper store = new MetaStoreImplZookeeper((ZooKeeper)this.zkc, (OrderedExecutor)this.executor);
        this.zkc.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CompletableFuture promise = new CompletableFuture();
        store.asyncCreateFullPathOptimistic("/foo", "bar/zar/gar", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, (rc, path, ctx, name) -> {
            if (rc != KeeperException.Code.OK.intValue()) {
                promise.completeExceptionally((Throwable)KeeperException.create((int)rc));
            } else {
                promise.complete(null);
            }
        });
        promise.get();
        CompletableFuture promise2 = new CompletableFuture();
        store.asyncCreateFullPathOptimistic("/foo", "blah", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, (rc, path, ctx, name) -> {
            if (rc != KeeperException.Code.OK.intValue()) {
                promise2.completeExceptionally((Throwable)KeeperException.create((int)rc));
            } else {
                promise2.complete(null);
            }
        });
        promise2.get();
    }
}

