/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ManagedLedgerTerminationTest
extends MockedBookKeeperTestCase {
    @Test(timeOut=20000L)
    public void terminateSimple() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        Position p0 = ledger.addEntry("entry-0".getBytes());
        Position lastPosition = ledger.terminate();
        Assert.assertEquals((Object)lastPosition, (Object)p0);
        try {
            ledger.addEntry("entry-1".getBytes());
        }
        catch (ManagedLedgerException.ManagedLedgerTerminatedException managedLedgerTerminatedException) {
            // empty catch block
        }
    }

    @Test(timeOut=20000L)
    public void terminateReopen() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        Position p0 = ledger.addEntry("entry-0".getBytes());
        Position lastPosition = ledger.terminate();
        Assert.assertEquals((Object)lastPosition, (Object)p0);
        ledger.close();
        ledger = this.factory.open("my_test_ledger");
        try {
            ledger.addEntry("entry-1".getBytes());
            Assert.fail((String)"Should have thrown exception");
        }
        catch (ManagedLedgerException.ManagedLedgerTerminatedException managedLedgerTerminatedException) {
            // empty catch block
        }
    }

    @Test(timeOut=20000L)
    public void terminateWithCursor() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ManagedCursor c1 = ledger.openCursor("c1");
        Position p0 = ledger.addEntry("entry-0".getBytes());
        Position p1 = ledger.addEntry("entry-1".getBytes());
        List entries = c1.readEntries(1);
        Assert.assertEquals((int)entries.size(), (int)1);
        Assert.assertEquals((Object)((Entry)entries.get(0)).getPosition(), (Object)p0);
        entries.forEach(Entry::release);
        Position lastPosition = ledger.terminate();
        Assert.assertEquals((Object)lastPosition, (Object)p1);
        entries = c1.readEntries(1);
        Assert.assertEquals((int)entries.size(), (int)1);
        Assert.assertEquals((Object)((Entry)entries.get(0)).getPosition(), (Object)p1);
        entries.forEach(Entry::release);
    }

    @Test(timeOut=20000L)
    public void terminateWithCursorReadOrWait() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ManagedCursor c1 = ledger.openCursor("c1");
        Position p0 = ledger.addEntry("entry-0".getBytes());
        Position p1 = ledger.addEntry("entry-1".getBytes());
        Assert.assertEquals((boolean)ledger.isTerminated(), (boolean)false);
        Position lastPosition = ledger.terminate();
        Assert.assertEquals((boolean)ledger.isTerminated(), (boolean)true);
        Assert.assertEquals((Object)lastPosition, (Object)p1);
        List entries = c1.readEntries(10);
        Assert.assertEquals((int)entries.size(), (int)2);
        Assert.assertEquals((Object)((Entry)entries.get(0)).getPosition(), (Object)p0);
        Assert.assertEquals((Object)((Entry)entries.get(1)).getPosition(), (Object)p1);
        entries.forEach(Entry::release);
        Assert.assertEquals((Collection)c1.readEntries(10), Collections.emptyList());
        try {
            c1.readEntriesOrWait(10);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (ManagedLedgerException.NoMoreEntriesToReadException noMoreEntriesToReadException) {
            // empty catch block
        }
    }

    @Test(timeOut=20000L)
    public void terminateWithNonDurableCursor() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        Position p0 = ledger.addEntry("entry-0".getBytes());
        Position p1 = ledger.addEntry("entry-1".getBytes());
        Assert.assertEquals((boolean)ledger.isTerminated(), (boolean)false);
        Position lastPosition = ledger.terminate();
        Assert.assertEquals((boolean)ledger.isTerminated(), (boolean)true);
        Assert.assertEquals((Object)lastPosition, (Object)p1);
        ManagedCursor c1 = ledger.newNonDurableCursor((Position)PositionImpl.earliest);
        List entries = c1.readEntries(10);
        Assert.assertEquals((int)entries.size(), (int)2);
        Assert.assertEquals((Object)((Entry)entries.get(0)).getPosition(), (Object)p0);
        Assert.assertEquals((Object)((Entry)entries.get(1)).getPosition(), (Object)p1);
        entries.forEach(Entry::release);
        Assert.assertEquals((Collection)c1.readEntries(10), Collections.emptyList());
        try {
            c1.readEntriesOrWait(10);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (ManagedLedgerException.NoMoreEntriesToReadException noMoreEntriesToReadException) {
            // empty catch block
        }
    }
}

