/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ManagedLedgerSingleBookieTest
extends MockedBookKeeperTestCase {
    private static final Charset Encoding = Charsets.UTF_8;

    public ManagedLedgerSingleBookieTest() {
        super(1);
    }

    @Test
    public void simple() throws Exception {
        ManagedLedgerConfig config = new ManagedLedgerConfig().setEnsembleSize(1).setWriteQuorumSize(1).setAckQuorumSize(1).setMetadataEnsembleSize(1).setMetadataWriteQuorumSize(1).setMetadataAckQuorumSize(1);
        ManagedLedger ledger = this.factory.open("my_test_ledger", config);
        Assert.assertEquals((long)ledger.getNumberOfEntries(), (long)0L);
        Assert.assertEquals((long)ledger.getTotalSize(), (long)0L);
        ledger.addEntry("dummy-entry-1".getBytes(Encoding));
        Assert.assertEquals((long)ledger.getNumberOfEntries(), (long)1L);
        Assert.assertEquals((long)ledger.getTotalSize(), (long)"dummy-entry-1".getBytes(Encoding).length);
        ManagedCursor cursor = ledger.openCursor("c1");
        Assert.assertEquals((boolean)cursor.hasMoreEntries(), (boolean)false);
        Assert.assertEquals((Collection)cursor.readEntries(100), new ArrayList());
        ledger.addEntry("dummy-entry-2".getBytes(Encoding));
        Assert.assertEquals((boolean)cursor.hasMoreEntries(), (boolean)true);
        List entries = cursor.readEntries(100);
        Assert.assertEquals((int)entries.size(), (int)1);
        entries.forEach(e -> e.release());
        entries = cursor.readEntries(100);
        Assert.assertEquals((int)entries.size(), (int)0);
        entries.forEach(e -> e.release());
        ledger.close();
    }
}

