/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryConfig;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerMBeanImpl;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.apache.zookeeper.ZooKeeper;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ManagedLedgerMBeanTest
extends MockedBookKeeperTestCase {
    private void waitForRefresh(ManagedLedgerMBeanImpl mbean) {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void simple() throws Exception {
        ManagedLedgerFactoryConfig config = new ManagedLedgerFactoryConfig();
        config.setMaxCacheSize(0L);
        ManagedLedgerFactoryImpl factory = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, (ZooKeeper)this.zkc, config);
        ManagedLedgerImpl ledger = (ManagedLedgerImpl)factory.open("my_test_ledger");
        ManagedCursor cursor = ledger.openCursor("c1");
        ManagedLedgerMBeanImpl mbean = ledger.mbean;
        Assert.assertEquals((String)mbean.getName(), (String)"my_test_ledger");
        Assert.assertEquals((long)mbean.getStoredMessagesSize(), (long)0L);
        Assert.assertEquals((long)mbean.getNumberOfMessagesInBacklog(), (long)0L);
        this.waitForRefresh(mbean);
        mbean.addAddEntryLatencySample(1L, TimeUnit.MILLISECONDS);
        mbean.addAddEntryLatencySample(10L, TimeUnit.MILLISECONDS);
        mbean.addAddEntryLatencySample(1L, TimeUnit.SECONDS);
        mbean.addLedgerSwitchLatencySample(1L, TimeUnit.MILLISECONDS);
        mbean.addLedgerSwitchLatencySample(10L, TimeUnit.MILLISECONDS);
        mbean.addLedgerSwitchLatencySample(1L, TimeUnit.SECONDS);
        factory.scheduledExecutor.submit(() -> mbean.refreshStats(1L, TimeUnit.SECONDS)).get();
        Assert.assertEquals((Object)mbean.getAddEntryBytesRate(), (Object)0.0);
        Assert.assertEquals((Object)mbean.getAddEntryMessagesRate(), (Object)0.0);
        Assert.assertEquals((long)mbean.getAddEntrySucceed(), (long)0L);
        Assert.assertEquals((long)mbean.getAddEntryErrors(), (long)0L);
        Assert.assertEquals((Object)mbean.getReadEntriesBytesRate(), (Object)0.0);
        Assert.assertEquals((Object)mbean.getReadEntriesRate(), (Object)0.0);
        Assert.assertEquals((long)mbean.getReadEntriesSucceeded(), (long)0L);
        Assert.assertEquals((long)mbean.getReadEntriesErrors(), (long)0L);
        Assert.assertEquals((Object)mbean.getMarkDeleteRate(), (Object)0.0);
        Assert.assertEquals((long[])mbean.getAddEntryLatencyBuckets(), (long[])new long[]{0L, 1L, 0L, 1L, 0L, 0L, 0L, 0L, 1L, 0L});
        Assert.assertEquals((Object)mbean.getAddEntryLatencyAverageUsec(), (Object)337000.0);
        Assert.assertEquals((long[])mbean.getEntrySizeBuckets(), (long[])new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L});
        Assert.assertEquals((long[])mbean.getLedgerSwitchLatencyBuckets(), (long[])new long[]{0L, 1L, 0L, 1L, 0L, 0L, 0L, 0L, 1L, 0L});
        Assert.assertEquals((Object)mbean.getLedgerSwitchLatencyAverageUsec(), (Object)337000.0);
        Position p1 = ledger.addEntry(new byte[200]);
        ledger.addEntry(new byte[600]);
        cursor.markDelete(p1);
        factory.scheduledExecutor.submit(() -> mbean.refreshStats(1L, TimeUnit.SECONDS)).get();
        Assert.assertEquals((Object)mbean.getAddEntryBytesRate(), (Object)800.0);
        Assert.assertEquals((Object)mbean.getAddEntryMessagesRate(), (Object)2.0);
        Assert.assertEquals((long)mbean.getAddEntrySucceed(), (long)2L);
        Assert.assertEquals((long)mbean.getAddEntryErrors(), (long)0L);
        Assert.assertEquals((Object)mbean.getReadEntriesBytesRate(), (Object)0.0);
        Assert.assertEquals((Object)mbean.getReadEntriesRate(), (Object)0.0);
        Assert.assertEquals((long)mbean.getReadEntriesSucceeded(), (long)0L);
        Assert.assertEquals((long)mbean.getReadEntriesErrors(), (long)0L);
        Assert.assertTrue((mbean.getMarkDeleteRate() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((long[])mbean.getEntrySizeBuckets(), (long[])new long[]{0L, 1L, 1L, 0L, 0L, 0L, 0L, 0L, 0L});
        mbean.recordAddEntryError();
        mbean.recordReadEntriesError();
        factory.scheduledExecutor.submit(() -> mbean.refreshStats(1L, TimeUnit.SECONDS)).get();
        Assert.assertEquals((long)mbean.getAddEntryErrors(), (long)1L);
        Assert.assertEquals((long)mbean.getReadEntriesErrors(), (long)1L);
        List entries = cursor.readEntries(100);
        Assert.assertEquals((int)entries.size(), (int)1);
        factory.scheduledExecutor.submit(() -> mbean.refreshStats(1L, TimeUnit.SECONDS)).get();
        Assert.assertEquals((Object)mbean.getReadEntriesBytesRate(), (Object)600.0);
        Assert.assertEquals((Object)mbean.getReadEntriesRate(), (Object)1.0);
        Assert.assertEquals((long)mbean.getReadEntriesSucceeded(), (long)1L);
        Assert.assertEquals((long)mbean.getReadEntriesErrors(), (long)0L);
        Assert.assertEquals((long)mbean.getNumberOfMessagesInBacklog(), (long)1L);
        Assert.assertEquals((Object)mbean.getMarkDeleteRate(), (Object)0.0);
        factory.shutdown();
    }
}

