/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ReadOnlyCursor;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.MetaStore;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.impl.ReadOnlyCursorImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;

public class ReadOnlyManagedLedgerImpl
extends ManagedLedgerImpl {
    public ReadOnlyManagedLedgerImpl(ManagedLedgerFactoryImpl factory, BookKeeper bookKeeper, MetaStore store, ManagedLedgerConfig config, OrderedScheduler scheduledExecutor, OrderedExecutor orderedExecutor, String name) {
        super(factory, bookKeeper, store, config, scheduledExecutor, orderedExecutor, name);
    }

    CompletableFuture<ReadOnlyCursor> initializeAndCreateCursor(final PositionImpl startPosition) {
        final CompletableFuture<ReadOnlyCursor> future = new CompletableFuture<ReadOnlyCursor>();
        this.store.getManagedLedgerInfo(this.name, false, new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>(){

            @Override
            public void operationComplete(MLDataFormats.ManagedLedgerInfo mlInfo, MetaStore.Stat stat) {
                ReadOnlyManagedLedgerImpl.this.state = ManagedLedgerImpl.State.LedgerOpened;
                for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls : mlInfo.getLedgerInfoList()) {
                    ReadOnlyManagedLedgerImpl.this.ledgers.put(ls.getLedgerId(), ls);
                }
                if (ReadOnlyManagedLedgerImpl.this.ledgers.size() > 0 && ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ReadOnlyManagedLedgerImpl.this.ledgers.lastEntry().getValue()).getEntries() == 0L) {
                    long lastLedgerId = (Long)ReadOnlyManagedLedgerImpl.this.ledgers.lastKey();
                    ((CompletableFuture)ReadOnlyManagedLedgerImpl.this.bookKeeper.newOpenLedgerOp().withRecovery(false).withLedgerId(lastLedgerId).withDigestType(ReadOnlyManagedLedgerImpl.this.config.getDigestType()).withPassword(ReadOnlyManagedLedgerImpl.this.config.getPassword()).execute().thenAccept(readHandle -> ((CompletableFuture)readHandle.readLastAddConfirmedAsync().thenAccept(lastAddConfirmed -> {
                        MLDataFormats.ManagedLedgerInfo.LedgerInfo info = MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder().setLedgerId(lastLedgerId).setEntries(lastAddConfirmed + 1L).setSize(readHandle.getLength()).setTimestamp(ReadOnlyManagedLedgerImpl.this.clock.millis()).build();
                        ReadOnlyManagedLedgerImpl.this.ledgers.put(lastLedgerId, info);
                        future.complete(ReadOnlyManagedLedgerImpl.this.createReadOnlyCursor(startPosition));
                    })).exceptionally(ex -> {
                        if (ex instanceof CompletionException && ex.getCause() instanceof IllegalArgumentException) {
                            MLDataFormats.ManagedLedgerInfo.LedgerInfo info = MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder().setLedgerId(lastLedgerId).setEntries(0L).setSize(0L).setTimestamp(ReadOnlyManagedLedgerImpl.this.clock.millis()).build();
                            ReadOnlyManagedLedgerImpl.this.ledgers.put(lastLedgerId, info);
                            future.complete(ReadOnlyManagedLedgerImpl.this.createReadOnlyCursor(startPosition));
                        } else {
                            future.completeExceptionally(new ManagedLedgerException((Throwable)ex));
                        }
                        return null;
                    }))).exceptionally(ex -> {
                        if (ex instanceof CompletionException && ex.getCause() instanceof ArrayIndexOutOfBoundsException) {
                            MLDataFormats.ManagedLedgerInfo.LedgerInfo info = MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder().setLedgerId(lastLedgerId).setEntries(0L).setSize(0L).setTimestamp(ReadOnlyManagedLedgerImpl.this.clock.millis()).build();
                            ReadOnlyManagedLedgerImpl.this.ledgers.put(lastLedgerId, info);
                            future.complete(ReadOnlyManagedLedgerImpl.this.createReadOnlyCursor(startPosition));
                        } else {
                            future.completeExceptionally(new ManagedLedgerException((Throwable)ex));
                        }
                        return null;
                    });
                } else {
                    future.complete(ReadOnlyManagedLedgerImpl.this.createReadOnlyCursor(startPosition));
                }
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                if (e instanceof ManagedLedgerException.MetadataNotFoundException) {
                    future.completeExceptionally(new ManagedLedgerException.ManagedLedgerNotFoundException(e));
                } else {
                    future.completeExceptionally(new ManagedLedgerException(e));
                }
            }
        });
        return future;
    }

    private ReadOnlyCursor createReadOnlyCursor(PositionImpl startPosition) {
        this.lastConfirmedEntry = this.ledgers.size() == 0 ? PositionImpl.earliest : new PositionImpl((Long)this.ledgers.lastKey(), ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.lastEntry().getValue()).getEntries() - 1L);
        ReadOnlyCursorImpl cursor = new ReadOnlyCursorImpl(this.bookKeeper, this.config, this, startPosition, "read-only-cursor");
        return cursor;
    }

    @Override
    protected boolean isReadOnly() {
        return true;
    }
}

