/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;

public class PositionImpl
implements Position,
Comparable<PositionImpl> {
    private final long ledgerId;
    private final long entryId;
    public static PositionImpl earliest = new PositionImpl(-1L, -1L);
    public static PositionImpl latest = new PositionImpl(Long.MAX_VALUE, Long.MAX_VALUE);

    public PositionImpl(MLDataFormats.PositionInfo pi) {
        this.ledgerId = pi.getLedgerId();
        this.entryId = pi.getEntryId();
    }

    public PositionImpl(MLDataFormats.NestedPositionInfo npi) {
        this.ledgerId = npi.getLedgerId();
        this.entryId = npi.getEntryId();
    }

    public PositionImpl(long ledgerId, long entryId) {
        this.ledgerId = ledgerId;
        this.entryId = entryId;
    }

    public PositionImpl(PositionImpl other) {
        this.ledgerId = other.ledgerId;
        this.entryId = other.entryId;
    }

    public static PositionImpl get(long ledgerId, long entryId) {
        return new PositionImpl(ledgerId, entryId);
    }

    public static PositionImpl get(PositionImpl other) {
        return new PositionImpl(other);
    }

    public long getLedgerId() {
        return this.ledgerId;
    }

    public long getEntryId() {
        return this.entryId;
    }

    @Override
    public PositionImpl getNext() {
        return PositionImpl.get(this.ledgerId, this.entryId + 1L);
    }

    public String toString() {
        return String.format("%d:%d", this.ledgerId, this.entryId);
    }

    @Override
    public int compareTo(PositionImpl other) {
        Preconditions.checkNotNull((Object)other);
        return ComparisonChain.start().compare(this.ledgerId, other.ledgerId).compare(this.entryId, other.entryId).result();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ledgerId, this.entryId});
    }

    public boolean equals(Object obj) {
        if (obj instanceof PositionImpl) {
            PositionImpl other = (PositionImpl)obj;
            return this.ledgerId == other.ledgerId && this.entryId == other.entryId;
        }
        return false;
    }

    public MLDataFormats.PositionInfo getPositionInfo() {
        return MLDataFormats.PositionInfo.newBuilder().setLedgerId(this.ledgerId).setEntryId(this.entryId).build();
    }
}

