/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.util.Recycler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.impl.EntryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.util.SafeRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpAddEntry
extends org.apache.bookkeeper.util.SafeRunnable
implements AsyncCallback.AddCallback,
AsyncCallback.CloseCallback {
    private ManagedLedgerImpl ml;
    private LedgerHandle ledger;
    private long entryId;
    private volatile AsyncCallbacks.AddEntryCallback callback;
    private Object ctx;
    private boolean closeWhenDone;
    private long startTime;
    ByteBuf data;
    private int dataLength;
    private static final AtomicReferenceFieldUpdater<OpAddEntry, AsyncCallbacks.AddEntryCallback> callbackUpdater = AtomicReferenceFieldUpdater.newUpdater(OpAddEntry.class, AsyncCallbacks.AddEntryCallback.class, "callback");
    private final Recycler.Handle<OpAddEntry> recyclerHandle;
    private static final Recycler<OpAddEntry> RECYCLER = new Recycler<OpAddEntry>(){

        protected OpAddEntry newObject(Recycler.Handle<OpAddEntry> recyclerHandle) {
            return new OpAddEntry(recyclerHandle);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(OpAddEntry.class);

    public static OpAddEntry create(ManagedLedgerImpl ml, ByteBuf data, AsyncCallbacks.AddEntryCallback callback, Object ctx) {
        OpAddEntry op = (OpAddEntry)((Object)RECYCLER.get());
        op.ml = ml;
        op.ledger = null;
        op.data = data.retain();
        op.dataLength = data.readableBytes();
        op.callback = callback;
        op.ctx = ctx;
        op.closeWhenDone = false;
        op.entryId = -1L;
        op.startTime = System.nanoTime();
        ml.mbean.addAddEntrySample(op.dataLength);
        if (log.isDebugEnabled()) {
            log.debug("Created new OpAddEntry {}", (Object)op);
        }
        return op;
    }

    public void setLedger(LedgerHandle ledger) {
        this.ledger = ledger;
    }

    public void setCloseWhenDone(boolean closeWhenDone) {
        this.closeWhenDone = closeWhenDone;
    }

    public void initiate() {
        ByteBuf duplicateBuffer = this.data.retainedDuplicate();
        this.ledger.asyncAddEntry(duplicateBuffer, (AsyncCallback.AddCallback)this, this.ctx);
        duplicateBuffer.release();
    }

    public void failed(ManagedLedgerException e) {
        AsyncCallbacks.AddEntryCallback cb = callbackUpdater.getAndSet(this, null);
        this.data.release();
        if (cb != null) {
            cb.addFailed(e, this.ctx);
            this.ml.mbean.recordAddEntryError();
        }
    }

    public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
        if (this.ledger.getId() != lh.getId()) {
            log.warn("[{}] ledgerId {} doesn't match with acked ledgerId {}", new Object[]{this.ml.getName(), this.ledger.getId(), lh.getId()});
        }
        Preconditions.checkArgument((this.ledger.getId() == lh.getId() ? 1 : 0) != 0, (String)"ledgerId %s doesn't match with acked ledgerId %s", (long)this.ledger.getId(), (long)lh.getId());
        Preconditions.checkArgument((this.ctx == ctx ? 1 : 0) != 0);
        this.entryId = entryId;
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] write-complete: ledger-id={} entry-id={} size={} rc={}", new Object[]{this, this.ml.getName(), lh.getId(), entryId, this.dataLength, rc});
        }
        if (rc != 0) {
            this.ml.mbean.recordAddEntryError();
            this.ml.getExecutor().executeOrdered((Object)this.ml.getName(), (SafeRunnable)SafeRun.safeRun(() -> this.ml.ledgerClosed(lh)));
        } else {
            this.ml.getExecutor().executeOrdered((Object)this.ml.getName(), (SafeRunnable)this);
        }
    }

    public void safeRun() {
        OpAddEntry firstInQueue = this.ml.pendingAddEntries.poll();
        Preconditions.checkArgument((this == firstInQueue ? 1 : 0) != 0);
        ManagedLedgerImpl.NUMBER_OF_ENTRIES_UPDATER.incrementAndGet(this.ml);
        ManagedLedgerImpl.TOTAL_SIZE_UPDATER.addAndGet(this.ml, this.dataLength);
        if (this.ml.hasActiveCursors()) {
            EntryImpl entry = EntryImpl.create(this.ledger.getId(), this.entryId, this.data);
            this.ml.entryCache.insert(entry);
            entry.release();
        }
        this.data.release();
        PositionImpl lastEntry = PositionImpl.get(this.ledger.getId(), this.entryId);
        ManagedLedgerImpl.ENTRIES_ADDED_COUNTER_UPDATER.incrementAndGet(this.ml);
        this.ml.lastConfirmedEntry = lastEntry;
        if (this.closeWhenDone) {
            log.info("[{}] Closing ledger {} for being full", (Object)this.ml.getName(), (Object)this.ledger.getId());
            this.ledger.asyncClose((AsyncCallback.CloseCallback)this, this.ctx);
        } else {
            this.updateLatency();
            AsyncCallbacks.AddEntryCallback cb = callbackUpdater.getAndSet(this, null);
            if (cb != null) {
                cb.addComplete(lastEntry, this.ctx);
                this.ml.notifyCursors();
                this.recycle();
            }
        }
    }

    public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
        Preconditions.checkArgument((this.ledger.getId() == lh.getId() ? 1 : 0) != 0, (String)"ledgerId %s doesn't match with acked ledgerId %s", (long)this.ledger.getId(), (long)lh.getId());
        if (rc == 0) {
            log.debug("Successfuly closed ledger {}", (Object)lh.getId());
        } else {
            log.warn("Error when closing ledger {}. Status={}", (Object)lh.getId(), (Object)BKException.getMessage((int)rc));
        }
        this.ml.ledgerClosed(lh);
        this.updateLatency();
        AsyncCallbacks.AddEntryCallback cb = callbackUpdater.getAndSet(this, null);
        if (cb != null) {
            cb.addComplete(PositionImpl.get(lh.getId(), this.entryId), ctx);
            this.ml.notifyCursors();
            this.recycle();
        }
    }

    private void updateLatency() {
        this.ml.mbean.addAddEntryLatencySample(System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS);
    }

    private OpAddEntry(Recycler.Handle<OpAddEntry> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public void recycle() {
        this.ml = null;
        this.ledger = null;
        this.data = null;
        this.dataLength = -1;
        this.callback = null;
        this.ctx = null;
        this.closeWhenDone = false;
        this.entryId = -1L;
        this.startTime = -1L;
        this.recyclerHandle.recycle((Object)this);
    }
}

