/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.base.Charsets;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.impl.MetaStore;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.mledger.util.SafeRun;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreImplZookeeper
implements MetaStore {
    private static final Charset Encoding = Charsets.UTF_8;
    private static final List<ACL> Acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
    private static final String prefixName = "/managed-ledgers";
    private static final String prefix = "/managed-ledgers/";
    private final ZooKeeper zk;
    private final OrderedExecutor executor;
    private static final Logger log = LoggerFactory.getLogger(MetaStoreImplZookeeper.class);

    public MetaStoreImplZookeeper(ZooKeeper zk, OrderedExecutor executor) throws Exception {
        this.zk = zk;
        this.executor = executor;
        if (zk.exists(prefixName, false) == null) {
            zk.create(prefixName, new byte[0], Acl, CreateMode.PERSISTENT);
        }
    }

    private MLDataFormats.ManagedLedgerInfo updateMLInfoTimestamp(MLDataFormats.ManagedLedgerInfo info) {
        ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo> infoList = new ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo>(info.getLedgerInfoCount());
        long currentTime = System.currentTimeMillis();
        for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo : info.getLedgerInfoList()) {
            if (!ledgerInfo.hasTimestamp() || ledgerInfo.getTimestamp() == 0L) {
                MLDataFormats.ManagedLedgerInfo.LedgerInfo.Builder singleInfoBuilder = ledgerInfo.toBuilder();
                singleInfoBuilder.setTimestamp(currentTime);
                infoList.add(singleInfoBuilder.build());
                continue;
            }
            infoList.add(ledgerInfo);
        }
        MLDataFormats.ManagedLedgerInfo.Builder mlInfo = MLDataFormats.ManagedLedgerInfo.newBuilder();
        mlInfo.addAllLedgerInfo(infoList);
        if (info.hasTerminatedPosition()) {
            mlInfo.setTerminatedPosition(info.getTerminatedPosition());
        }
        return mlInfo.build();
    }

    @Override
    public void getManagedLedgerInfo(String ledgerName, boolean createIfMissing, MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo> callback) {
        this.zk.getData(prefix + ledgerName, false, (rc, path, ctx, readData, stat) -> this.executor.executeOrdered((Object)ledgerName, (SafeRunnable)SafeRun.safeRun(() -> {
            if (rc == KeeperException.Code.OK.intValue()) {
                try {
                    MLDataFormats.ManagedLedgerInfo info = this.parseManagedLedgerInfo(readData);
                    info = this.updateMLInfoTimestamp(info);
                    callback.operationComplete(info, new ZKStat(stat));
                }
                catch (InvalidProtocolBufferException | TextFormat.ParseException e) {
                    callback.operationFailed(new ManagedLedgerException.MetaStoreException((Exception)e));
                }
            } else if (rc == KeeperException.Code.NONODE.intValue()) {
                if (createIfMissing) {
                    log.info("Creating '{}{}'", (Object)prefix, (Object)ledgerName);
                    AsyncCallback.StringCallback createcb = (rc1, path1, ctx1, name) -> {
                        if (rc1 == KeeperException.Code.OK.intValue()) {
                            MLDataFormats.ManagedLedgerInfo info = MLDataFormats.ManagedLedgerInfo.getDefaultInstance();
                            callback.operationComplete(info, new ZKStat());
                        } else {
                            callback.operationFailed(new ManagedLedgerException.MetaStoreException((Exception)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc1))));
                        }
                    };
                    ZkUtils.asyncCreateFullPathOptimistic((ZooKeeper)this.zk, (String)(prefix + ledgerName), (byte[])new byte[0], Acl, (CreateMode)CreateMode.PERSISTENT, (AsyncCallback.StringCallback)createcb, null);
                } else {
                    callback.operationFailed(new ManagedLedgerException.MetadataNotFoundException((Exception)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc))));
                }
            } else {
                callback.operationFailed(new ManagedLedgerException.MetaStoreException((Exception)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc))));
            }
        })), null);
    }

    @Override
    public void asyncUpdateLedgerIds(String ledgerName, MLDataFormats.ManagedLedgerInfo mlInfo, MetaStore.Stat stat, MetaStore.MetaStoreCallback<Void> callback) {
        ZKStat zkStat = (ZKStat)stat;
        if (log.isDebugEnabled()) {
            log.debug("[{}] Updating metadata version={} with content={}", new Object[]{ledgerName, zkStat.version, mlInfo});
        }
        byte[] serializedMlInfo = mlInfo.toByteArray();
        this.zk.setData(prefix + ledgerName, serializedMlInfo, zkStat.getVersion(), (rc, path, zkCtx, stat1) -> this.executor.executeOrdered((Object)ledgerName, (SafeRunnable)SafeRun.safeRun(() -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] UpdateLedgersIdsCallback.processResult rc={} newVersion={}", new Object[]{ledgerName, KeeperException.Code.get((int)rc), stat != null ? Integer.valueOf(stat.getVersion()) : "null"});
            }
            ManagedLedgerException.MetaStoreException status = null;
            if (rc == KeeperException.Code.BADVERSION.intValue()) {
                status = new ManagedLedgerException.BadVersionException((Exception)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
                callback.operationFailed(status);
            } else if (rc != KeeperException.Code.OK.intValue()) {
                status = new ManagedLedgerException.MetaStoreException((Exception)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
                callback.operationFailed(status);
            } else {
                callback.operationComplete(null, new ZKStat(stat1));
            }
        })), null);
    }

    @Override
    public void getCursors(String ledgerName, MetaStore.MetaStoreCallback<List<String>> callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Get cursors list", (Object)ledgerName);
        }
        this.zk.getChildren(prefix + ledgerName, false, (rc, path, ctx, children, stat) -> this.executor.executeOrdered((Object)ledgerName, (SafeRunnable)SafeRun.safeRun(() -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] getConsumers complete rc={} children={}", new Object[]{ledgerName, KeeperException.Code.get((int)rc), children});
            }
            if (rc != KeeperException.Code.OK.intValue()) {
                callback.operationFailed(new ManagedLedgerException.MetaStoreException((Exception)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc))));
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] Get childrend completed version={}", (Object)ledgerName, (Object)stat.getVersion());
            }
            callback.operationComplete(children, new ZKStat(stat));
        })), null);
    }

    @Override
    public void asyncGetCursorInfo(String ledgerName, String consumerName, MetaStore.MetaStoreCallback<MLDataFormats.ManagedCursorInfo> callback) {
        String path = prefix + ledgerName + "/" + consumerName;
        if (log.isDebugEnabled()) {
            log.debug("Reading from {}", (Object)path);
        }
        this.zk.getData(path, false, (rc, path1, ctx, data, stat) -> this.executor.executeOrdered((Object)ledgerName, (SafeRunnable)SafeRun.safeRun(() -> {
            if (rc != KeeperException.Code.OK.intValue()) {
                callback.operationFailed(new ManagedLedgerException.MetaStoreException((Exception)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc))));
            } else {
                try {
                    MLDataFormats.ManagedCursorInfo info = this.parseManagedCursorInfo(data);
                    callback.operationComplete(info, new ZKStat(stat));
                }
                catch (InvalidProtocolBufferException | TextFormat.ParseException e) {
                    callback.operationFailed(new ManagedLedgerException.MetaStoreException((Exception)e));
                }
            }
        })), null);
        if (log.isDebugEnabled()) {
            log.debug("Reading from {} ok", (Object)path);
        }
    }

    @Override
    public void asyncUpdateCursorInfo(String ledgerName, String cursorName, MLDataFormats.ManagedCursorInfo info, MetaStore.Stat stat, MetaStore.MetaStoreCallback<Void> callback) {
        log.info("[{}] [{}] Updating cursor info ledgerId={} mark-delete={}:{}", new Object[]{ledgerName, cursorName, info.getCursorsLedgerId(), info.getMarkDeleteLedgerId(), info.getMarkDeleteEntryId()});
        String path = prefix + ledgerName + "/" + cursorName;
        byte[] content = info.toByteArray();
        if (stat == null) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Creating consumer {} on meta-data store with {}", new Object[]{ledgerName, cursorName, info});
            }
            this.zk.create(path, content, Acl, CreateMode.PERSISTENT, (rc, path1, ctx, name) -> this.executor.executeOrdered((Object)ledgerName, (SafeRunnable)SafeRun.safeRun(() -> {
                if (rc != KeeperException.Code.OK.intValue()) {
                    log.warn("[{}] Error creating cosumer {} node on meta-data store with {}: ", new Object[]{ledgerName, cursorName, info, KeeperException.Code.get((int)rc)});
                    callback.operationFailed(new ManagedLedgerException.MetaStoreException((Exception)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc))));
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Created consumer {} on meta-data store with {}", new Object[]{ledgerName, cursorName, info});
                    }
                    callback.operationComplete(null, new ZKStat());
                }
            })), null);
        } else {
            ZKStat zkStat = (ZKStat)stat;
            if (log.isDebugEnabled()) {
                log.debug("[{}] Updating consumer {} on meta-data store with {}", new Object[]{ledgerName, cursorName, info});
            }
            this.zk.setData(path, content, zkStat.getVersion(), (rc, path1, ctx, stat1) -> this.executor.executeOrdered((Object)ledgerName, (SafeRunnable)SafeRun.safeRun(() -> {
                if (rc == KeeperException.Code.BADVERSION.intValue()) {
                    callback.operationFailed(new ManagedLedgerException.BadVersionException((Exception)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc))));
                } else if (rc != KeeperException.Code.OK.intValue()) {
                    callback.operationFailed(new ManagedLedgerException.MetaStoreException((Exception)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc))));
                } else {
                    callback.operationComplete(null, new ZKStat(stat1));
                }
            })), null);
        }
    }

    @Override
    public void asyncRemoveCursor(String ledgerName, String consumerName, MetaStore.MetaStoreCallback<Void> callback) {
        log.info("[{}] Remove consumer={}", (Object)ledgerName, (Object)consumerName);
        this.zk.delete(prefix + ledgerName + "/" + consumerName, -1, (rc, path, ctx) -> this.executor.executeOrdered((Object)ledgerName, (SafeRunnable)SafeRun.safeRun(() -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] zk delete done. rc={}", new Object[]{ledgerName, consumerName, KeeperException.Code.get((int)rc)});
            }
            if (rc == KeeperException.Code.OK.intValue()) {
                callback.operationComplete(null, null);
            } else {
                callback.operationFailed(new ManagedLedgerException.MetaStoreException((Exception)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc))));
            }
        })), null);
    }

    @Override
    public void removeManagedLedger(String ledgerName, MetaStore.MetaStoreCallback<Void> callback) {
        log.info("[{}] Remove ManagedLedger", (Object)ledgerName);
        this.zk.delete(prefix + ledgerName, -1, (rc, path, ctx) -> this.executor.executeOrdered((Object)ledgerName, (SafeRunnable)SafeRun.safeRun(() -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] zk delete done. rc={}", (Object)ledgerName, (Object)KeeperException.Code.get((int)rc));
            }
            if (rc == KeeperException.Code.OK.intValue()) {
                callback.operationComplete(null, null);
            } else {
                callback.operationFailed(new ManagedLedgerException.MetaStoreException((Exception)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc))));
            }
        })), null);
    }

    @Override
    public Iterable<String> getManagedLedgers() throws ManagedLedgerException.MetaStoreException {
        try {
            return this.zk.getChildren(prefixName, false);
        }
        catch (Exception e) {
            throw new ManagedLedgerException.MetaStoreException(e);
        }
    }

    private MLDataFormats.ManagedLedgerInfo parseManagedLedgerInfo(byte[] data) throws TextFormat.ParseException, InvalidProtocolBufferException {
        try {
            return MLDataFormats.ManagedLedgerInfo.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            MLDataFormats.ManagedLedgerInfo.Builder builder = MLDataFormats.ManagedLedgerInfo.newBuilder();
            TextFormat.merge((CharSequence)new String(data, Encoding), (Message.Builder)builder);
            return builder.build();
        }
    }

    private MLDataFormats.ManagedCursorInfo parseManagedCursorInfo(byte[] data) throws TextFormat.ParseException, InvalidProtocolBufferException {
        try {
            return MLDataFormats.ManagedCursorInfo.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            MLDataFormats.ManagedCursorInfo.Builder builder = MLDataFormats.ManagedCursorInfo.newBuilder();
            TextFormat.merge((CharSequence)new String(data, Encoding), (Message.Builder)builder);
            return builder.build();
        }
    }

    private static class ZKStat
    implements MetaStore.Stat {
        private final int version;
        private final long creationTimestamp;
        private final long modificationTimestamp;

        ZKStat(Stat stat) {
            this.version = stat.getVersion();
            this.creationTimestamp = stat.getCtime();
            this.modificationTimestamp = stat.getMtime();
        }

        ZKStat() {
            this.version = 0;
            this.creationTimestamp = System.currentTimeMillis();
            this.modificationTimestamp = System.currentTimeMillis();
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        @Override
        public long getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public long getModificationTimestamp() {
            return this.modificationTimestamp;
        }
    }
}

