/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.time.Clock;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.mledger.LedgerOffloader;
import org.apache.bookkeeper.mledger.impl.NullLedgerOffloader;

@Beta
public class ManagedLedgerConfig {
    private boolean createIfMissing = true;
    private int maxUnackedRangesToPersist = 10000;
    private int maxUnackedRangesToPersistInZk = 1000;
    private int maxEntriesPerLedger = 50000;
    private int maxSizePerLedgerMb = 100;
    private int minimumRolloverTimeMs = 0;
    private long maximumRolloverTimeMs = TimeUnit.HOURS.toMillis(4L);
    private int ensembleSize = 3;
    private int writeQuorumSize = 2;
    private int ackQuorumSize = 2;
    private int metadataEnsembleSize = 3;
    private int metadataWriteQuorumSize = 2;
    private int metadataAckQuorumSize = 2;
    private int metadataMaxEntriesPerLedger = 50000;
    private int ledgerRolloverTimeout = 14400;
    private double throttleMarkDelete = 0.0;
    private long retentionTimeMs = 0L;
    private long retentionSizeInMB = 0L;
    private boolean autoSkipNonRecoverableData;
    private long offloadLedgerDeletionLagMs = TimeUnit.HOURS.toMillis(4L);
    private long offloadAutoTriggerSizeThresholdBytes = -1L;
    private DigestType digestType = DigestType.CRC32C;
    private byte[] password = "".getBytes(Charsets.UTF_8);
    private LedgerOffloader ledgerOffloader = NullLedgerOffloader.INSTANCE;
    private Clock clock = Clock.systemUTC();

    public boolean isCreateIfMissing() {
        return this.createIfMissing;
    }

    public ManagedLedgerConfig setCreateIfMissing(boolean createIfMissing) {
        this.createIfMissing = createIfMissing;
        return this;
    }

    public int getMaxEntriesPerLedger() {
        return this.maxEntriesPerLedger;
    }

    public ManagedLedgerConfig setMaxEntriesPerLedger(int maxEntriesPerLedger) {
        this.maxEntriesPerLedger = maxEntriesPerLedger;
        return this;
    }

    public int getMaxSizePerLedgerMb() {
        return this.maxSizePerLedgerMb;
    }

    public ManagedLedgerConfig setMaxSizePerLedgerMb(int maxSizePerLedgerMb) {
        this.maxSizePerLedgerMb = maxSizePerLedgerMb;
        return this;
    }

    public int getMinimumRolloverTimeMs() {
        return this.minimumRolloverTimeMs;
    }

    public void setMinimumRolloverTime(int minimumRolloverTime, TimeUnit unit) {
        this.minimumRolloverTimeMs = (int)unit.toMillis(minimumRolloverTime);
        Preconditions.checkArgument((this.maximumRolloverTimeMs >= (long)this.minimumRolloverTimeMs ? 1 : 0) != 0, (Object)"Minimum rollover time needs to be less than maximum rollover time");
    }

    public long getMaximumRolloverTimeMs() {
        return this.maximumRolloverTimeMs;
    }

    public void setMaximumRolloverTime(int maximumRolloverTime, TimeUnit unit) {
        this.maximumRolloverTimeMs = unit.toMillis(maximumRolloverTime);
        Preconditions.checkArgument((this.maximumRolloverTimeMs >= (long)this.minimumRolloverTimeMs ? 1 : 0) != 0, (Object)"Maximum rollover time needs to be greater than minimum rollover time");
    }

    public int getEnsembleSize() {
        return this.ensembleSize;
    }

    public ManagedLedgerConfig setEnsembleSize(int ensembleSize) {
        this.ensembleSize = ensembleSize;
        return this;
    }

    public int getAckQuorumSize() {
        return this.ackQuorumSize;
    }

    public int getWriteQuorumSize() {
        return this.writeQuorumSize;
    }

    public ManagedLedgerConfig setWriteQuorumSize(int writeQuorumSize) {
        this.writeQuorumSize = writeQuorumSize;
        return this;
    }

    public ManagedLedgerConfig setAckQuorumSize(int ackQuorumSize) {
        this.ackQuorumSize = ackQuorumSize;
        return this;
    }

    public DigestType getDigestType() {
        return this.digestType;
    }

    public ManagedLedgerConfig setDigestType(DigestType digestType) {
        this.digestType = digestType;
        return this;
    }

    public byte[] getPassword() {
        return Arrays.copyOf(this.password, this.password.length);
    }

    public ManagedLedgerConfig setPassword(String password) {
        this.password = password.getBytes(Charsets.UTF_8);
        return this;
    }

    public int getMetadataEnsemblesize() {
        return this.metadataEnsembleSize;
    }

    public ManagedLedgerConfig setMetadataEnsembleSize(int metadataEnsembleSize) {
        this.metadataEnsembleSize = metadataEnsembleSize;
        return this;
    }

    public int getMetadataAckQuorumSize() {
        return this.metadataAckQuorumSize;
    }

    public int getMetadataWriteQuorumSize() {
        return this.metadataWriteQuorumSize;
    }

    public ManagedLedgerConfig setMetadataAckQuorumSize(int metadataAckQuorumSize) {
        this.metadataAckQuorumSize = metadataAckQuorumSize;
        return this;
    }

    public ManagedLedgerConfig setMetadataWriteQuorumSize(int metadataWriteQuorumSize) {
        this.metadataWriteQuorumSize = metadataWriteQuorumSize;
        return this;
    }

    public int getMetadataMaxEntriesPerLedger() {
        return this.metadataMaxEntriesPerLedger;
    }

    public ManagedLedgerConfig setMetadataMaxEntriesPerLedger(int metadataMaxEntriesPerLedger) {
        this.metadataMaxEntriesPerLedger = metadataMaxEntriesPerLedger;
        return this;
    }

    public int getLedgerRolloverTimeout() {
        return this.ledgerRolloverTimeout;
    }

    public ManagedLedgerConfig setLedgerRolloverTimeout(int ledgerRolloverTimeout) {
        this.ledgerRolloverTimeout = ledgerRolloverTimeout;
        return this;
    }

    public double getThrottleMarkDelete() {
        return this.throttleMarkDelete;
    }

    public ManagedLedgerConfig setThrottleMarkDelete(double throttleMarkDelete) {
        Preconditions.checkArgument((throttleMarkDelete >= 0.0 ? 1 : 0) != 0);
        this.throttleMarkDelete = throttleMarkDelete;
        return this;
    }

    public ManagedLedgerConfig setRetentionTime(int retentionTime, TimeUnit unit) {
        this.retentionTimeMs = unit.toMillis(retentionTime);
        return this;
    }

    public long getRetentionTimeMillis() {
        return this.retentionTimeMs;
    }

    public ManagedLedgerConfig setRetentionSizeInMB(long retentionSizeInMB) {
        this.retentionSizeInMB = retentionSizeInMB;
        return this;
    }

    public long getRetentionSizeInMB() {
        return this.retentionSizeInMB;
    }

    public ManagedLedgerConfig setOffloadLedgerDeletionLag(long lagTime, TimeUnit unit) {
        this.offloadLedgerDeletionLagMs = unit.toMillis(lagTime);
        return this;
    }

    public long getOffloadLedgerDeletionLagMillis() {
        return this.offloadLedgerDeletionLagMs;
    }

    public ManagedLedgerConfig setOffloadAutoTriggerSizeThresholdBytes(long threshold) {
        this.offloadAutoTriggerSizeThresholdBytes = threshold;
        return this;
    }

    public long getOffloadAutoTriggerSizeThresholdBytes() {
        return this.offloadAutoTriggerSizeThresholdBytes;
    }

    public boolean isAutoSkipNonRecoverableData() {
        return this.autoSkipNonRecoverableData;
    }

    public void setAutoSkipNonRecoverableData(boolean skipNonRecoverableData) {
        this.autoSkipNonRecoverableData = skipNonRecoverableData;
    }

    public int getMaxUnackedRangesToPersist() {
        return this.maxUnackedRangesToPersist;
    }

    public ManagedLedgerConfig setMaxUnackedRangesToPersist(int maxUnackedRangesToPersist) {
        this.maxUnackedRangesToPersist = maxUnackedRangesToPersist;
        return this;
    }

    public int getMaxUnackedRangesToPersistInZk() {
        return this.maxUnackedRangesToPersistInZk;
    }

    public void setMaxUnackedRangesToPersistInZk(int maxUnackedRangesToPersistInZk) {
        this.maxUnackedRangesToPersistInZk = maxUnackedRangesToPersistInZk;
    }

    public LedgerOffloader getLedgerOffloader() {
        return this.ledgerOffloader;
    }

    public ManagedLedgerConfig setLedgerOffloader(LedgerOffloader offloader) {
        this.ledgerOffloader = offloader;
        return this;
    }

    public Clock getClock() {
        return this.clock;
    }

    public ManagedLedgerConfig setClock(Clock clock) {
        this.clock = clock;
        return this;
    }
}

