/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.interceptors;

import java.sql.SQLException;
import java.util.StringTokenizer;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.jetspeed.util.interceptors.MethodReplayDecisionMaker;

public class TransactionalMethodReplayDecisionMaker
implements MethodReplayDecisionMaker {
    private int[] sqlErrorCodes;

    @Override
    public boolean shouldReplay(MethodInvocation invocation, Exception exception) {
        int errorCode;
        SQLException sqlException = this.findSQLException(exception);
        if (sqlException != null && (errorCode = sqlException.getErrorCode()) != 0) {
            return this.isErrorCodeListed(errorCode);
        }
        return false;
    }

    protected SQLException findSQLException(Exception exception) {
        SQLException foundException = null;
        if (exception != null) {
            if (exception instanceof SQLException) {
                foundException = (SQLException)exception;
            } else {
                Throwable throwable = exception.getCause();
                if (throwable != null && throwable instanceof Exception) {
                    foundException = this.findSQLException((Exception)throwable);
                }
            }
        }
        return foundException;
    }

    public void setSqlErrorCodes(String sqlErrorCodesString) {
        StringTokenizer tokenizer = new StringTokenizer(sqlErrorCodesString, ",");
        this.sqlErrorCodes = new int[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            this.sqlErrorCodes[i] = new Integer(tokenizer.nextToken());
            ++i;
        }
    }

    private boolean isErrorCodeListed(int errorCode) {
        for (int i = 0; i < this.sqlErrorCodes.length; ++i) {
            if (this.sqlErrorCodes[i] != errorCode) continue;
            return true;
        }
        return false;
    }
}

