/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.page.SecurityConstraintImpl;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.page.document.DocumentException;
import org.apache.jetspeed.security.Group;
import org.apache.jetspeed.security.JSSubject;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.User;

public class PageManagerSecurityUtils {
    public static boolean checkConstraint(SecurityConstraintsDef def, String actions) throws DocumentException {
        Subject subject;
        List<String> viewActionList = SecurityConstraintImpl.parseCSVList(actions);
        List<String> otherActionsList = null;
        if (viewActionList.size() == 1) {
            if (!viewActionList.contains(JetspeedActions.VIEW)) {
                otherActionsList = viewActionList;
                viewActionList = null;
            }
        } else {
            otherActionsList = viewActionList;
            viewActionList = null;
            if (otherActionsList.remove(JetspeedActions.VIEW)) {
                viewActionList = new ArrayList<String>(1);
                viewActionList.add(JetspeedActions.VIEW);
            }
        }
        if ((subject = JSSubject.getSubject((AccessControlContext)AccessController.getContext())) == null) {
            throw new SecurityException("Security Consraint Check: Missing JSSubject");
        }
        LinkedList<String> userPrincipals = null;
        LinkedList<String> rolePrincipals = null;
        LinkedList<String> groupPrincipals = null;
        for (Principal principal : subject.getPrincipals()) {
            if (principal instanceof User) {
                if (userPrincipals == null) {
                    userPrincipals = new LinkedList<String>();
                }
                userPrincipals.add(principal.getName());
                continue;
            }
            if (principal instanceof Role) {
                if (rolePrincipals == null) {
                    rolePrincipals = new LinkedList<String>();
                }
                rolePrincipals.add(principal.getName());
                continue;
            }
            if (!(principal instanceof Group)) continue;
            if (groupPrincipals == null) {
                groupPrincipals = new LinkedList<String>();
            }
            groupPrincipals.add(principal.getName());
        }
        boolean result = false;
        if (viewActionList != null) {
            result = PageManagerSecurityUtils.checkConstraints(viewActionList, userPrincipals, rolePrincipals, groupPrincipals, def);
        }
        if (otherActionsList != null) {
            result = PageManagerSecurityUtils.checkConstraints(otherActionsList, userPrincipals, rolePrincipals, groupPrincipals, def);
        }
        return result;
    }

    public static boolean checkConstraints(List<String> actions, List<String> userPrincipals, List<String> rolePrincipals, List<String> groupPrincipals, SecurityConstraintsDef def) throws DocumentException {
        List checkConstraints = def.getSecurityConstraints();
        if (checkConstraints != null && !checkConstraints.isEmpty()) {
            for (String action : actions) {
                boolean actionPermitted = false;
                boolean actionNotPermitted = false;
                boolean anyActionsPermitted = true;
                for (SecurityConstraint checkConstraint : checkConstraints) {
                    SecurityConstraintImpl constraint = (SecurityConstraintImpl)checkConstraint;
                    if (constraint.getPermissions() != null) {
                        anyActionsPermitted = true;
                        if (!constraint.actionMatch(action) || !constraint.principalsMatch(userPrincipals, rolePrincipals, groupPrincipals, true)) continue;
                        actionPermitted = true;
                        break;
                    }
                    if (!constraint.principalsMatch(userPrincipals, rolePrincipals, groupPrincipals, false)) continue;
                    actionNotPermitted = true;
                    break;
                }
                if ((actionPermitted || !anyActionsPermitted) && !actionNotPermitted) continue;
                return false;
            }
        } else if (!actions.isEmpty()) {
            return false;
        }
        return true;
    }
}

