/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.psml;

import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.page.BaseFragmentElement;
import org.apache.jetspeed.om.page.BaseFragmentValidationListener;
import org.apache.jetspeed.om.page.FragmentProperty;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.psml.AbstractBaseElement;
import org.apache.jetspeed.om.page.psml.AbstractBaseFragmentsElement;
import org.apache.jetspeed.om.page.psml.PropertiesList;
import org.apache.jetspeed.om.page.psml.PropertyImpl;
import org.apache.jetspeed.om.preference.FragmentPreference;

public abstract class AbstractBaseFragmentElement
extends AbstractBaseElement
implements BaseFragmentElement {
    private static final long serialVersionUID = 1L;
    private String state = null;
    private String mode = null;
    private String decorator = null;
    private String skin = null;
    private List<FragmentProperty> propertyImpls = new ArrayList<FragmentProperty>();
    private List<FragmentPreference> preferences = new ArrayList<FragmentPreference>();
    private String name;
    private AbstractBaseFragmentsElement baseFragmentsElement;
    private boolean dirty = false;

    public String getState() {
        return this.getProperty("state");
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setState(String scope, String scopeValue, String state) {
        this.setProperty("state", scope, scopeValue, state);
    }

    public String getMode() {
        return this.getProperty("mode");
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setMode(String scope, String scopeValue, String mode) {
        this.setProperty("mode", scope, scopeValue, mode);
    }

    public String getDecorator() {
        return this.getProperty("decorator");
    }

    public void setDecorator(String decoratorName) {
        this.decorator = decoratorName;
    }

    public void setDecorator(String scope, String scopeValue, String decorator) {
        this.setProperty("decorator", scope, scopeValue, decorator);
    }

    public String getSkin() {
        return this.getProperty("skin");
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public void setSkin(String scope, String scopeValue, String skin) {
        this.setProperty("skin", scope, scopeValue, skin);
    }

    public String getProperty(String propName) {
        String[] userValue = new String[1];
        String[] groupValue = new String[1];
        String[] roleValue = new String[1];
        String[] globalValue = new String[1];
        PropertyImpl.getFragmentProperty(propName, this.getProperties(), userValue, groupValue, roleValue, globalValue);
        if (userValue[0] == null && groupValue[0] == null && roleValue[0] == null) {
            if (propName.equals("state")) {
                globalValue[0] = this.state;
            } else if (propName.equals("mode")) {
                globalValue[0] = this.mode;
            } else if (propName.equals("decorator")) {
                globalValue[0] = this.decorator;
            } else if (propName.equals("skin")) {
                globalValue[0] = this.skin;
            }
        }
        return userValue[0] != null ? userValue[0] : (groupValue[0] != null ? groupValue[0] : (roleValue[0] != null ? roleValue[0] : globalValue[0]));
    }

    public String getProperty(String propName, String propScope, String propScopeValue) {
        FragmentProperty fragmentProperty;
        if (propScope == null) {
            if (propName.equals("state")) {
                return this.state;
            }
            if (propName.equals("mode")) {
                return this.mode;
            }
            if (propName.equals("decorator")) {
                return this.decorator;
            }
            if (propName.equals("skin")) {
                return this.skin;
            }
        }
        if (propScope != null && propScope.equals("user") && propScopeValue == null) {
            propScopeValue = PropertyImpl.getCurrentUserScopeValue();
        }
        if ((fragmentProperty = PropertyImpl.findFragmentProperty(propName, propScope, propScopeValue, this.propertyImpls)) != null) {
            return fragmentProperty.getValue();
        }
        return null;
    }

    public int getIntProperty(String propName) {
        String prop = this.getProperty(propName);
        if (prop != null) {
            return Integer.parseInt(prop);
        }
        return -1;
    }

    public int getIntProperty(String propName, String propScope, String propScopeValue) {
        String prop = this.getProperty(propName, propScope, propScopeValue);
        if (prop != null) {
            return Integer.parseInt(prop);
        }
        return -1;
    }

    public float getFloatProperty(String propName) {
        String prop = this.getProperty(propName);
        if (prop != null) {
            return Float.parseFloat(prop);
        }
        return -1.0f;
    }

    public float getFloatProperty(String propName, String propScope, String propScopeValue) {
        String prop = this.getProperty(propName, propScope, propScopeValue);
        if (prop != null) {
            return Float.parseFloat(prop);
        }
        return -1.0f;
    }

    public void setProperty(String propName, String propScope, String propScopeValue, String propValue) {
        if (propScope == null) {
            if (propName.equals("state")) {
                this.state = propValue;
                return;
            }
            if (propName.equals("mode")) {
                this.mode = propValue;
                return;
            }
            if (propName.equals("decorator")) {
                this.decorator = propValue;
                return;
            }
            if (propName.equals("skin")) {
                this.skin = propValue;
                return;
            }
        }
        if (propScope != null && propScope.equals("user") && propScopeValue == null) {
            propScopeValue = PropertyImpl.getCurrentUserScopeValue();
        }
        FragmentProperty fragmentProperty = PropertyImpl.findFragmentProperty(propName, propScope, propScopeValue, this.propertyImpls);
        if (propValue != null) {
            if (fragmentProperty == null) {
                fragmentProperty = new PropertyImpl();
                fragmentProperty.setName(propName);
                fragmentProperty.setScope(propScope);
                fragmentProperty.setScopeValue(propScopeValue);
                fragmentProperty.setValue(propValue);
                this.propertyImpls.add(fragmentProperty);
            } else {
                fragmentProperty.setValue(propValue);
            }
        } else if (fragmentProperty != null) {
            this.propertyImpls.remove(fragmentProperty);
        }
    }

    public void setProperty(String propName, String propScope, String propScopeValue, int propValue) {
        this.setProperty(propName, propScope, propScopeValue, propValue >= 0 ? String.valueOf(propValue) : null);
    }

    public void setProperty(String propName, String propScope, String propScopeValue, float propValue) {
        this.setProperty(propName, propScope, propScopeValue, propValue >= 0.0f ? String.valueOf(propValue) : null);
    }

    public List<FragmentProperty> getProperties() {
        return new PropertiesList(PropertyImpl.filterFragmentProperties(this.propertyImpls), this.propertyImpls);
    }

    public void setProperties(List<FragmentProperty> properties) {
        List<FragmentProperty> propertiesList = this.getProperties();
        propertiesList.clear();
        propertiesList.addAll(properties);
    }

    public int getLayoutRow() {
        return this.getIntProperty("row");
    }

    public void setLayoutRow(int row) {
        this.setProperty("row", (String)null, (String)null, row);
    }

    public void setLayoutRow(String scope, String scopeValue, int row) {
        this.setProperty("row", scope, scopeValue, row);
    }

    public int getLayoutColumn() {
        return this.getIntProperty("column");
    }

    public void setLayoutColumn(int column) {
        this.setProperty("column", (String)null, (String)null, column);
    }

    public void setLayoutColumn(String scope, String scopeValue, int column) {
        this.setProperty("column", scope, scopeValue, column);
    }

    public String getLayoutSizes() {
        return this.getProperty("sizes");
    }

    public void setLayoutSizes(String sizes) {
        this.setProperty("sizes", null, null, sizes);
    }

    public void setLayoutSizes(String scope, String scopeValue, String sizes) {
        this.setProperty("sizes", scope, scopeValue, sizes);
    }

    public float getLayoutX() {
        return this.getFloatProperty("x");
    }

    public void setLayoutX(float x) {
        this.setProperty("x", null, null, x);
    }

    public void setLayoutX(String scope, String scopeValue, float x) {
        this.setProperty("x", scope, scopeValue, x);
    }

    public float getLayoutY() {
        return this.getFloatProperty("y");
    }

    public void setLayoutY(float y) {
        this.setProperty("y", null, null, y);
    }

    public void setLayoutY(String scope, String scopeValue, float y) {
        this.setProperty("y", scope, scopeValue, y);
    }

    public float getLayoutZ() {
        return this.getFloatProperty("z");
    }

    public void setLayoutZ(float z) {
        this.setProperty("z", null, null, z);
    }

    public void setLayoutZ(String scope, String scopeValue, float z) {
        this.setProperty("z", scope, scopeValue, z);
    }

    public float getLayoutWidth() {
        return this.getFloatProperty("width");
    }

    public void setLayoutWidth(float width) {
        this.setProperty("width", null, null, width);
    }

    public void setLayoutWidth(String scope, String scopeValue, float width) {
        this.setProperty("width", scope, scopeValue, width);
    }

    public float getLayoutHeight() {
        return this.getFloatProperty("height");
    }

    public void setLayoutHeight(float height) {
        this.setProperty("height", null, null, height);
    }

    public void setLayoutHeight(String scope, String scopeValue, float height) {
        this.setProperty("height", scope, scopeValue, height);
    }

    @Override
    public boolean equals(Object obj) {
        BaseFragmentElement aFragment;
        boolean isEqual = false;
        if (obj != null && obj instanceof BaseFragmentElement && null != (aFragment = (BaseFragmentElement)obj).getId() && null != this.getId() && this.getId().equals(aFragment.getId())) {
            isEqual = true;
        }
        return isEqual;
    }

    @Override
    public int hashCode() {
        if (this.getId() != null) {
            return (BaseFragmentElement.class.getName() + ":" + this.getId()).hashCode();
        }
        return super.hashCode();
    }

    public List<FragmentPreference> getPreferences() {
        return this.preferences;
    }

    public void setPreferences(List<FragmentPreference> preferences) {
        if (preferences == null) {
            preferences = new ArrayList<FragmentPreference>();
        }
        this.preferences = preferences;
    }

    public AbstractBaseFragmentsElement getBaseFragmentsElement() {
        return this.baseFragmentsElement;
    }

    void setBaseFragmentsElement(AbstractBaseFragmentsElement baseFragmentsElement) {
        this.baseFragmentsElement = baseFragmentsElement;
        if (this.dirty) {
            baseFragmentsElement.setDirty(this.dirty);
        }
    }

    @Override
    public PageSecurity getEffectivePageSecurity() {
        if (this.baseFragmentsElement != null) {
            return this.baseFragmentsElement.getEffectivePageSecurity();
        }
        return null;
    }

    @Override
    public void checkPermissions(String path, int mask, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        AccessController.checkPermission((Permission)pf.newPermission("fragment", path, mask));
    }

    @Override
    public boolean getConstraintsEnabled() {
        if (this.baseFragmentsElement != null) {
            return this.baseFragmentsElement.getConstraintsEnabled();
        }
        return false;
    }

    @Override
    public boolean getPermissionsEnabled() {
        if (this.baseFragmentsElement != null) {
            return this.baseFragmentsElement.getPermissionsEnabled();
        }
        return false;
    }

    public List<FragmentProperty> getPropertyImpls() {
        return this.propertyImpls;
    }

    public void setPropertyImpls(List<FragmentProperty> propertiesImpls) {
        this.propertyImpls = this.propertyImpls;
    }

    public String getStatePropertyField() {
        return this.state;
    }

    public void setStatePropertyField(String state) {
        this.state = state;
    }

    public String getModePropertyField() {
        return this.mode;
    }

    public void setModePropertyField(String mode) {
        this.mode = mode;
    }

    public String getDecoratorPropertyField() {
        return this.decorator;
    }

    public void setDecoratorPropertyField(String decorator) {
        this.decorator = decorator;
    }

    public String getSkinPropertyField() {
        return this.skin;
    }

    public void setSkinPropertyField(String skin) {
        this.skin = skin;
    }

    @Override
    public boolean unmarshalled(IdGenerator generator) {
        boolean dirty = super.unmarshalled(generator);
        if (this.getId() == null) {
            this.setId(generator.getNextPeid());
            dirty = true;
        }
        return dirty;
    }

    protected boolean validateFragments(BaseFragmentValidationListener validationListener) {
        return validationListener.validate(this);
    }
}

