/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.AbstractList;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.page.impl.PageSecuritySecurityConstraintImpl;
import org.apache.jetspeed.om.page.impl.SecurityConstraintsDefImpl;

class SecurityConstraintDefList
extends AbstractList<SecurityConstraint> {
    private SecurityConstraintsDefImpl constraintsDef;

    SecurityConstraintDefList(SecurityConstraintsDefImpl constraintsDef) {
        this.constraintsDef = constraintsDef;
    }

    private PageSecuritySecurityConstraintImpl validateConstraintForAdd(SecurityConstraint constraint) {
        if (constraint == null) {
            throw new NullPointerException("Unable to add null to list.");
        }
        return (PageSecuritySecurityConstraintImpl)constraint;
    }

    @Override
    public void add(int index, SecurityConstraint element) {
        PageSecuritySecurityConstraintImpl nextConstraint;
        if (index < 0 || index > this.constraintsDef.accessConstraintDefs().size()) {
            throw new IndexOutOfBoundsException("Unable to add to list at index: " + index);
        }
        PageSecuritySecurityConstraintImpl constraint = this.validateConstraintForAdd(element);
        this.constraintsDef.accessConstraintDefs().add(index, constraint);
        if (index > 0) {
            constraint.setApplyOrder(this.constraintsDef.accessConstraintDefs().get(index - 1).getApplyOrder() + 1);
        } else {
            constraint.setApplyOrder(0);
        }
        int limit = this.constraintsDef.accessConstraintDefs().size() - 1;
        for (int i = index; i < limit && (nextConstraint = this.constraintsDef.accessConstraintDefs().get(i + 1)).getApplyOrder() <= constraint.getApplyOrder(); ++i) {
            nextConstraint.setApplyOrder(constraint.getApplyOrder() + 1);
            constraint = nextConstraint;
        }
    }

    @Override
    public SecurityConstraint get(int index) {
        return this.constraintsDef.accessConstraintDefs().get(index);
    }

    @Override
    public SecurityConstraint remove(int index) {
        return this.constraintsDef.accessConstraintDefs().remove(index);
    }

    @Override
    public SecurityConstraint set(int index, SecurityConstraint element) {
        PageSecuritySecurityConstraintImpl newConstraint = this.validateConstraintForAdd(element);
        PageSecuritySecurityConstraintImpl constraint = this.constraintsDef.accessConstraintDefs().set(index, newConstraint);
        newConstraint.setApplyOrder(constraint.getApplyOrder());
        return constraint;
    }

    @Override
    public int size() {
        return this.constraintsDef.accessConstraintDefs().size();
    }
}

