/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.om.page.impl.PageSecurityConstraintsDefList;
import org.apache.jetspeed.om.page.impl.PageSecurityConstraintsRefList;
import org.apache.jetspeed.om.page.impl.PageSecurityGlobalSecurityConstraintsRef;
import org.apache.jetspeed.om.page.impl.PageSecuritySecurityConstraintImpl;
import org.apache.jetspeed.om.page.impl.SecurityConstraintsDefImpl;
import org.apache.jetspeed.page.document.impl.DocumentImpl;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;

public class PageSecurityImpl
extends DocumentImpl
implements PageSecurity {
    private List<SecurityConstraintsDefImpl> constraintsDefs;
    private List<PageSecurityGlobalSecurityConstraintsRef> globalConstraintsRefs;
    private PageSecurityConstraintsDefList securityConstraintsDefs;
    private Map<String, SecurityConstraintsDef> securityConstraintsDefsMap;
    private PageSecurityConstraintsRefList globalSecurityConstraintsRefs;

    public PageSecurityImpl() {
        super(null);
    }

    List<SecurityConstraintsDefImpl> accessConstraintsDefs() {
        if (this.constraintsDefs == null) {
            this.constraintsDefs = DatabasePageManagerUtils.createList();
        }
        return this.constraintsDefs;
    }

    List<PageSecurityGlobalSecurityConstraintsRef> accessGlobalConstraintsRefs() {
        if (this.globalConstraintsRefs == null) {
            this.globalConstraintsRefs = DatabasePageManagerUtils.createList();
        }
        return this.globalConstraintsRefs;
    }

    synchronized void clearSecurityConstraintsDefsMap() {
        this.securityConstraintsDefsMap = null;
    }

    @Override
    public SecurityConstraint newSecurityConstraint() {
        return new PageSecuritySecurityConstraintImpl();
    }

    public List<SecurityConstraintsDef> getSecurityConstraintsDefs() {
        if (this.securityConstraintsDefs == null) {
            this.securityConstraintsDefs = new PageSecurityConstraintsDefList(this);
        }
        return this.securityConstraintsDefs;
    }

    public SecurityConstraintsDef newSecurityConstraintsDef() {
        return new SecurityConstraintsDefImpl();
    }

    public void setSecurityConstraintsDefs(List<SecurityConstraintsDef> definitions) {
        List<SecurityConstraintsDef> securityConstraintsDefs = this.getSecurityConstraintsDefs();
        if (definitions != securityConstraintsDefs) {
            securityConstraintsDefs.clear();
            if (definitions != null) {
                securityConstraintsDefs.addAll(definitions);
            }
        }
        this.clearSecurityConstraintsDefsMap();
    }

    public synchronized SecurityConstraintsDef getSecurityConstraintsDef(String name) {
        if (this.getSecurityConstraintsDefs() != null && this.securityConstraintsDefsMap == null) {
            this.securityConstraintsDefsMap = new HashMap<String, SecurityConstraintsDef>(this.getSecurityConstraintsDefs().size() * 2 + 1);
            for (SecurityConstraintsDef definition : this.getSecurityConstraintsDefs()) {
                String definitionName = definition.getName();
                if (this.securityConstraintsDefsMap.containsKey(definitionName)) continue;
                this.securityConstraintsDefsMap.put(definitionName, definition);
            }
        }
        if (this.securityConstraintsDefsMap != null) {
            return this.securityConstraintsDefsMap.get(name);
        }
        return null;
    }

    public List<String> getGlobalSecurityConstraintsRefs() {
        if (this.globalSecurityConstraintsRefs == null) {
            this.globalSecurityConstraintsRefs = new PageSecurityConstraintsRefList(this);
        }
        return this.globalSecurityConstraintsRefs;
    }

    public void setGlobalSecurityConstraintsRefs(List<String> constraintsRefs) {
        List<String> globalSecurityConstraintsRefs = this.getGlobalSecurityConstraintsRefs();
        if (constraintsRefs != globalSecurityConstraintsRefs) {
            globalSecurityConstraintsRefs.clear();
            if (constraintsRefs != null) {
                globalSecurityConstraintsRefs.addAll(constraintsRefs);
            }
        }
    }

    @Override
    public String getType() {
        return "page.security";
    }
}

