/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.om.page.impl.PageSecurityImpl;
import org.apache.jetspeed.om.page.impl.SecurityConstraintsDefImpl;

class PageSecurityConstraintsDefList
extends AbstractList<SecurityConstraintsDef> {
    private PageSecurityImpl pageSecurity;
    private List<SecurityConstraintsDef> removedConstraintsDefs;

    PageSecurityConstraintsDefList(PageSecurityImpl pageSecurity) {
        this.pageSecurity = pageSecurity;
    }

    private SecurityConstraintsDefImpl validateConstraintsDefForAdd(SecurityConstraintsDef constraintsDef) {
        int removedIndex;
        if (constraintsDef == null) {
            throw new NullPointerException("Unable to add null to list.");
        }
        if (this.pageSecurity.accessConstraintsDefs().contains(constraintsDef)) {
            throw new IllegalArgumentException("Unable to add duplicate entry to list: " + constraintsDef.getName());
        }
        if (this.removedConstraintsDefs != null && (removedIndex = this.removedConstraintsDefs.indexOf(constraintsDef)) >= 0) {
            SecurityConstraintsDef addConstraintsDef = constraintsDef;
            constraintsDef = this.removedConstraintsDefs.remove(removedIndex);
            constraintsDef.setSecurityConstraints(addConstraintsDef.getSecurityConstraints());
        }
        return (SecurityConstraintsDefImpl)constraintsDef;
    }

    private List<SecurityConstraintsDef> getRemovedConstraintsDefs() {
        if (this.removedConstraintsDefs == null) {
            this.removedConstraintsDefs = Collections.synchronizedList(new ArrayList());
        }
        return this.removedConstraintsDefs;
    }

    @Override
    public void add(int index, SecurityConstraintsDef element) {
        if (index < 0 || index > this.pageSecurity.accessConstraintsDefs().size()) {
            throw new IndexOutOfBoundsException("Unable to add to list at index: " + index);
        }
        SecurityConstraintsDefImpl constraintsDef = this.validateConstraintsDefForAdd(element);
        this.pageSecurity.accessConstraintsDefs().add(index, constraintsDef);
        this.pageSecurity.clearSecurityConstraintsDefsMap();
    }

    @Override
    public SecurityConstraintsDef get(int index) {
        return this.pageSecurity.accessConstraintsDefs().get(index);
    }

    @Override
    public SecurityConstraintsDef remove(int index) {
        SecurityConstraintsDefImpl removed = this.pageSecurity.accessConstraintsDefs().remove(index);
        if (removed != null) {
            this.getRemovedConstraintsDefs().add(removed);
            this.pageSecurity.clearSecurityConstraintsDefsMap();
        }
        return removed;
    }

    @Override
    public SecurityConstraintsDef set(int index, SecurityConstraintsDef element) {
        SecurityConstraintsDefImpl newConstraintsDef = this.validateConstraintsDefForAdd((SecurityConstraintsDefImpl)element);
        SecurityConstraintsDefImpl constraintsDef = this.pageSecurity.accessConstraintsDefs().set(index, newConstraintsDef);
        this.getRemovedConstraintsDefs().add(constraintsDef);
        this.pageSecurity.clearSecurityConstraintsDefsMap();
        return constraintsDef;
    }

    @Override
    public int size() {
        return this.pageSecurity.accessConstraintsDefs().size();
    }
}

