/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jetspeed.om.page.impl.BaseFragmentElementImpl;
import org.apache.jetspeed.om.page.impl.FragmentPreferenceImpl;
import org.apache.jetspeed.om.preference.FragmentPreference;

class FragmentPreferenceList
extends AbstractList<FragmentPreference> {
    private BaseFragmentElementImpl fragment;
    private List<FragmentPreference> removedPreferences;

    FragmentPreferenceList(BaseFragmentElementImpl fragment) {
        this.fragment = fragment;
    }

    private FragmentPreferenceImpl validatePreferenceForAdd(FragmentPreference preference) {
        int removedIndex;
        if (preference == null) {
            throw new NullPointerException("Unable to add null to list.");
        }
        if (this.fragment.accessPreferences().contains(preference)) {
            throw new IllegalArgumentException("Unable to add duplicate entry to list: " + preference.getName());
        }
        if (this.removedPreferences != null && (removedIndex = this.removedPreferences.indexOf(preference)) >= 0) {
            FragmentPreference addPreference = preference;
            preference = this.removedPreferences.remove(removedIndex);
            preference.setReadOnly(addPreference.isReadOnly());
            preference.setValueList(addPreference.getValueList());
        }
        return (FragmentPreferenceImpl)preference;
    }

    private List<FragmentPreference> getRemovedPreferences() {
        if (this.removedPreferences == null) {
            this.removedPreferences = Collections.synchronizedList(new ArrayList());
        }
        return this.removedPreferences;
    }

    @Override
    public void add(int index, FragmentPreference element) {
        if (index < 0 || index > this.fragment.accessPreferences().size()) {
            throw new IndexOutOfBoundsException("Unable to add to list at index: " + index);
        }
        FragmentPreferenceImpl preference = this.validatePreferenceForAdd(element);
        this.fragment.accessPreferences().add(index, preference);
    }

    @Override
    public FragmentPreference get(int index) {
        return this.fragment.accessPreferences().get(index);
    }

    @Override
    public FragmentPreference remove(int index) {
        FragmentPreference removed = this.fragment.accessPreferences().remove(index);
        if (removed != null) {
            this.getRemovedPreferences().add(removed);
        }
        return removed;
    }

    @Override
    public FragmentPreference set(int index, FragmentPreference element) {
        FragmentPreferenceImpl newPreference = this.validatePreferenceForAdd(element);
        FragmentPreferenceImpl preference = this.fragment.accessPreferences().set(index, newPreference);
        this.getRemovedPreferences().add(preference);
        return preference;
    }

    @Override
    public int size() {
        return this.fragment.accessPreferences().size();
    }
}

