/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.jetspeed.om.page.FragmentProperty;
import org.apache.jetspeed.security.Group;
import org.apache.jetspeed.security.JSSubject;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;

public abstract class BaseFragmentPropertyImpl
implements FragmentProperty {
    public static boolean getFragmentProperty(String propName, List<FragmentProperty> properties, String[] userValue, String[] groupValue, String[] roleValue, String[] globalValue) {
        boolean valueFound = false;
        Set principals = null;
        Principal userPrincipal = null;
        boolean skipPropertyScopes = false;
        Iterator<FragmentProperty> propertiesIter = properties.iterator();
        while (userValue[0] == null && propertiesIter.hasNext()) {
            FragmentProperty fragmentProperty = propertiesIter.next();
            if (!fragmentProperty.getName().equals(propName)) continue;
            String fragmentPropertyScope = fragmentProperty.getScope();
            if (fragmentPropertyScope != null) {
                if (skipPropertyScopes) continue;
                if (principals == null) {
                    Subject subject = JSSubject.getSubject((AccessControlContext)AccessController.getContext());
                    if (subject != null) {
                        userPrincipal = SubjectHelper.getBestPrincipal((Subject)subject, User.class);
                    } else {
                        skipPropertyScopes = true;
                    }
                }
                String fragmentPropertyScopeValue = fragmentProperty.getScopeValue();
                if (userPrincipal != null) {
                    if (!fragmentPropertyScope.equals("user") || !userPrincipal.getName().equals(fragmentPropertyScopeValue)) continue;
                    userValue[0] = fragmentProperty.getValue();
                    valueFound = true;
                    continue;
                }
                if (principals == null) continue;
                Iterator principalsIter = principals.iterator();
                while (userValue[0] == null && principalsIter.hasNext()) {
                    Principal principal = (Principal)principalsIter.next();
                    if (!principal.getName().equals(fragmentPropertyScopeValue)) continue;
                    if (fragmentPropertyScope.equals("user") && principal instanceof User) {
                        userValue[0] = fragmentProperty.getValue();
                        valueFound = true;
                        continue;
                    }
                    if (groupValue[0] != null) continue;
                    if (fragmentPropertyScope.equals("group") && principal instanceof Group) {
                        groupValue[0] = fragmentProperty.getValue();
                        valueFound = true;
                        continue;
                    }
                    if (roleValue[0] != null || !fragmentPropertyScope.equals("role") || !(principal instanceof Role)) continue;
                    roleValue[0] = fragmentProperty.getValue();
                    valueFound = true;
                }
                continue;
            }
            if (groupValue[0] != null || roleValue[0] != null || globalValue[0] != null) continue;
            globalValue[0] = fragmentProperty.getValue();
            valueFound = true;
        }
        return valueFound;
    }

    public static List<FragmentProperty> filterFragmentProperties(List<FragmentProperty> properties) {
        ArrayList<FragmentProperty> filteredProperties = new ArrayList<FragmentProperty>();
        Set principals = null;
        Principal userPrincipal = null;
        boolean skipPropertyScopes = false;
        for (FragmentProperty fragmentProperty : properties) {
            String fragmentPropertyScope = fragmentProperty.getScope();
            if (fragmentPropertyScope != null) {
                if (skipPropertyScopes) continue;
                if (principals == null) {
                    Subject subject = JSSubject.getSubject((AccessControlContext)AccessController.getContext());
                    if (subject != null) {
                        userPrincipal = SubjectHelper.getBestPrincipal((Subject)subject, User.class);
                    } else {
                        skipPropertyScopes = true;
                    }
                }
                String fragmentPropertyScopeValue = fragmentProperty.getScopeValue();
                if (userPrincipal != null) {
                    if (!fragmentPropertyScope.equals("user") || !userPrincipal.getName().equals(fragmentPropertyScopeValue)) continue;
                    filteredProperties.add(fragmentProperty);
                    continue;
                }
                if (principals == null) continue;
                for (Principal principal : principals) {
                    if (!principal.getName().equals(fragmentPropertyScopeValue) || !(fragmentPropertyScope.equals("user") && principal instanceof User || fragmentPropertyScope.equals("group") && principal instanceof Group) && (!fragmentPropertyScope.equals("role") || !(principal instanceof Role))) continue;
                    filteredProperties.add(fragmentProperty);
                }
                continue;
            }
            filteredProperties.add(fragmentProperty);
        }
        return filteredProperties;
    }

    public static FragmentProperty findFragmentProperty(String propName, String propScope, String propScopeValue, List<FragmentProperty> properties) {
        Object fragmentProperty = null;
        for (FragmentProperty findFragmentProperty : properties) {
            String findFragmentPropertyScopeValue;
            if (!findFragmentProperty.getName().equals(propName)) continue;
            String findFragmentPropertyScope = findFragmentProperty.getScope();
            if (propScope == null && findFragmentPropertyScope == null) {
                return findFragmentProperty;
            }
            if (findFragmentPropertyScope == null || !findFragmentPropertyScope.equals(propScope) || (findFragmentPropertyScopeValue = findFragmentProperty.getScopeValue()) == null || !findFragmentPropertyScopeValue.equals(propScopeValue)) continue;
            return findFragmentProperty;
        }
        return null;
    }

    public static String getCurrentUserScopeValue() {
        Principal userPrincipal;
        Subject subject = JSSubject.getSubject((AccessControlContext)AccessController.getContext());
        if (subject != null && (userPrincipal = SubjectHelper.getBestPrincipal((Subject)subject, User.class)) != null) {
            return userPrincipal.getName();
        }
        return null;
    }
}

