/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.folder.impl;

import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.om.folder.MenuExcludeDefinition;
import org.apache.jetspeed.om.folder.MenuIncludeDefinition;
import org.apache.jetspeed.om.folder.MenuOptionsDefinition;
import org.apache.jetspeed.om.folder.MenuSeparatorDefinition;
import org.apache.jetspeed.om.folder.impl.FolderMenuDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuDefinitionList;
import org.apache.jetspeed.om.folder.impl.FolderMenuExcludeDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuIncludeDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuOptionsDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuSeparatorDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMetadataLocalizedFieldImpl;
import org.apache.jetspeed.om.folder.impl.FolderOrder;
import org.apache.jetspeed.om.folder.impl.FolderOrderList;
import org.apache.jetspeed.om.folder.impl.FolderSecurityConstraintsImpl;
import org.apache.jetspeed.om.page.DynamicPage;
import org.apache.jetspeed.om.page.FragmentDefinition;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageMetadataImpl;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.om.page.impl.DynamicPageImpl;
import org.apache.jetspeed.om.page.impl.FragmentDefinitionImpl;
import org.apache.jetspeed.om.page.impl.LinkImpl;
import org.apache.jetspeed.om.page.impl.PageImpl;
import org.apache.jetspeed.om.page.impl.PageSecurityImpl;
import org.apache.jetspeed.om.page.impl.PageTemplateImpl;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.DocumentException;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.impl.NodeImpl;
import org.apache.jetspeed.page.document.impl.NodeSetImpl;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;
import org.apache.jetspeed.security.PermissionFactory;
import org.apache.ojb.broker.core.proxy.ProxyHelper;

public class FolderImpl
extends NodeImpl
implements Folder {
    private String defaultPage;
    private String skin;
    private String defaultLayoutDecorator;
    private String defaultPortletDecorator;
    private List<FolderOrder> orders;
    private List<FolderMenuDefinitionImpl> menus;
    private List<FolderImpl> folders;
    private boolean foldersCached;
    private List<PageImpl> pages;
    private boolean pagesCached;
    private List<PageTemplateImpl> pageTemplates;
    private boolean pageTemplatesCached;
    private List<DynamicPageImpl> dynamicPages;
    private boolean dynamicPagesCached;
    private List<FragmentDefinitionImpl> fragmentDefinitions;
    private boolean fragmentDefinitionsCached;
    private List<LinkImpl> links;
    private boolean linksCached;
    private PageSecurityImpl pageSecurity;
    private boolean pageSecurityCached;
    private List<Node> all;
    private boolean allCached;
    private FolderOrderList documentOrder;
    private boolean documentOrderComparatorValid;
    private Comparator<String> documentOrderComparator;
    private NodeSet foldersNodeSet;
    private NodeSet pagesNodeSet;
    private NodeSet pageTemplatesNodeSet;
    private NodeSet dynamicPagesNodeSet;
    private NodeSet fragmentDefinitionsNodeSet;
    private NodeSet linksNodeSet;
    private NodeSet allNodeSet;
    private FolderMenuDefinitionList menuDefinitions;
    protected static PermissionFactory pf;

    public static void setPermissionsFactory(PermissionFactory pf) {
        FolderImpl.pf = pf;
    }

    public FolderImpl() {
        super(new FolderSecurityConstraintsImpl());
    }

    List<FolderOrder> accessFolderOrders() {
        if (this.orders == null) {
            this.orders = DatabasePageManagerUtils.createList();
        }
        return this.orders;
    }

    List<FolderMenuDefinitionImpl> accessMenus() {
        if (this.menus == null) {
            this.menus = DatabasePageManagerUtils.createList();
        }
        return this.menus;
    }

    public List<FolderImpl> accessFolders() {
        if (this.folders == null) {
            this.folders = Collections.synchronizedList(new ArrayList());
        }
        return this.folders;
    }

    public void resetFolders(boolean cached) {
        this.foldersCached = cached;
        this.allCached = false;
        if (!cached) {
            this.accessFolders().clear();
        }
        this.accessAll().clear();
        this.foldersNodeSet = null;
        this.allNodeSet = null;
    }

    public List<PageImpl> accessPages() {
        if (this.pages == null) {
            this.pages = Collections.synchronizedList(new ArrayList());
        }
        return this.pages;
    }

    public void resetPages(boolean cached) {
        this.pagesCached = cached;
        this.allCached = false;
        if (!cached) {
            this.accessPages().clear();
        }
        this.accessAll().clear();
        this.pagesNodeSet = null;
        this.allNodeSet = null;
    }

    public List<PageTemplateImpl> accessPageTemplates() {
        if (this.pageTemplates == null) {
            this.pageTemplates = Collections.synchronizedList(new ArrayList());
        }
        return this.pageTemplates;
    }

    public void resetPageTemplates(boolean cached) {
        this.pageTemplatesCached = cached;
        this.allCached = false;
        if (!cached) {
            this.accessPageTemplates().clear();
        }
        this.accessAll().clear();
        this.pageTemplatesNodeSet = null;
        this.allNodeSet = null;
    }

    public List<DynamicPageImpl> accessDynamicPages() {
        if (this.dynamicPages == null) {
            this.dynamicPages = Collections.synchronizedList(new ArrayList());
        }
        return this.dynamicPages;
    }

    public void resetDynamicPages(boolean cached) {
        this.dynamicPagesCached = cached;
        this.allCached = false;
        if (!cached) {
            this.accessDynamicPages().clear();
        }
        this.accessAll().clear();
        this.dynamicPagesNodeSet = null;
        this.allNodeSet = null;
    }

    public List<FragmentDefinitionImpl> accessFragmentDefinitions() {
        if (this.fragmentDefinitions == null) {
            this.fragmentDefinitions = Collections.synchronizedList(new ArrayList());
        }
        return this.fragmentDefinitions;
    }

    public void resetFragmentDefinitions(boolean cached) {
        this.fragmentDefinitionsCached = cached;
        this.allCached = false;
        if (!cached) {
            this.accessFragmentDefinitions().clear();
        }
        this.accessAll().clear();
        this.fragmentDefinitionsNodeSet = null;
        this.allNodeSet = null;
    }

    public List<LinkImpl> accessLinks() {
        if (this.links == null) {
            this.links = Collections.synchronizedList(new ArrayList());
        }
        return this.links;
    }

    public void resetLinks(boolean cached) {
        this.linksCached = cached;
        this.allCached = false;
        if (!cached) {
            this.accessLinks().clear();
        }
        this.accessAll().clear();
        this.linksNodeSet = null;
        this.allNodeSet = null;
    }

    public PageSecurityImpl accessPageSecurity() {
        return this.pageSecurity;
    }

    public void resetPageSecurity(PageSecurityImpl newPageSecurity, boolean cached) {
        this.pageSecurity = newPageSecurity;
        this.pageSecurityCached = cached;
        this.allCached = false;
        this.accessAll().clear();
        this.allNodeSet = null;
    }

    public List<Node> accessAll() {
        if (this.all == null) {
            this.all = Collections.synchronizedList(new ArrayList());
        }
        return this.all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAll(boolean cached) {
        this.allCached = cached;
        this.foldersCached = cached;
        this.pagesCached = cached;
        this.pageTemplatesCached = cached;
        this.dynamicPagesCached = cached;
        this.fragmentDefinitionsCached = cached;
        this.linksCached = cached;
        this.pageSecurityCached = cached;
        this.accessFolders().clear();
        this.accessPages().clear();
        this.accessPageTemplates().clear();
        this.accessDynamicPages().clear();
        this.accessFragmentDefinitions().clear();
        this.accessLinks().clear();
        this.pageSecurity = null;
        if (cached) {
            List<Node> list = this.all;
            synchronized (list) {
                for (Node node : this.accessAll()) {
                    if (node instanceof PageImpl) {
                        this.pages.add((PageImpl)node);
                        continue;
                    }
                    if (node instanceof PageTemplateImpl) {
                        this.pageTemplates.add((PageTemplateImpl)node);
                        continue;
                    }
                    if (node instanceof DynamicPageImpl) {
                        this.dynamicPages.add((DynamicPageImpl)node);
                        continue;
                    }
                    if (node instanceof FragmentDefinitionImpl) {
                        this.fragmentDefinitions.add((FragmentDefinitionImpl)node);
                        continue;
                    }
                    if (node instanceof FolderImpl) {
                        this.folders.add((FolderImpl)node);
                        continue;
                    }
                    if (node instanceof LinkImpl) {
                        this.links.add((LinkImpl)node);
                        continue;
                    }
                    if (!(node instanceof PageSecurityImpl)) continue;
                    this.pageSecurity = (PageSecurityImpl)node;
                }
            }
        } else {
            this.accessAll().clear();
        }
        this.allNodeSet = null;
        this.foldersNodeSet = null;
        this.pagesNodeSet = null;
        this.pageTemplatesNodeSet = null;
        this.dynamicPagesNodeSet = null;
        this.fragmentDefinitionsNodeSet = null;
        this.linksNodeSet = null;
    }

    private Comparator<String> createDocumentOrderComparator() {
        if (!this.documentOrderComparatorValid) {
            this.documentOrderComparatorValid = true;
            final List<String> documentOrder = this.getDocumentOrder();
            if (documentOrder == null || documentOrder.isEmpty()) {
                return null;
            }
            this.documentOrderComparator = new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    String name2;
                    int index2;
                    String name1 = s1;
                    int index1 = documentOrder.indexOf(name1);
                    if (index1 >= 0) {
                        name1 = String.valueOf(index1);
                    }
                    if ((index2 = documentOrder.indexOf(name2 = s2)) >= 0) {
                        name2 = String.valueOf(index2);
                        if (index1 >= 0) {
                            while (name1.length() != name2.length()) {
                                if (name1.length() < name2.length()) {
                                    name1 = "0" + name1;
                                    continue;
                                }
                                name2 = "0" + name2;
                            }
                        }
                    }
                    return name1.compareTo(name2);
                }
            };
        }
        return this.documentOrderComparator;
    }

    void clearDocumentOrderComparator() {
        this.documentOrderComparatorValid = false;
        this.documentOrderComparator = null;
        this.allNodeSet = null;
        this.foldersNodeSet = null;
        this.pagesNodeSet = null;
        this.pageTemplatesNodeSet = null;
        this.dynamicPagesNodeSet = null;
        this.fragmentDefinitionsNodeSet = null;
    }

    @Override
    public PageMetadataImpl newPageMetadata(Collection<LocalizedField> fields) {
        PageMetadataImpl pageMetadata = new PageMetadataImpl(FolderMetadataLocalizedFieldImpl.class);
        pageMetadata.setFields(fields);
        return pageMetadata;
    }

    @Override
    public PageSecurity getEffectivePageSecurity() {
        block6: {
            if (!this.pageSecurityCached) {
                try {
                    return this.getPageManager().getPageSecurity((Folder)this);
                }
                catch (NodeException ne) {
                    break block6;
                }
                catch (NodeNotFoundException nnfe) {
                    break block6;
                }
            }
            if (this.pageSecurity != null) {
                return this.pageSecurity;
            }
        }
        FolderImpl parentFolderImpl = (FolderImpl)ProxyHelper.getRealObject((Object)this.getParent());
        if (parentFolderImpl != null) {
            return parentFolderImpl.getEffectivePageSecurity();
        }
        return null;
    }

    @Override
    public void checkPermissions(String path, int mask, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        FolderImpl parentFolderImpl;
        if (!checkParentsOnly) {
            AccessController.checkPermission((Permission)pf.newPermission("folder", path, mask));
        }
        if (!checkNodeOnly && (parentFolderImpl = (FolderImpl)ProxyHelper.getRealObject((Object)this.getParent())) != null) {
            parentFolderImpl.checkPermissions(mask, false, false);
        }
    }

    @Override
    public String getTitle() {
        String title = super.getTitle();
        if (title == null) {
            title = this.defaultTitleFromName();
            this.setTitle(title);
        }
        return title;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String skinName) {
        this.skin = skinName;
    }

    public String getEffectiveDefaultDecorator(String fragmentType) {
        Folder parentFolder;
        String decorator = this.getDefaultDecorator(fragmentType);
        if (decorator == null && (parentFolder = (Folder)ProxyHelper.getRealObject((Object)this.getParent())) != null) {
            return parentFolder.getEffectiveDefaultDecorator(fragmentType);
        }
        return decorator;
    }

    public String getDefaultDecorator(String fragmentType) {
        if (fragmentType != null) {
            if (fragmentType.equals("layout")) {
                return this.defaultLayoutDecorator;
            }
            if (fragmentType.equals("portlet")) {
                return this.defaultPortletDecorator;
            }
        }
        return null;
    }

    public void setDefaultDecorator(String decoratorName, String fragmentType) {
        if (fragmentType != null) {
            if (fragmentType.equals("layout")) {
                this.defaultLayoutDecorator = decoratorName;
            }
            if (fragmentType.equals("portlet")) {
                this.defaultPortletDecorator = decoratorName;
            }
        }
    }

    public List<String> getDocumentOrder() {
        if (this.documentOrder == null) {
            this.documentOrder = new FolderOrderList(this);
        }
        return this.documentOrder;
    }

    public void setDocumentOrder(List<String> docNames) {
        List<String> documentOrder = this.getDocumentOrder();
        if (docNames != documentOrder) {
            documentOrder.clear();
            if (docNames != null) {
                documentOrder.addAll(docNames);
            }
        }
    }

    public String getDefaultPage() {
        return this.defaultPage;
    }

    public void setDefaultPage(String defaultPage) {
        this.defaultPage = defaultPage;
    }

    public NodeSet getFolders() throws DocumentException {
        if (!this.foldersCached) {
            return this.getPageManager().getFolders((Folder)this);
        }
        return FolderImpl.filterNodeSetByAccess(this.getFoldersNodeSet());
    }

    public Folder getFolder(String name) throws FolderNotFoundException, DocumentException {
        if (!this.foldersCached) {
            return this.getPageManager().getFolder((Folder)this, name);
        }
        Folder folder = (Folder)this.getFoldersNodeSet().get(name);
        if (folder == null) {
            throw new FolderNotFoundException("Folder not found: " + name);
        }
        folder.checkAccess(JetspeedActions.VIEW);
        return folder;
    }

    public NodeSet getPages() throws NodeException {
        if (!this.pagesCached) {
            return this.getPageManager().getPages((Folder)this);
        }
        return FolderImpl.filterNodeSetByAccess(this.getPagesNodeSet());
    }

    public Page getPage(String name) throws PageNotFoundException, NodeException {
        if (!this.pagesCached) {
            return this.getPageManager().getPage((Folder)this, name);
        }
        Page page = (Page)this.getPagesNodeSet().get(name);
        if (page == null) {
            throw new PageNotFoundException("Page not found: " + name);
        }
        page.checkAccess(JetspeedActions.VIEW);
        return page;
    }

    public NodeSet getPageTemplates() throws NodeException {
        if (!this.pageTemplatesCached) {
            return this.getPageManager().getPageTemplates((Folder)this);
        }
        return FolderImpl.filterNodeSetByAccess(this.getPageTemplatesNodeSet());
    }

    public PageTemplate getPageTemplate(String name) throws PageNotFoundException, NodeException {
        if (!this.pageTemplatesCached) {
            return this.getPageManager().getPageTemplate((Folder)this, name);
        }
        PageTemplate pageTemplate = (PageTemplate)this.getPageTemplatesNodeSet().get(name);
        if (pageTemplate == null) {
            throw new PageNotFoundException("PageTemplate not found: " + name);
        }
        pageTemplate.checkAccess(JetspeedActions.VIEW);
        return pageTemplate;
    }

    public NodeSet getDynamicPages() throws NodeException {
        if (!this.dynamicPagesCached) {
            return this.getPageManager().getDynamicPages((Folder)this);
        }
        return FolderImpl.filterNodeSetByAccess(this.getDynamicPagesNodeSet());
    }

    public DynamicPage getDynamicPage(String name) throws PageNotFoundException, NodeException {
        if (!this.dynamicPagesCached) {
            return this.getPageManager().getDynamicPage((Folder)this, name);
        }
        DynamicPage dynamicPage = (DynamicPage)this.getDynamicPagesNodeSet().get(name);
        if (dynamicPage == null) {
            throw new PageNotFoundException("DynamicPage not found: " + name);
        }
        dynamicPage.checkAccess(JetspeedActions.VIEW);
        return dynamicPage;
    }

    public NodeSet getFragmentDefinitions() throws NodeException {
        if (!this.fragmentDefinitionsCached) {
            return this.getPageManager().getFragmentDefinitions((Folder)this);
        }
        return FolderImpl.filterNodeSetByAccess(this.getFragmentDefinitionsNodeSet());
    }

    public FragmentDefinition getFragmentDefinition(String name) throws PageNotFoundException, NodeException {
        if (!this.fragmentDefinitionsCached) {
            return this.getPageManager().getFragmentDefinition((Folder)this, name);
        }
        FragmentDefinition fragmentDefinition = (FragmentDefinition)this.getFragmentDefinitionsNodeSet().get(name);
        if (fragmentDefinition == null) {
            throw new PageNotFoundException("FragmentDefinition not found: " + name);
        }
        fragmentDefinition.checkAccess(JetspeedActions.VIEW);
        return fragmentDefinition;
    }

    public NodeSet getLinks() throws NodeException {
        if (!this.linksCached) {
            return this.getPageManager().getLinks((Folder)this);
        }
        return FolderImpl.filterNodeSetByAccess(this.getLinksNodeSet());
    }

    public Link getLink(String name) throws DocumentNotFoundException, NodeException {
        if (!this.linksCached) {
            return this.getPageManager().getLink((Folder)this, name);
        }
        Link link = (Link)this.getLinksNodeSet().get(name);
        if (link == null) {
            throw new DocumentNotFoundException("Link not found: " + name);
        }
        link.checkAccess(JetspeedActions.VIEW);
        return link;
    }

    public PageSecurity getPageSecurity() throws DocumentNotFoundException, NodeException {
        if (!this.pageSecurityCached) {
            return this.getPageManager().getPageSecurity((Folder)this);
        }
        if (this.pageSecurity == null) {
            throw new DocumentNotFoundException("Page security document not found");
        }
        this.pageSecurity.checkAccess(JetspeedActions.VIEW);
        return this.pageSecurity;
    }

    public NodeSet getAll() throws DocumentException {
        if (!this.allCached) {
            return this.getPageManager().getAll((Folder)this);
        }
        return FolderImpl.filterNodeSetByAccess(this.getAllNodeSet());
    }

    public List<MenuDefinition> getMenuDefinitions() {
        if (this.menuDefinitions == null) {
            this.menuDefinitions = new FolderMenuDefinitionList(this);
        }
        return this.menuDefinitions;
    }

    public MenuDefinition newMenuDefinition() {
        return new FolderMenuDefinitionImpl();
    }

    public MenuExcludeDefinition newMenuExcludeDefinition() {
        return new FolderMenuExcludeDefinitionImpl();
    }

    public MenuIncludeDefinition newMenuIncludeDefinition() {
        return new FolderMenuIncludeDefinitionImpl();
    }

    public MenuOptionsDefinition newMenuOptionsDefinition() {
        return new FolderMenuOptionsDefinitionImpl();
    }

    public MenuSeparatorDefinition newMenuSeparatorDefinition() {
        return new FolderMenuSeparatorDefinitionImpl();
    }

    public void setMenuDefinitions(List<MenuDefinition> definitions) {
        List<MenuDefinition> menuDefinitions = this.getMenuDefinitions();
        if (definitions != menuDefinitions) {
            menuDefinitions.clear();
            if (definitions != null) {
                menuDefinitions.addAll(definitions);
            }
        }
    }

    public boolean isReserved() {
        return false;
    }

    public int getReservedType() {
        return 0;
    }

    @Override
    public String getType() {
        return "folder";
    }

    private NodeSet getFoldersNodeSet() {
        if (this.foldersNodeSet == null) {
            this.foldersNodeSet = this.folders != null && !this.folders.isEmpty() ? new NodeSetImpl(this.folders, this.createDocumentOrderComparator()) : NodeSetImpl.EMPTY_NODE_SET;
        }
        return this.foldersNodeSet;
    }

    private NodeSet getPagesNodeSet() throws NodeException {
        if (this.pagesNodeSet == null) {
            this.pagesNodeSet = this.pages != null && !this.pages.isEmpty() ? new NodeSetImpl(this.pages, this.createDocumentOrderComparator()) : NodeSetImpl.EMPTY_NODE_SET;
        }
        return this.pagesNodeSet;
    }

    private NodeSet getPageTemplatesNodeSet() throws NodeException {
        if (this.pageTemplatesNodeSet == null) {
            this.pageTemplatesNodeSet = this.pageTemplates != null && !this.pageTemplates.isEmpty() ? new NodeSetImpl(this.pageTemplates, this.createDocumentOrderComparator()) : NodeSetImpl.EMPTY_NODE_SET;
        }
        return this.pageTemplatesNodeSet;
    }

    private NodeSet getDynamicPagesNodeSet() throws NodeException {
        if (this.dynamicPagesNodeSet == null) {
            this.dynamicPagesNodeSet = this.dynamicPages != null && !this.dynamicPages.isEmpty() ? new NodeSetImpl(this.dynamicPages, this.createDocumentOrderComparator()) : NodeSetImpl.EMPTY_NODE_SET;
        }
        return this.dynamicPagesNodeSet;
    }

    private NodeSet getFragmentDefinitionsNodeSet() throws NodeException {
        if (this.fragmentDefinitionsNodeSet == null) {
            this.fragmentDefinitionsNodeSet = this.fragmentDefinitions != null && !this.fragmentDefinitions.isEmpty() ? new NodeSetImpl(this.fragmentDefinitions, this.createDocumentOrderComparator()) : NodeSetImpl.EMPTY_NODE_SET;
        }
        return this.fragmentDefinitionsNodeSet;
    }

    private NodeSet getLinksNodeSet() throws NodeException {
        if (this.linksNodeSet == null) {
            this.linksNodeSet = this.links != null && !this.links.isEmpty() ? new NodeSetImpl(this.links, this.createDocumentOrderComparator()) : NodeSetImpl.EMPTY_NODE_SET;
        }
        return this.linksNodeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeSet getAllNodeSet() {
        if (this.allNodeSet == null) {
            if (this.all != null && !this.all.isEmpty()) {
                List<Node> list = this.all;
                synchronized (list) {
                    this.allNodeSet = new NodeSetImpl(new ArrayList<Node>(this.all), this.createDocumentOrderComparator());
                }
            } else {
                this.allNodeSet = NodeSetImpl.EMPTY_NODE_SET;
            }
        }
        return this.allNodeSet;
    }

    static NodeSet filterNodeSetByAccess(NodeSet nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            NodeSetImpl filteredNodes = null;
            for (Node node : nodes) {
                try {
                    node.checkAccess(JetspeedActions.VIEW);
                    if (filteredNodes == null) continue;
                    filteredNodes.add(node);
                }
                catch (SecurityException se) {
                    Node copyNode;
                    if (filteredNodes != null) continue;
                    filteredNodes = new NodeSetImpl(nodes);
                    Iterator i$ = nodes.iterator();
                    while (i$.hasNext() && (copyNode = (Node)i$.next()) != node) {
                        filteredNodes.add(copyNode);
                    }
                }
            }
            if (filteredNodes != null) {
                return filteredNodes;
            }
        }
        return nodes;
    }
}

