/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.deploy;

import org.apache.jetspeed.tools.deploy.JetspeedWebApplicationRewriter;
import org.apache.jetspeed.tools.deploy.JetspeedWebApplicationRewriter2_3;
import org.apache.jetspeed.tools.deploy.JetspeedWebApplicationRewriter2_4;
import org.w3c.dom.Document;

public class JetspeedWebApplicationRewriterFactory {
    public JetspeedWebApplicationRewriter getInstance(Document doc) throws Exception {
        return this.getInstance(doc, null, null);
    }

    public JetspeedWebApplicationRewriter getInstance(Document doc, String portletApplication) throws Exception {
        return this.getInstance(doc, portletApplication, null);
    }

    public JetspeedWebApplicationRewriter getInstance(Document doc, String portletApplication, String forcedVersion) throws Exception {
        String version = forcedVersion;
        if (version == null && (version = doc.getDocumentElement().getAttribute("version")).equals("")) {
            version = "2.3";
        }
        try {
            Double.parseDouble(version);
        }
        catch (NumberFormatException e) {
            throw new Exception("Unable to create JetspeedWebApplicationRewriter for version " + version, e);
        }
        if (version.equals("2.3")) {
            return new JetspeedWebApplicationRewriter2_3(doc, portletApplication);
        }
        if (version.compareTo("2.4") >= 0) {
            return new JetspeedWebApplicationRewriter2_4(doc, portletApplication);
        }
        throw new Exception("Unable to create JetspeedWebApplicationRewriter for version " + version);
    }
}

