/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.layout;

import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.portlets.layout.LayoutCoordinate;
import org.apache.jetspeed.portlets.layout.LayoutEvent;
import org.apache.jetspeed.portlets.layout.LayoutEventException;
import org.apache.jetspeed.portlets.layout.LayoutEventListener;

public class PageManagerLayoutEventListener
implements LayoutEventListener {
    private final PageManager pageManager;
    private final Page page;

    public PageManagerLayoutEventListener(PageManager pageManager, Page page, String layoutType) {
        this.pageManager = pageManager;
        this.page = page;
    }

    public void handleEvent(LayoutEvent event) throws LayoutEventException {
        try {
            if (event.getEventType() == 0) {
                this.page.getRootFragment().getFragments().add(event.getFragment());
                this.pageManager.updatePage(this.page);
            } else {
                Fragment fragment = event.getFragment();
                LayoutCoordinate coordinate = event.getNewCoordinate();
                fragment.getProperties().put("column", String.valueOf(coordinate.getX()));
                fragment.getProperties().put("row", String.valueOf(coordinate.getY()));
                this.pageManager.updatePage(this.page);
            }
        }
        catch (Exception e) {
            throw new LayoutEventException("Unable to update page.", (Throwable)e);
        }
    }
}

