/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlet;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.UnavailableException;
import javax.portlet.WindowState;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.container.JetspeedPortletConfig;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.factory.PortletInstance;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.jetspeed.portlet.SupportsHeaderPhase;
import org.apache.jetspeed.util.BaseObjectProxy;
import org.apache.pluto.om.portlet.ContentTypeSet;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.servlet.WebApplicationDefinition;

public class PortletObjectProxy
extends BaseObjectProxy {
    private static ThreadLocal tlPortletObjectProxied = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new boolean[]{false};
        }
    };
    private static Method renderMethod;
    private static Method processActionMethod;
    private Object portletObject;
    private PortletInstance customConfigModePortletInstance;
    private boolean genericPortletInvocable;
    private Method portletDoEditMethod;
    private ContentTypeSet portletContentTypeSet;
    private boolean autoSwitchEditDefaultsModeToEditMode;
    private boolean autoSwitchConfigMode;
    private String customConfigModePortletUniqueName;

    public static void setPortletObjectProxied(boolean portletObjectProxied) {
        ((boolean[])PortletObjectProxy.tlPortletObjectProxied.get())[0] = portletObjectProxied;
    }

    public static boolean isPortletObjectProxied() {
        return ((boolean[])tlPortletObjectProxied.get())[0];
    }

    public static Object createProxy(Object proxiedObject, boolean autoSwitchEditDefaultsModeToEditMode, boolean autoSwitchConfigMode, String customConfigModePortletUniqueName) {
        Class<?> proxiedClass = proxiedObject.getClass();
        ClassLoader classLoader = proxiedClass.getClassLoader();
        Class[] proxyInterfaces = null;
        proxyInterfaces = proxiedObject instanceof SupportsHeaderPhase ? new Class[]{Portlet.class, SupportsHeaderPhase.class} : new Class[]{Portlet.class};
        PortletObjectProxy handler = new PortletObjectProxy(proxiedObject, autoSwitchEditDefaultsModeToEditMode, autoSwitchConfigMode, customConfigModePortletUniqueName);
        return Proxy.newProxyInstance(classLoader, proxyInterfaces, (InvocationHandler)handler);
    }

    private PortletObjectProxy(Object portletObject, boolean autoSwitchEditDefaultsModeToEditMode, boolean autoSwitchConfigMode, String customConfigModePortletUniqueName) {
        this.portletObject = portletObject;
        this.autoSwitchEditDefaultsModeToEditMode = autoSwitchEditDefaultsModeToEditMode;
        this.autoSwitchConfigMode = autoSwitchConfigMode;
        this.customConfigModePortletUniqueName = customConfigModePortletUniqueName;
        if (portletObject instanceof GenericPortlet) {
            try {
                this.portletDoEditMethod = this.portletObject.getClass().getMethod("doEdit", RenderRequest.class, RenderResponse.class);
                if (Modifier.isPublic(this.portletDoEditMethod.getModifiers())) {
                    this.genericPortletInvocable = true;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        boolean handledHere = false;
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass == Portlet.class) {
            if (renderMethod.equals(method)) {
                this.proxyRender((RenderRequest)args[0], (RenderResponse)args[1]);
                return null;
            }
            if (processActionMethod.equals(method)) {
                this.proxyProcessAction((ActionRequest)args[0], (ActionResponse)args[1]);
            } else {
                result = method.invoke(this.portletObject, args);
            }
        } else {
            result = declaringClass == SupportsHeaderPhase.class ? method.invoke(this.portletObject, args) : super.invoke(proxy, method, args);
        }
        return result;
    }

    protected void proxyRender(RenderRequest request, RenderResponse response) throws PortletException, IOException, Exception {
        PortletMode mode = request.getPortletMode();
        boolean autoSwitchConfigMode = false;
        boolean autoSwitchToEditMode = false;
        if (this.autoSwitchConfigMode && JetspeedActions.CONFIG_MODE.equals((Object)mode)) {
            autoSwitchConfigMode = true;
        }
        if (this.autoSwitchEditDefaultsModeToEditMode && this.genericPortletInvocable && JetspeedActions.EDIT_DEFAULTS_MODE.equals((Object)mode) && !this.isSupportingEditDefaultsMode((GenericPortlet)this.portletObject)) {
            autoSwitchToEditMode = true;
        }
        if (autoSwitchConfigMode) {
            try {
                if (this.customConfigModePortletInstance == null) {
                    this.refreshCustomConfigModePortletInstance();
                }
                this.customConfigModePortletInstance.render(request, response);
            }
            catch (UnavailableException e) {
                this.refreshCustomConfigModePortletInstance();
                this.customConfigModePortletInstance.render(request, response);
            }
        } else if (autoSwitchToEditMode) {
            GenericPortlet genericPortlet = (GenericPortlet)this.portletObject;
            WindowState state = request.getWindowState();
            if (!WindowState.MINIMIZED.equals((Object)state)) {
                String title = genericPortlet.getPortletConfig().getResourceBundle(request.getLocale()).getString("javax.portlet.title");
                response.setTitle(title);
                this.portletDoEditMethod.invoke((Object)genericPortlet, request, response);
            }
        } else {
            ((Portlet)this.portletObject).render(request, response);
        }
    }

    protected void proxyProcessAction(ActionRequest request, ActionResponse response) throws PortletException, IOException, Exception {
        PortletMode mode = request.getPortletMode();
        boolean autoSwitchConfigMode = false;
        if (this.autoSwitchConfigMode && JetspeedActions.CONFIG_MODE.equals((Object)mode)) {
            autoSwitchConfigMode = true;
        }
        if (autoSwitchConfigMode) {
            try {
                if (this.customConfigModePortletInstance == null) {
                    this.refreshCustomConfigModePortletInstance();
                }
                this.customConfigModePortletInstance.processAction(request, response);
            }
            catch (UnavailableException e) {
                this.refreshCustomConfigModePortletInstance();
                this.customConfigModePortletInstance.processAction(request, response);
            }
        } else {
            ((Portlet)this.portletObject).processAction(request, response);
        }
    }

    private boolean isSupportingEditDefaultsMode(GenericPortlet portlet) {
        if (this.portletContentTypeSet == null) {
            try {
                JetspeedPortletConfig config = (JetspeedPortletConfig)portlet.getPortletConfig();
                PortletDefinition portletDef = config.getPortletDefinition();
                this.portletContentTypeSet = portletDef.getContentTypeSet();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.portletContentTypeSet != null) {
            return this.portletContentTypeSet.supportsPortletMode(JetspeedActions.EDIT_DEFAULTS_MODE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCustomConfigModePortletInstance() {
        try {
            PortletRegistry registry = (PortletRegistry)Jetspeed.getComponentManager().getComponent((Object)"portletRegistry");
            PortletFactory portletFactory = (PortletFactory)Jetspeed.getComponentManager().getComponent((Object)"portletFactory");
            ServletContext portalAppContext = ((ServletConfig)Jetspeed.getComponentManager().getComponent((Object)"ServletConfig")).getServletContext();
            PortletDefinitionComposite portletDef = registry.getPortletDefinitionByUniqueName(this.customConfigModePortletUniqueName);
            MutablePortletApplication portletApp = (MutablePortletApplication)portletDef.getPortletApplicationDefinition();
            WebApplicationDefinition webAppDef = portletApp.getWebApplicationDefinition();
            String portletAppName = webAppDef.getContextRoot();
            ServletContext portletAppContext = portalAppContext.getContext(portletAppName);
            PortletObjectProxy.setPortletObjectProxied(true);
            this.customConfigModePortletInstance = portletFactory.getPortletInstance(portletAppContext, (PortletDefinition)portletDef);
        }
        catch (Exception exception) {
        }
        finally {
            PortletObjectProxy.setPortletObjectProxied(false);
        }
    }

    static {
        try {
            renderMethod = Portlet.class.getMethod("render", RenderRequest.class, RenderResponse.class);
            processActionMethod = Portlet.class.getMethod("processAction", ActionRequest.class, ActionResponse.class);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }
}

