/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.dispatcher;

import java.io.IOException;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.container.PortletDispatcherIncludeAware;
import org.apache.pluto.core.impl.RenderRequestImpl;
import org.apache.pluto.core.impl.RenderResponseImpl;

public class JetspeedRequestDispatcher
implements PortletRequestDispatcher {
    private RequestDispatcher requestDispatcher;

    public JetspeedRequestDispatcher(RequestDispatcher requestDispatcher) {
        if (requestDispatcher == null) {
            throw new IllegalArgumentException("RequestDispatcher cannot be null for JetspeedRequestDispatcher.");
        }
        this.requestDispatcher = requestDispatcher;
    }

    public void include(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        HttpServletRequest servletRequest = null;
        HttpServletResponse servletResponse = null;
        try {
            servletRequest = (HttpServletRequest)((RenderRequestImpl)request).getRequest();
            servletResponse = (HttpServletResponse)((RenderResponseImpl)response).getResponse();
            if (servletRequest instanceof PortletDispatcherIncludeAware) {
                ((PortletDispatcherIncludeAware)servletRequest).setPortletDispatcherIncluded(true);
            }
            if (servletResponse instanceof PortletDispatcherIncludeAware) {
                ((PortletDispatcherIncludeAware)servletResponse).setPortletDispatcherIncluded(true);
            }
            this.requestDispatcher.include((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            Throwable rootCause = null;
            rootCause = e instanceof ServletException ? ((ServletException)e).getRootCause() : e.getCause();
            throw new PortletException(rootCause != null ? rootCause : e);
        }
        finally {
            if (servletRequest != null && servletRequest instanceof PortletDispatcherIncludeAware) {
                ((PortletDispatcherIncludeAware)servletRequest).setPortletDispatcherIncluded(false);
            }
            if (servletResponse != null && servletResponse instanceof PortletDispatcherIncludeAware) {
                ((PortletDispatcherIncludeAware)servletResponse).setPortletDispatcherIncluded(false);
            }
        }
    }
}

