/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.tracking;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.aggregator.PortletTrackingManager;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;
import org.apache.velocity.context.Context;

public class PortletTrackingPortlet
extends GenericVelocityPortlet {
    private PortletTrackingManager trackingManager;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext context = this.getPortletContext();
        this.trackingManager = (PortletTrackingManager)context.getAttribute("cps:PortletTrackingManager");
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        List outOfService = this.createList();
        Context context = this.getContext(request);
        context.put("outOfService", (Object)outOfService);
        context.put("count", (Object)new Integer(outOfService.size()));
        super.doView(request, response);
    }

    protected List createList() {
        ArrayList<PortletDefinitionComposite> result = new ArrayList<PortletDefinitionComposite>();
        Iterator outOfService = this.trackingManager.getOutOfServiceList().iterator();
        HashMap<String, String> portlets = new HashMap<String, String>();
        while (outOfService.hasNext()) {
            PortletWindow window = (PortletWindow)outOfService.next();
            String id = window.getId().toString();
            PortletDefinitionComposite pd = (PortletDefinitionComposite)window.getPortletEntity().getPortletDefinition();
            String uniqueName = pd.getUniqueName();
            if (portlets.containsKey(uniqueName)) continue;
            portlets.put(uniqueName, id);
            result.add(pd);
        }
        return result;
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String[] values;
            String param = (String)e.nextElement();
            if (param.indexOf("::") <= 0 || (values = request.getParameterValues(param))[0] == null) continue;
            result.add(param);
        }
        if (result.size() > 0) {
            this.trackingManager.putIntoService(result);
        }
    }
}

