/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.statistics;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.statistics.AggregateStatistics;
import org.apache.jetspeed.statistics.InvalidCriteriaException;
import org.apache.jetspeed.statistics.PortalStatistics;
import org.apache.jetspeed.statistics.StatisticsQueryCriteria;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;
import org.apache.velocity.context.Context;

public class StatisticsPortlet
extends GenericVelocityPortlet {
    private PortalStatistics statistics;
    private static final String SESSION_CRITERIA = "criteria";
    private static final String SESSION_RESULTS = "results";
    private static final String SESSION_TOTALSESSIONS = "totalsessions";
    protected final Log logger = LogFactory.getLog(this.getClass());

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext context = this.getPortletContext();
        this.statistics = (PortalStatistics)context.getAttribute("cps:PortalStatistics");
        if (this.statistics == null) {
            throw new PortletException("Could not get instance of portal statistics component");
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        Context velocityContext = this.getContext(request);
        PortletSession session = request.getPortletSession();
        StatisticsQueryCriteria sqc = (StatisticsQueryCriteria)session.getAttribute(SESSION_CRITERIA);
        AggregateStatistics stats = (AggregateStatistics)session.getAttribute(SESSION_RESULTS);
        if (stats == null && sqc == null) {
            sqc = this.statistics.createStatisticsQueryCriteria();
            sqc.setQueryType("portlet");
            sqc.setTimePeriod("1");
            sqc.setListsize("5");
            sqc.setSorttype("count");
            sqc.setSortorder("desc");
            session.setAttribute(SESSION_CRITERIA, (Object)sqc);
            try {
                this.statistics.forceFlush();
                stats = this.statistics.queryStatistics(sqc);
            }
            catch (InvalidCriteriaException e) {
                this.logger.warn((Object)"unable to complete a statistics query ", (Throwable)e);
            }
            session.setAttribute(SESSION_RESULTS, (Object)stats);
        }
        velocityContext.put(SESSION_TOTALSESSIONS, (Object)("" + this.statistics.getNumberOfCurrentUsers()));
        velocityContext.put(SESSION_RESULTS, (Object)stats);
        velocityContext.put(SESSION_CRITERIA, (Object)sqc);
        super.doView(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        String listsizeStr;
        PortletSession session = request.getPortletSession();
        StatisticsQueryCriteria criteria = this.statistics.createStatisticsQueryCriteria();
        String user = request.getParameter("user");
        criteria.setUser(user);
        String timeperiod = request.getParameter("timeperiod");
        if (timeperiod == null) {
            timeperiod = "all";
        }
        if ((listsizeStr = request.getParameter("listsize")) == null) {
            listsizeStr = "5";
        } else {
            try {
                Integer.parseInt(listsizeStr);
            }
            catch (NumberFormatException e) {
                listsizeStr = "5";
            }
        }
        criteria.setListsize(listsizeStr);
        criteria.setSorttype("count");
        criteria.setSortorder("desc");
        criteria.setTimePeriod(timeperiod);
        String queryType = request.getParameter("queryType");
        criteria.setQueryType(queryType);
        AggregateStatistics stats = this.statistics.getDefaultEmptyAggregateStatistics();
        try {
            this.statistics.forceFlush();
            stats = this.statistics.queryStatistics(criteria);
        }
        catch (InvalidCriteriaException e) {
            this.logger.warn((Object)"unable to complete a statistics query ", (Throwable)e);
        }
        session.setAttribute(SESSION_CRITERIA, (Object)criteria);
        session.setAttribute(SESSION_RESULTS, (Object)stats);
    }
}

