/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.site;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.decoration.DecorationFactory;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.headerresource.HeaderResource;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.request.RequestContext;
import org.apache.portals.gems.dojo.AbstractDojoVelocityPortlet;

/*
 * Exception performing whole class analysis ignored.
 */
public class PortalSiteManager
extends AbstractDojoVelocityPortlet {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected PageManager pageManager;
    protected PortletRegistry registry;
    protected DecorationFactory decorationFactory;
    protected static final String SESSION_FOLDERS = "jetspeed.site.manager.folders";
    protected static final String SESSION_ROOT = "jetspeed.site.manager.root";
    public static final String FOLDERS = "folders";
    public static final String JSROOT = "jsroot";
    public static final String ALL_SECURITY_REFS = "allSecurityRefs";
    protected PageManager castorPageManager;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.pageManager = (PageManager)this.getPortletContext().getAttribute("cps:PageManager");
        if (null == this.pageManager) {
            PortletException pe = new PortletException("Failed to find the Page Manager on SiteViewController initialization");
            throw new RuntimeException(pe);
        }
        this.registry = (PortletRegistry)this.getPortletContext().getAttribute("cps:PortletRegistryComponent");
        if (null == this.registry) {
            PortletException pe = new PortletException("Failed to find the Portlet Registry on SiteViewController initialization");
            throw new RuntimeException(pe);
        }
        this.decorationFactory = (DecorationFactory)this.getPortletContext().getAttribute("cps:DecorationFactory");
        if (null == this.decorationFactory) {
            PortletException pe = new PortletException("Failed to find the Decoration Factory on SiteViewController initialization");
            throw new RuntimeException(pe);
        }
        this.castorPageManager = (PageManager)this.getPortletContext().getAttribute("cps:ImporterManager");
        if (null == this.castorPageManager) {
            PortletException pe = new PortletException("Failed to find the castorPageManager on SiteViewController initialization");
            throw new RuntimeException(pe);
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            String jsroot = this.determineRootFolder(request);
            RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
            this.getContext(request).put("page-decorations", (Object)this.decorationFactory.getPageDecorations(requestContext));
            this.getContext(request).put("portlet-decorations", (Object)this.decorationFactory.getPortletDecorations(requestContext));
            this.getContext(request).put("themes", (Object)this.decorationFactory.getDesktopPageDecorations(requestContext));
            this.getContext(request).put("treeName", (Object)"portal");
            this.getContext(request).put("userTree", (Object)this.determineuserTree(request));
            this.getContext(request).put("defaultLayout", (Object)request.getPreferences().getValue("defaultLayout", "jetspeed-layouts::VelocityTwoColumns"));
            this.getContext(request).put("folders", (Object)this.retrieveFolders(request, jsroot));
            this.getContext(request).put("allSecurityRefs", (Object)this.pageManager.getPageSecurity().getSecurityConstraintsDefs());
            if (request.getPortletSession().getAttribute("status") == null) {
                request.getPortletSession().setAttribute("status", (Object)"");
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to get root folder", (Throwable)e);
            throw new PortletException("Failed to get root folder");
        }
        super.doView(request, response);
        request.getPortletSession().removeAttribute("status");
    }

    protected String determineRootFolder(RenderRequest request) {
        String jsroot = request.getParameter("jsroot");
        if (jsroot == null || jsroot.equals("")) {
            jsroot = request.getPreferences().getValue("root", "/_user/" + request.getRemoteUser() + "/");
        }
        this.getContext(request).put("jsroot", (Object)jsroot);
        return jsroot;
    }

    protected String determineuserTree(RenderRequest request) {
        String userTree = request.getPreferences().getValue("displayUserTree", "false");
        return userTree;
    }

    public Folder retrieveFolders(RenderRequest request, String root) throws PortletException {
        try {
            Folder folder = this.pageManager.getFolder(root);
            return folder;
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to retrieve folders ", (Throwable)e);
            throw new PortletException("Failed to get root folder");
        }
    }

    protected void includeHeaderContent(HeaderResource headerResource) {
        headerResource.dojoAddCoreLibraryRequire("dojo.lang.*");
        headerResource.dojoAddCoreLibraryRequire("dojo.dnd.HtmlDragManager");
        headerResource.dojoAddCoreLibraryRequire("dojo.dnd.DragAndDrop");
        headerResource.dojoAddCoreLibraryRequire("dojo.dnd.HtmlDragAndDrop");
        headerResource.dojoAddCoreLibraryRequire("dojo.event.*");
        headerResource.dojoAddCoreLibraryRequire("dojo.io");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.ContentPane");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.LayoutContainer");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.Tree");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.TreeRPCController");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.TreeSelector");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.TreeNode");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.TreeContextMenu");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.ValidationTextbox");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.ComboBox");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.Checkbox");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.Dialog");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.Button");
        headerResource.dojoAddModuleLibraryRequire("jetspeed.site");
        headerResource.dojoAddModuleLibraryRequire("jetspeed.widget.EditorTable");
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        this.doPreferencesEdit(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        String add = request.getParameter("Save");
        String fileName = "";
        String destPath = "";
        String fileType = "";
        String path = "";
        String usrFolder = "";
        boolean success = false;
        if (add != null) {
            this.processPreferencesAction(request, actionResponse);
        } else {
            this.cleanUserFolder(((Object)request.getUserPrincipal()).toString());
            try {
                DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
                PortletFileUpload portletFileUpload = new PortletFileUpload((FileItemFactory)diskFileItemFactory);
                if (PortletFileUpload.isMultipartContent((ActionRequest)request)) {
                    Iterator fileIt = portletFileUpload.parseRequest(request).iterator();
                    while (fileIt.hasNext()) {
                        FileItem fileItem = (FileItem)fileIt.next();
                        if (fileItem.getFieldName().equals("psmlFile")) {
                            PortalSiteManager portalSiteManager = this;
                            synchronized (portalSiteManager) {
                                fileName = fileItem.getName();
                                int lastPathSeparatorIndex = Math.max(fileName.lastIndexOf(47), fileName.lastIndexOf(92));
                                if (lastPathSeparatorIndex != -1) {
                                    fileName = fileName.substring(lastPathSeparatorIndex + 1);
                                }
                                usrFolder = this.getTempFolder(request);
                                path = System.getProperty("file.separator");
                                String filePath = usrFolder + path + fileName;
                                fileItem.write(new File(filePath));
                                continue;
                            }
                        }
                        if (!fileItem.isFormField() || !fileItem.getFieldName().equalsIgnoreCase("importPath")) continue;
                        destPath = fileItem.getString();
                    }
                    fileType = this.fileExt(fileName);
                    if (!(fileType == null || fileType.equals("") || fileName == null || fileName.equals("") || destPath == null || destPath.equals(""))) {
                        Page source;
                        Folder folder = this.castorPageManager.getFolder(((Object)request.getUserPrincipal()).toString());
                        if (fileType.equalsIgnoreCase("psml")) {
                            source = folder.getPage(fileName);
                            Page page = this.pageManager.copyPage(source, destPath + "/" + fileName);
                            this.pageManager.updatePage(page);
                            success = true;
                        } else if (fileType.equalsIgnoreCase("link")) {
                            source = folder.getLink(fileName);
                            Link page = this.pageManager.copyLink((Link)source, destPath + "/" + fileName);
                            this.pageManager.updateLink(page);
                            success = true;
                        } else if (fileType.equalsIgnoreCase("zip")) {
                            this.unzipfile(fileName, usrFolder + path, path);
                            folder = this.castorPageManager.getFolder(((Object)request.getUserPrincipal()).toString());
                            this.importFolders(folder, ((Object)request.getUserPrincipal()).toString(), destPath);
                            success = true;
                        }
                    }
                }
                if (success) {
                    request.getPortletSession().setAttribute("status", (Object)fileName);
                } else {
                    request.getPortletSession().setAttribute("status", (Object)"false");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                request.getPortletSession().setAttribute("status", (Object)"false");
            }
        }
    }

    private String fileExt(String fileName) {
        int extIndex = fileName.lastIndexOf(".");
        if (extIndex > 0) {
            return fileName.substring(extIndex + 1, fileName.length());
        }
        return "";
    }

    private String getTempFolder(ActionRequest request) {
        String dir = System.getProperty("java.io.tmpdir");
        String path = System.getProperty("file.separator");
        File file = new File(dir + path + request.getUserPrincipal());
        file.mkdir();
        return dir + path + request.getUserPrincipal();
    }

    private static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    private boolean unzipfile(String file, String destination, String sepreator) {
        String filePath = "";
        try {
            ZipFile zipFile = new ZipFile(destination + sepreator + file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                filePath = destination + sepreator + entry.getName();
                this.createPath(filePath);
                PortalSiteManager.copyInputStream((InputStream)zipFile.getInputStream(entry), (OutputStream)new BufferedOutputStream(new FileOutputStream(filePath)));
            }
            zipFile.close();
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    private void createPath(String filePath) {
        String parentPath = "";
        File file = new File(filePath);
        File parent = new File(file.getParent());
        if (!parent.exists()) {
            parentPath = parent.getPath();
            this.createPath(parentPath);
            parent.mkdir();
        }
    }

    private Folder importFolders(Folder srcFolder, String userName, String destination) throws JetspeedException {
        Folder dstFolder = this.lookupFolder(srcFolder.getPath());
        dstFolder = this.pageManager.copyFolder(srcFolder, destination);
        this.pageManager.updateFolder(dstFolder);
        String newPath = "";
        Iterator pages = srcFolder.getPages().iterator();
        while (pages.hasNext()) {
            Page srcPage = (Page)pages.next();
            Page dstPage = this.lookupPage(srcPage.getPath());
            newPath = destination + this.getRealPath(srcPage.getPath());
            dstPage = this.pageManager.copyPage(srcPage, newPath);
            this.pageManager.updatePage(dstPage);
        }
        Iterator links = srcFolder.getLinks().iterator();
        while (links.hasNext()) {
            Link srcLink = (Link)links.next();
            Link dstLink = this.lookupLink(srcLink.getPath());
            newPath = destination + this.getRealPath(srcLink.getPath());
            dstLink = this.pageManager.copyLink(srcLink, newPath);
            this.pageManager.updateLink(dstLink);
        }
        Iterator folders = srcFolder.getFolders().iterator();
        while (folders.hasNext()) {
            Folder folder = (Folder)folders.next();
            newPath = destination + this.getRealPath(folder.getPath());
            this.importFolders(folder, userName, newPath);
        }
        return dstFolder;
    }

    private Page lookupPage(String path) {
        try {
            return this.castorPageManager.getPage(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Link lookupLink(String path) {
        try {
            return this.castorPageManager.getLink(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Folder lookupFolder(String path) {
        try {
            return this.castorPageManager.getFolder(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getRealPath(String path) {
        int index = path.lastIndexOf("/");
        if (index > 0) {
            return path.substring(index);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanUserFolder(String userName) {
        boolean success = false;
        PortalSiteManager portalSiteManager = this;
        synchronized (portalSiteManager) {
            String tmpdir = System.getProperty("java.io.tmpdir");
            String path = System.getProperty("file.separator");
            String folder = tmpdir + path + userName;
            File dir = new File(folder);
            if (dir.exists()) {
                success = this.deleteDir(dir);
            }
            success = dir.mkdir();
        }
        return success;
    }

    private boolean deleteDir(File dir) {
        if (dir.exists()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDir(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return dir.delete();
    }
}

