/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.selector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.jetspeed.portlets.PortletInfo;
import org.apache.jetspeed.portlets.selector.PortletIterator;
import org.apache.jetspeed.search.ParsedObject;
import org.apache.jetspeed.search.SearchEngine;
import org.apache.jetspeed.security.SecurityAccessController;
import org.apache.portals.gems.browser.BrowserIterator;
import org.apache.portals.gems.browser.BrowserPortlet;
import org.apache.portals.gems.util.StatusMessage;
import org.apache.portals.messaging.PortletMessaging;

public class PortletSelector
extends BrowserPortlet {
    protected static final String CHECKEDSET = "checkedSet";
    protected static final String UNCHECKEDSET = "unCheckedSet";
    protected SecurityAccessController securityAccessController;
    protected PortletRegistry registry;
    protected SearchEngine searchEngine;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.context = this.getPortletContext();
        this.registry = (PortletRegistry)this.context.getAttribute("cps:PortletRegistryComponent");
        if (null == this.registry) {
            throw new PortletException("Failed to find the Portlet Registry on portlet initialization");
        }
        this.searchEngine = (SearchEngine)this.context.getAttribute("cps:SearchComponent");
        if (null == this.searchEngine) {
            throw new PortletException("Failed to find the Search Engine on portlet initialization");
        }
        this.securityAccessController = (SecurityAccessController)this.context.getAttribute("cps:SecurityAccessController");
        if (null == this.securityAccessController) {
            throw new PortletException("Failed to find the Security Access Controller on portlet initialization");
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        HashSet selectedCheckBoxes;
        String searchString;
        String filtered;
        StatusMessage msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"portlet.selector", (String)"status");
        if (msg != null) {
            this.getContext(request).put("statusMsg", (Object)msg);
        }
        if ((filtered = (String)PortletMessaging.receive((PortletRequest)request, (String)"portlet.selector", (String)"filtered")) != null) {
            this.getContext(request).put("filtered", (Object)"on");
        }
        if ((searchString = (String)PortletMessaging.receive((PortletRequest)request, (String)"portlet.selector", (String)"searchString")) != null) {
            this.getContext(request).put("searchString", (Object)searchString);
        }
        if ((selectedCheckBoxes = (HashSet)PortletMessaging.receive((PortletRequest)request, (String)"portlet.selector", (String)"selected")) == null) {
            selectedCheckBoxes = new HashSet();
        }
        this.getContext(request).put("selectedPortlets", selectedCheckBoxes);
        String selectedPortletsString = this.getAsString(selectedCheckBoxes);
        this.getContext(request).put("selectedPortletsString", (Object)selectedPortletsString);
        super.doView(request, response);
    }

    private String getAsString(Set s) {
        StringBuffer sb = new StringBuffer();
        if (s != null) {
            Iterator it = s.iterator();
            while (it.hasNext()) {
                String portletName = (String)it.next();
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("box_" + portletName);
            }
        }
        return sb.toString();
    }

    private Set getCheckBoxSet(ActionRequest request) {
        HashSet<String> s = new HashSet<String>();
        String checkBoxesString = request.getParameter(CHECKEDSET);
        StringTokenizer st = new StringTokenizer(checkBoxesString, ",");
        while (st.hasMoreTokens()) {
            String checkBox = st.nextToken();
            if (checkBox.startsWith("box_")) {
                String portletName = checkBox.substring(4);
                s.add(portletName);
                continue;
            }
            s.add(checkBox);
        }
        String unCheckBoxesString = request.getParameter(UNCHECKEDSET);
        StringTokenizer st2 = new StringTokenizer(unCheckBoxesString, ",");
        HashSet<String> uns = new HashSet<String>();
        while (st2.hasMoreTokens()) {
            String checkBox = st2.nextToken();
            if (checkBox.startsWith("box_")) {
                String portletName = checkBox.substring(4);
                uns.add(portletName);
                continue;
            }
            uns.add(checkBox);
        }
        s.removeAll(uns);
        return s;
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String filtered = request.getParameter("filtered");
        Set checkBoxes = this.getCheckBoxSet(request);
        PortletMessaging.publish((PortletRequest)request, (String)"portlet.selector", (String)"selected", (Object)checkBoxes);
        String searchString = request.getParameter("searchString");
        if (searchString != null && searchString.trim().length() > 0) {
            PortletMessaging.publish((PortletRequest)request, (String)"portlet.selector", (String)"searchString", (Object)searchString);
        } else {
            PortletMessaging.cancel((PortletRequest)request, (String)"portlet.selector", (String)"searchString");
        }
        if (filtered != null && filtered.trim().length() > 0) {
            PortletMessaging.publish((PortletRequest)request, (String)"portlet.selector", (String)"filtered", (Object)"on");
        } else {
            PortletMessaging.cancel((PortletRequest)request, (String)"portlet.selector", (String)"filtered");
        }
        super.processAction(request, response);
    }

    public void getRows(RenderRequest request, String sql, int windowSize) throws Exception {
        this.getRows(request, sql, windowSize, null);
    }

    public void getRows(RenderRequest request, String sql, int windowSize, String filter) throws Exception {
        ArrayList<String> resultSetTitleList = new ArrayList<String>();
        ArrayList<String> resultSetTypeList = new ArrayList<String>();
        try {
            Iterator portlets = null;
            portlets = filter == null ? this.registry.getAllPortletDefinitions().iterator() : this.searchEngine.search(filter).getResults().iterator();
            resultSetTypeList.add(String.valueOf(12));
            resultSetTitleList.add("Portlet");
            resultSetTitleList.add("Description");
            Locale locale = request.getLocale();
            ArrayList<PortletInfo> list = new ArrayList<PortletInfo>();
            while (portlets.hasNext()) {
                MutablePortletApplication pa;
                PortletDefinitionComposite portlet = null;
                portlet = filter == null ? (PortletDefinitionComposite)portlets.next() : this.getPortletFromParsedObject((ParsedObject)portlets.next());
                if (portlet == null || (pa = (MutablePortletApplication)portlet.getPortletApplicationDefinition()).isLayoutApplication()) continue;
                String uniqueName = pa.getName() + "::" + portlet.getName();
                if (!this.securityAccessController.checkPortletAccess(portlet, 8)) continue;
                String name = portlet.getDisplayNameText(locale);
                if (name == null) {
                    name = portlet.getName();
                }
                list.add(new PortletInfo(uniqueName, name, portlet.getDescriptionText(locale)));
            }
            PortletIterator iterator = new PortletIterator(list, resultSetTitleList, resultSetTypeList, windowSize);
            this.setBrowserIterator(request, (BrowserIterator)iterator);
            iterator.sort("Portlet");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public int find(BrowserIterator iterator, String searchString, String searchColumn) {
        int index = 0;
        Iterator it = iterator.getResultSet().iterator();
        while (it.hasNext()) {
            PortletInfo info = (PortletInfo)it.next();
            String name = info.getDisplayName();
            if (name != null && name.startsWith(searchString)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected PortletDefinitionComposite getPortletFromParsedObject(ParsedObject po) {
        boolean found = false;
        String name = "";
        Map fields = po.getFields();
        if (fields != null) {
            Object id = fields.get("ID");
            if (id != null) {
                if (id instanceof Collection) {
                    Collection coll = (Collection)id;
                    name = (String)coll.iterator().next();
                } else {
                    name = (String)id;
                }
            }
            if (po.getType().equals("portlet")) {
                Object pa = fields.get("portlet_application");
                String paName = "";
                if (pa != null) {
                    if (id instanceof Collection) {
                        Collection coll = (Collection)pa;
                        paName = (String)coll.iterator().next();
                    } else {
                        paName = (String)pa;
                    }
                }
                name = paName + "::" + name;
                found = true;
            }
        }
        if (!found) {
            return null;
        }
        return this.registry.getPortletDefinitionByUniqueName(name);
    }
}

