/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.selector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.headerresource.HeaderResource;
import org.apache.jetspeed.om.common.LocalizedField;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.jetspeed.om.common.preference.PreferenceComposite;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.portlets.CategoryInfo;
import org.apache.jetspeed.portlets.PortletInfo;
import org.apache.jetspeed.portlets.selector.CategoryPortletSelector;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.search.ParsedObject;
import org.apache.jetspeed.search.SearchEngine;
import org.apache.jetspeed.security.SecurityAccessController;
import org.apache.pluto.om.common.Parameter;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.portals.gems.dojo.AbstractDojoVelocityPortlet;
import org.apache.velocity.context.Context;

public class CategoryPortletSelector
extends AbstractDojoVelocityPortlet
implements Comparator {
    public final String[] DEFAULT_IMAGES = new String[]{"images/portlets/applications-development.png", "images/portlets/applications-system.png", "images/portlets/applications-other.png", "images/portlets/linux.png"};
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final String PORTLET_ICON = "portlet-icon";
    protected static final String PORTLETS = "category.selector.portlets";
    protected static final String CATEGORIES = "category.selector.categories";
    protected static final String PAGE = "category.selector.page";
    protected static final String LAYOUT = "category.selector.layout";
    private final String JSPAGE = "jspage";
    private final String JSLAYOUT = "jslayoutid";
    private final String CATEGORY = "category";
    private final String PAGENUMNER = "pageNumber";
    private final String FILTER = "filter";
    protected PortletRegistry registry;
    protected SearchEngine searchEngine;
    protected PageManager pageManager;
    protected Profiler profiler;
    protected SecurityAccessController securityAccessController;
    protected Random rand;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext context = this.getPortletContext();
        this.registry = (PortletRegistry)context.getAttribute("cps:PortletRegistryComponent");
        if (null == this.registry) {
            throw new PortletException("Failed to find the Portlet Registry on portlet initialization");
        }
        this.searchEngine = (SearchEngine)context.getAttribute("cps:SearchComponent");
        if (null == this.searchEngine) {
            throw new PortletException("Failed to find the Search Engine on portlet initialization");
        }
        this.pageManager = (PageManager)context.getAttribute("cps:PageManager");
        if (null == this.pageManager) {
            throw new PortletException("Failed to find the Page Manager on portlet initialization");
        }
        this.securityAccessController = (SecurityAccessController)context.getAttribute("cps:SecurityAccessController");
        if (null == this.securityAccessController) {
            throw new PortletException("Failed to find the Security Access Controller on portlet initialization");
        }
        this.profiler = (Profiler)context.getAttribute("cps:Profiler");
        if (null == this.profiler) {
            throw new PortletException("Failed to find the Profiler on portlet initialization");
        }
        this.rand = new Random(19580427L);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String category = "All";
        String pageNumber = "";
        String row = "";
        String columns = "";
        int portletPerPages = 0;
        PortletPreferences prefs = request.getPreferences();
        category = request.getParameter("category");
        pageNumber = request.getParameter("pageNumber");
        String filter = request.getParameter("filter");
        columns = prefs.getValue("Columns", "4");
        row = prefs.getValue("Rows", "6");
        portletPerPages = Integer.parseInt(columns) * Integer.parseInt(row);
        if (category == null || category.equals("")) {
            category = "All";
        }
        if (pageNumber == null || pageNumber.equals("")) {
            pageNumber = "1";
        }
        if (filter == null || filter.equals("")) {
            filter = null;
        }
        CategoryResult result = this.getPortlets(request, category, pageNumber, portletPerPages, filter);
        this.getContext(request).put("Columns", (Object)columns);
        this.getContext(request).put("Rows", (Object)row);
        this.getContext(request).put("pageNumber", (Object)pageNumber);
        this.getContext(request).put("category", (Object)category);
        this.getContext(request).put("portlets", (Object)this.mergePortletCount(result.getList(), request));
        this.getContext(request).put("Count", (Object)new Integer(result.getResultSize()));
        this.getContext(request).put("categories", (Object)this.retrieveCategories(request));
        this.processPage(request);
        super.doView(request, response);
    }

    protected Page getPage(RenderRequest request) throws Exception {
        String path = request.getParameter("jspage");
        RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        return requestContext.locatePage(this.profiler, path);
    }

    protected void processPage(RenderRequest request) {
        String page = request.getParameter("jspage");
        if (page == null || page.equals("")) {
            page = (String)request.getPortletSession().getAttribute(PAGE);
        } else {
            request.getPortletSession().setAttribute(PAGE, (Object)page);
        }
        String layout = request.getParameter("jslayoutid");
        this.getContext(request).put("jspage", (Object)page);
        if (layout == null || layout.equals("")) {
            layout = (String)request.getPortletSession().getAttribute(LAYOUT);
        } else {
            request.getPortletSession().setAttribute(LAYOUT, (Object)layout);
        }
        this.getContext(request).put("jslayoutid", (Object)layout);
    }

    public List retrieveCategories(RenderRequest request) throws PortletException {
        ArrayList<CategoryInfo> categories = (ArrayList<CategoryInfo>)request.getPortletSession().getAttribute(CATEGORIES);
        if (categories != null) {
            return categories;
        }
        Locale locale = request.getLocale();
        categories = new ArrayList<CategoryInfo>();
        PortletPreferences prefs = request.getPreferences();
        String cats = prefs.getValue("Categories", null);
        if (cats == null) {
            throw new PortletException("No categories defined, please add categories via edit mode.");
        }
        StringTokenizer catTokenizer = new StringTokenizer(cats, ",");
        while (catTokenizer.hasMoreTokens()) {
            String name = catTokenizer.nextToken().trim();
            CategoryInfo cat = new CategoryInfo(name);
            String keywords = prefs.getValue("Keywords:" + name, null);
            if (keywords == null) continue;
            StringTokenizer keyTokenizer = new StringTokenizer(keywords, ",");
            StringBuffer searchString = new StringBuffer();
            int count = 0;
            while (keyTokenizer.hasMoreTokens()) {
                String keyword = keyTokenizer.nextToken().trim();
                if (count > 0) {
                    searchString.append(" | ");
                }
                searchString.append(keyword);
                ++count;
            }
            if (count <= 0) continue;
            Iterator portlets = this.searchEngine.search(searchString.toString()).getResults().iterator();
            while (portlets.hasNext()) {
                PortletDefinitionComposite portlet = this.getPortletFromParsedObject((ParsedObject)portlets.next());
                PortletInfo portletInfo = this.filterPortlet(portlet, locale, request);
                if (portletInfo == null) continue;
                cat.addPortlet(portletInfo);
            }
            Collections.sort(cat.getPortlets(), this);
            categories.add(cat);
        }
        request.getPortletSession().setAttribute(CATEGORIES, categories);
        return categories;
    }

    public List retrievePortlets(RenderRequest request, String filter) {
        List portletsList = (List)request.getPortletSession().getAttribute(PORTLETS);
        if (filter == null && portletsList != null) {
            return portletsList;
        }
        Iterator portlets = null;
        ArrayList<PortletInfo> list = new ArrayList<PortletInfo>();
        Locale locale = request.getLocale();
        portlets = filter == null ? this.registry.getAllPortletDefinitions().iterator() : this.searchEngine.search(filter).getResults().iterator();
        while (portlets.hasNext()) {
            PortletDefinitionComposite portlet = null;
            portlet = filter == null ? (PortletDefinitionComposite)portlets.next() : this.getPortletFromParsedObject((ParsedObject)portlets.next());
            PortletInfo portletInfo = this.filterPortlet(portlet, locale, request);
            if (portletInfo == null) continue;
            list.add(portletInfo);
        }
        Collections.sort(list, this);
        if (filter == null) {
            request.getPortletSession().setAttribute(PORTLETS, list);
        }
        return list;
    }

    private List mergePortletCount(List sysPortlets, RenderRequest request) {
        ArrayList<PortletInfo> list = new ArrayList<PortletInfo>();
        int sPortletCnt = 0;
        String usrPortletName = null;
        PortletInfo tmpPortletInfo = null;
        try {
            Map usrPortlet = this.getUserPortlet(this.getPage(request));
            sPortletCnt = sysPortlets.size();
            for (int si = 0; si < sPortletCnt; ++si) {
                tmpPortletInfo = (PortletInfo)((PortletInfo)sysPortlets.get(si)).clone();
                String portletName = tmpPortletInfo.getName();
                Iterator iterator = usrPortlet.keySet().iterator();
                while (iterator.hasNext()) {
                    usrPortletName = (String)iterator.next();
                    if (!usrPortletName.equalsIgnoreCase(portletName)) continue;
                    tmpPortletInfo.setCount(((Integer)usrPortlet.get(usrPortletName)).intValue());
                }
                list.add(tmpPortletInfo);
                tmpPortletInfo = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    protected boolean filterByRole(PortletDefinitionComposite portlet, RenderRequest request) {
        LocalizedField roleField;
        String role;
        Iterator it;
        boolean doFilter = false;
        Collection c = portlet.getMetadata().getFields("selector.conditional.role");
        if (c != null && (it = c.iterator()).hasNext() && (role = (roleField = (LocalizedField)it.next()).getValue()) != null) {
            if (role.equals("*")) {
                doFilter = true;
            } else {
                return !request.isUserInRole(role);
            }
        }
        return doFilter;
    }

    protected PortletInfo filterPortlet(PortletDefinitionComposite portlet, Locale locale, RenderRequest request) {
        if (portlet == null) {
            return null;
        }
        if (this.filterByRole(portlet, request)) {
            return null;
        }
        MutablePortletApplication pa = (MutablePortletApplication)portlet.getPortletApplicationDefinition();
        if (pa.isLayoutApplication()) {
            return null;
        }
        String uniqueName = pa.getName() + "::" + portlet.getName();
        if (this.securityAccessController.checkPortletAccess(portlet, 8)) {
            String imagePath;
            Parameter param = portlet.getInitParameterSet().get(PORTLET_ICON);
            String image = param != null ? ((imagePath = param.getValue()) == null ? this.DEFAULT_IMAGES[this.rand.nextInt(this.DEFAULT_IMAGES.length)] : (-1 == imagePath.indexOf("/") ? "images/portlets/" + param.getValue() : param.getValue())) : this.DEFAULT_IMAGES[this.rand.nextInt(this.DEFAULT_IMAGES.length)];
            return new PortletInfo(uniqueName, this.cleanup(portlet.getDisplayNameText(locale)), this.cleanup(portlet.getDescriptionText(locale)), image);
        }
        return null;
    }

    protected String cleanup(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("\r|\n|\"|'", "");
    }

    protected PortletDefinitionComposite getPortletFromParsedObject(ParsedObject po) {
        boolean found = false;
        String name = "";
        Map fields = po.getFields();
        if (fields != null) {
            Object id = fields.get("ID");
            if (id != null) {
                if (id instanceof Collection) {
                    Collection coll = (Collection)id;
                    name = (String)coll.iterator().next();
                } else {
                    name = (String)id;
                }
            }
            if (po.getType().equals("portlet")) {
                Object pa = fields.get("portlet_application");
                String paName = "";
                if (pa != null) {
                    if (id instanceof Collection) {
                        Collection coll = (Collection)pa;
                        paName = (String)coll.iterator().next();
                    } else {
                        paName = (String)pa;
                    }
                }
                name = paName + "::" + name;
                found = true;
            }
        }
        if (!found) {
            return null;
        }
        return this.registry.getPortletDefinitionByUniqueName(name);
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        if (request.getPortletMode() == PortletMode.EDIT) {
            String keys;
            String name;
            StringTokenizer tokenizer;
            StringTokenizer keyTokenizer;
            String removes = request.getParameter("jsRemovedCats");
            String modifiedCats = request.getParameter("jsModifiedCats");
            String modifiedKeys = request.getParameter("jsModifiedKeys");
            String addedCats = request.getParameter("jsAddedCats");
            String addedKeys = request.getParameter("jsAddedKeys");
            String columns = request.getParameter("Columns");
            String rows = request.getParameter("Rows");
            String cats = request.getParameter("jsCats");
            String page = request.getParameter("jspage");
            MutablePortletApplication pa = this.registry.getPortletApplication("j2-admin");
            String portletName = this.getPortletName();
            PortletDefinitionComposite portlet = (PortletDefinitionComposite)pa.getPortletDefinitionByName(portletName);
            boolean updated = this.updateNumericPref("Columns", columns, 10, portlet);
            updated |= this.updateNumericPref("Rows", rows, 100, portlet);
            if (!this.isEmpty(removes)) {
                StringTokenizer tokenizer2 = new StringTokenizer(removes, ",");
                while (tokenizer2.hasMoreTokens()) {
                    String name2 = tokenizer2.nextToken().trim();
                    updated |= this.removePref("Keywords:" + name2, portlet);
                }
            }
            if (!this.isEmpty(addedCats)) {
                keyTokenizer = new StringTokenizer(addedKeys, "|");
                tokenizer = new StringTokenizer(addedCats, ",");
                while (tokenizer.hasMoreTokens() && keyTokenizer.hasMoreTokens()) {
                    name = tokenizer.nextToken().trim();
                    keys = keyTokenizer.nextToken().trim();
                    updated |= this.addPref("Keywords:" + name, keys, portlet);
                }
            }
            if (!this.isEmpty(modifiedCats)) {
                keyTokenizer = new StringTokenizer(modifiedKeys, "|");
                tokenizer = new StringTokenizer(modifiedCats, ",");
                while (tokenizer.hasMoreTokens()) {
                    name = tokenizer.nextToken().trim();
                    keys = keyTokenizer.nextToken().trim();
                    updated |= this.modifyPref("Keywords:" + name, keys, portlet);
                }
            }
            try {
                if (updated) {
                    StringTokenizer catTokenizer = new StringTokenizer(cats, ",");
                    ArrayList<String> sorted = new ArrayList<String>();
                    while (catTokenizer.hasMoreTokens()) {
                        name = catTokenizer.nextToken().trim();
                        sorted.add(name);
                    }
                    Collections.sort(sorted);
                    Iterator si = sorted.iterator();
                    StringBuffer temp = new StringBuffer();
                    int count = 0;
                    while (si.hasNext()) {
                        String name3 = (String)si.next();
                        if (count > 0) {
                            temp.append(",");
                        }
                        temp.append(name3);
                        ++count;
                    }
                    cats = temp.toString();
                    this.modifyPref("Categories", cats, portlet);
                    this.registry.savePortletDefinition((PortletDefinition)portlet);
                }
            }
            catch (Exception e) {
                throw new PortletException("Failed to update portlet", (Throwable)e);
            }
            PortletSession session = request.getPortletSession();
            session.removeAttribute(PORTLETS);
            session.removeAttribute(CATEGORIES);
            actionResponse.setPortletMode(PortletMode.VIEW);
            actionResponse.setRenderParameter("jspage", page);
        } else {
            String pagePath;
            String filter;
            String pageNumber;
            String category;
            String reset = request.getParameter("reset");
            if (reset != null && reset.equals("true")) {
                PortletSession session = request.getPortletSession();
                session.removeAttribute(PORTLETS);
                session.removeAttribute(CATEGORIES);
            }
            if ((category = request.getParameter("category")) != null) {
                actionResponse.setRenderParameter("category", category);
            }
            if ((pageNumber = request.getParameter("pageNumber")) != null) {
                actionResponse.setRenderParameter("pageNumber", pageNumber);
            }
            if ((filter = request.getParameter("filter")) != null) {
                actionResponse.setRenderParameter("filter", filter);
            }
            if ((pagePath = request.getParameter("jspage")) != null) {
                actionResponse.setRenderParameter("jspage", pagePath);
            }
        }
    }

    private boolean addPref(String prefName, String keywords, PortletDefinitionComposite portlet) {
        PreferenceComposite pref = (PreferenceComposite)portlet.getPreferenceSet().get(prefName);
        if (pref != null) {
            return this.modifyPref(prefName, keywords, portlet);
        }
        portlet.addPreference(prefName, new String[]{keywords});
        return true;
    }

    private boolean modifyPref(String prefName, String keywords, PortletDefinitionComposite portlet) {
        PreferenceComposite prefComp = (PreferenceComposite)portlet.getPreferenceSet().get(prefName);
        String[] values = prefComp.getValueArray();
        if (!values[0].equals(keywords)) {
            prefComp.setValueAt(0, keywords);
            return true;
        }
        return false;
    }

    private boolean removePref(String prefName, PortletDefinitionComposite portlet) {
        Iterator prefIter = portlet.getPreferenceSet().iterator();
        while (prefIter.hasNext()) {
            PreferenceComposite pref = (PreferenceComposite)prefIter.next();
            String name = pref.getName();
            if (!name.equals(prefName)) continue;
            prefIter.remove();
            return true;
        }
        return false;
    }

    private boolean updateNumericPref(String prefName, String param, int max, PortletDefinitionComposite portlet) {
        if (!this.isEmpty(param)) {
            int val = 4;
            try {
                val = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (val > max) {
                return false;
            }
            PreferenceComposite pref = (PreferenceComposite)portlet.getPreferenceSet().get(prefName);
            String[] values = pref.getValueArray();
            if (!values[0].equals(param)) {
                pref.setValueAt(0, param);
                return true;
            }
        }
        return false;
    }

    private boolean isEmpty(String param) {
        if (param == null) {
            return true;
        }
        return (param = param.trim()).length() == 0;
    }

    public int compare(Object obj1, Object obj2) {
        PortletInfo portlet1 = (PortletInfo)obj1;
        PortletInfo portlet2 = (PortletInfo)obj2;
        String name1 = portlet1.getDisplayName();
        String name2 = portlet2.getDisplayName();
        name1 = name1 == null ? "unknown" : name1;
        name2 = name2 == null ? "unknown" : name2;
        return name1.compareTo(name2);
    }

    protected void includeHeaderContent(HeaderResource headerResource) {
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.Dialog");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.Button");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.ContentPane");
        headerResource.dojoAddCoreLibraryRequire("dojo.widget.LayoutContainer");
        headerResource.dojoAddModuleLibraryRequire("jetspeed.selector");
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        Context context = this.getContext(request);
        PortletPreferences prefs = request.getPreferences();
        String cats = prefs.getValue("Categories", null);
        ArrayList<CategoryInfo> categories = new ArrayList<CategoryInfo>();
        if (cats != null) {
            StringTokenizer catTokenizer = new StringTokenizer(cats, ",");
            while (catTokenizer.hasMoreTokens()) {
                String name = catTokenizer.nextToken().trim();
                CategoryInfo cat = new CategoryInfo(name);
                String keys = prefs.getValue("Keywords:" + name, "");
                cat.setKeywords(keys);
                categories.add(cat);
            }
        }
        context.put("categories", categories);
        context.put("Rows", (Object)prefs.getValue("Rows", "5"));
        context.put("Columns", (Object)prefs.getValue("Columns", "4"));
        this.processPage(request);
        super.doEdit(request, response);
    }

    private CategoryResult getPortlets(RenderRequest request, String category, String pageNumber, int portletPerPages, String filter) {
        ArrayList list = new ArrayList();
        List tmpList = null;
        List catList = null;
        Iterator iterator = null;
        int portletCount = 0;
        CategoryInfo catInfo = null;
        int strtCnt = this.getStartRow(pageNumber, portletPerPages);
        int endCnt = this.getEndRow(pageNumber, portletPerPages);
        try {
            if (category.equalsIgnoreCase("all")) {
                tmpList = this.retrievePortlets(request, filter);
                portletCount = tmpList.size();
                if (endCnt > portletCount) {
                    endCnt = portletCount;
                }
                for (int index = strtCnt; index < endCnt; ++index) {
                    list.add(tmpList.get(index));
                }
            } else if (category.equalsIgnoreCase("search")) {
                tmpList = this.retrievePortlets(request, filter);
                portletCount = tmpList.size();
                if (endCnt > portletCount) {
                    endCnt = portletCount;
                }
                for (int index = strtCnt; index < endCnt; ++index) {
                    list.add(tmpList.get(index));
                }
            } else {
                tmpList = this.retrieveCategories(request);
                iterator = tmpList.iterator();
                while (iterator.hasNext()) {
                    catInfo = (CategoryInfo)iterator.next();
                    if (!catInfo.getName().equalsIgnoreCase(category)) continue;
                    catList = catInfo.getPortlets();
                    break;
                }
                if (endCnt > (portletCount = catList.size())) {
                    endCnt = portletCount;
                }
                for (int index = strtCnt; index < endCnt; ++index) {
                    list.add(catList.get(index));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new CategoryResult(this, list, portletCount);
    }

    private int getStartRow(String sPageNumber, int portletPerPages) {
        int iPageNumber = Integer.parseInt(sPageNumber);
        return (iPageNumber - 1) * portletPerPages;
    }

    private int getEndRow(String sPageNumber, int portletPerPages) {
        int iPageNumber = Integer.parseInt(sPageNumber);
        return iPageNumber * portletPerPages;
    }

    private Map getUserPortlet(Page page) {
        int portletCount = 0;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            Iterator it = page.getRootFragment().getFragments().iterator();
            while (it.hasNext()) {
                Fragment fragment = (Fragment)it.next();
                if (map.containsKey(fragment.getName())) {
                    portletCount = (Integer)map.get(fragment.getName());
                    map.put(fragment.getName(), new Integer(portletCount + 1));
                    continue;
                }
                map.put(fragment.getName(), new Integer(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }
}

