/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.users;

import java.io.IOException;
import java.security.Principal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.security.auth.Subject;
import org.apache.jetspeed.administration.PortalConfiguration;
import org.apache.jetspeed.audit.AuditActivity;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.container.JetspeedPortletContext;
import org.apache.jetspeed.om.common.UserAttribute;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.portlets.security.SecurityUtil;
import org.apache.jetspeed.portlets.security.users.JetspeedUserBean;
import org.apache.jetspeed.portlets.security.users.SubsiteInfo;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.rules.PrincipalRule;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.Group;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.InvalidNewPasswordException;
import org.apache.jetspeed.security.InvalidPasswordException;
import org.apache.jetspeed.security.PasswordAlreadyUsedException;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.om.InternalCredential;
import org.apache.portals.bridges.beans.TabBean;
import org.apache.portals.bridges.common.GenericServletPortlet;
import org.apache.portals.bridges.util.PreferencesHelper;
import org.apache.portals.messaging.PortletMessaging;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserDetailsPortlet
extends GenericServletPortlet {
    private final String VIEW_USER = "user";
    private final String VIEW_ROLES = "roles";
    private final String VIEW_GROUPS = "groups";
    private final String VIEW_RULES = "rules";
    private final String VIEW_CREDENTIAL = "credential";
    private final String VIEW_ALL_RULES = "prules";
    private final String VIEW_PA_USER_ATTRIBUTES = "paUserAttributes";
    private final String USER_ACTION_PREFIX = "security_user.";
    private final String ACTION_EDIT_USER = "edit_user";
    private final String ACTION_UPDATE_ATTRIBUTE = "update_user_attribute";
    private final String ACTION_REMOVE_ATTRIBUTE = "remove_user_attribute";
    private final String ACTION_ADD_ATTRIBUTE = "add_user_attribute";
    private final String ACTION_REMOVE_ROLE = "remove_user_role";
    private final String ACTION_ADD_ROLE = "add_user_role";
    private final String ACTION_REMOVE_GROUP = "remove_user_group";
    private final String ACTION_ADD_GROUP = "add_user_group";
    private final String ACTION_REMOVE_RULE = "remove_user_rule";
    private final String ACTION_ADD_RULE = "add_rule";
    private final String ACTION_UPDATE_CREDENTIAL = "update_user_credential";
    private final String TAB_USER = "user";
    private final String TAB_ATTRIBUTES = "user_attributes";
    private final String TAB_ROLE = "user_role";
    private final String TAB_GROUP = "user_group";
    private final String TAB_PROFILE = "user_profile";
    private final String TAB_CREDENTIAL = "user_credential";
    private static final String ROLES_CONTROL = "jetspeedRoles";
    private static final String RULES_CONTROL = "jetspeedRules";
    private static final String SUBSITES_CONTROL = "jetspeedSubsites";
    private static final String GROUPS_CONTROL = "jetspeedGroups";
    public static final String USER_ADMINISTRATION = "J2 User Administration";
    private PageManager pageManager;
    private UserManager userManager;
    private RoleManager roleManager;
    private GroupManager groupManager;
    private Profiler profiler;
    private PortletRegistry registry;
    private String paIdentifier;
    private Collection paUserAttributes;
    private boolean initPrefsAndAttr;
    private PortalConfiguration configuration;
    private AuditActivity audit;
    private LinkedHashMap userTabMap;
    private LinkedHashMap anonymousUserTabMap;
    static /* synthetic */ Class class$org$apache$jetspeed$security$UserPrincipal;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.userManager = (UserManager)this.getPortletContext().getAttribute("cps:UserManager");
        if (null == this.userManager) {
            throw new PortletException("Failed to find the User Manager on portlet initialization");
        }
        this.roleManager = (RoleManager)this.getPortletContext().getAttribute("cps:RoleManager");
        if (null == this.roleManager) {
            throw new PortletException("Failed to find the Role Manager on portlet initialization");
        }
        this.groupManager = (GroupManager)this.getPortletContext().getAttribute("cps:GroupManager");
        if (null == this.groupManager) {
            throw new PortletException("Failed to find the Group Manager on portlet initialization");
        }
        this.profiler = (Profiler)this.getPortletContext().getAttribute("cps:Profiler");
        if (null == this.profiler) {
            throw new PortletException("Failed to find the Profiler on portlet initialization");
        }
        this.registry = (PortletRegistry)this.getPortletContext().getAttribute("cps:PortletRegistryComponent");
        if (null == this.registry) {
            throw new PortletException("Failed to find the Portlet Registry on portlet initialization");
        }
        this.pageManager = (PageManager)this.getPortletContext().getAttribute("cps:PageManager");
        if (null == this.pageManager) {
            throw new PortletException("Failed to find the Page Manager on portlet initialization");
        }
        this.configuration = (PortalConfiguration)this.getPortletContext().getAttribute("cps:PortalConfiguration");
        if (null == this.configuration) {
            throw new PortletException("Failed to find the Portal Configuration on portlet initialization");
        }
        this.audit = (AuditActivity)this.getPortletContext().getAttribute("cps:AuditActivity");
        if (null == this.audit) {
            throw new PortletException("Failed to find the Audit Activity on portlet initialization");
        }
        this.paIdentifier = ((MutablePortletApplication)((JetspeedPortletContext)config.getPortletContext()).getApplication()).getApplicationIdentifier();
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        if (!this.initPrefsAndAttr) {
            this.initPrefsAndAttr((PortletRequest)request);
        }
        String userName = (String)PortletMessaging.receive((PortletRequest)request, (String)"users", (String)"selected");
        User user = null;
        if (userName != null) {
            user = this.lookupUser((PortletRequest)request, userName);
        }
        if (user != null) {
            LinkedHashMap tabMap = null;
            tabMap = this.userManager.getAnonymousUser().equals(userName) ? this.anonymousUserTabMap : this.userTabMap;
            request.setAttribute("tabs", tabMap.values());
            TabBean selectedTab = (TabBean)request.getPortletSession().getAttribute("selected_tab");
            if (selectedTab != null && !tabMap.containsKey(selectedTab.getId())) {
                selectedTab = null;
            }
            if (selectedTab == null) {
                selectedTab = (TabBean)tabMap.values().iterator().next();
            }
            JetspeedUserBean bean = new JetspeedUserBean(user);
            request.setAttribute("user", (Object)bean);
            if (selectedTab.getId().equals("user")) {
                request.setAttribute("paUserAttributes", (Object)this.paUserAttributes);
                if ("true".equals(request.getPreferences().getValue("showPasswordOnUserTab", "false"))) {
                    request.setAttribute("credential", (Object)this.getCredential((PortletRequest)request, userName));
                }
            } else if (selectedTab.getId().equals("user_role")) {
                Collection userRoles = this.getRoles((PortletRequest)request, userName);
                request.setAttribute("roles", (Object)userRoles);
                String refreshRoles = (String)PortletMessaging.consume((PortletRequest)request, (String)"users", (String)"refresh.roles");
                LinkedList<String> roles = null;
                if (refreshRoles == null) {
                    roles = (LinkedList<String>)request.getPortletSession().getAttribute("jetspeedRoles");
                }
                try {
                    if (roles == null) {
                        roles = new LinkedList<String>();
                        Iterator fullRoles = this.roleManager.getRoles("");
                        while (fullRoles.hasNext()) {
                            Role role = (Role)fullRoles.next();
                            roles.add(role.getPrincipal().getName());
                        }
                        request.getPortletSession().setAttribute("jetspeedRoles", roles);
                    }
                }
                catch (SecurityException se) {
                    throw new PortletException((Throwable)se);
                }
                ArrayList selectableRoles = new ArrayList(roles);
                Iterator rolesIter = userRoles.iterator();
                while (rolesIter.hasNext()) {
                    Role role = (Role)rolesIter.next();
                    int index = selectableRoles.indexOf(role.getPrincipal().getName());
                    if (index == -1) continue;
                    selectableRoles.remove(index);
                }
                request.setAttribute("jetspeedRoles", selectableRoles);
            } else if (selectedTab.getId().equals("user_group")) {
                Collection userGroups = this.getGroups((PortletRequest)request, userName);
                request.setAttribute("groups", (Object)userGroups);
                String refreshGroups = (String)PortletMessaging.consume((PortletRequest)request, (String)"users", (String)"refresh.groups");
                LinkedList<String> groups = null;
                if (refreshGroups == null) {
                    groups = (LinkedList<String>)request.getPortletSession().getAttribute("jetspeedGroups");
                }
                try {
                    if (groups == null) {
                        groups = new LinkedList<String>();
                        Iterator fullGroups = this.groupManager.getGroups("");
                        while (fullGroups.hasNext()) {
                            Group group = (Group)fullGroups.next();
                            groups.add(group.getPrincipal().getName());
                        }
                        request.getPortletSession().setAttribute("jetspeedGroups", groups);
                    }
                }
                catch (SecurityException se) {
                    throw new PortletException((Throwable)se);
                }
                ArrayList selectableGroups = new ArrayList(groups);
                Iterator groupsIter = userGroups.iterator();
                while (groupsIter.hasNext()) {
                    Group group = (Group)groupsIter.next();
                    int index = selectableGroups.indexOf(group.getPrincipal().getName());
                    if (index == -1) continue;
                    selectableGroups.remove(index);
                }
                request.setAttribute("jetspeedGroups", selectableGroups);
            } else if (selectedTab.getId().equals("user_profile")) {
                request.setAttribute("rules", (Object)this.getRules(user));
                request.setAttribute("prules", (Object)this.getProfilerRules());
            } else if (selectedTab.getId().equals("user_credential")) {
                request.setAttribute("credential", (Object)this.getCredential((PortletRequest)request, userName));
            }
            request.setAttribute("selected_tab", (Object)selectedTab);
        } else {
            this.renderRoleInformation(request);
            this.renderProfileInformation(request);
            this.renderSubsiteInformation(request);
        }
        ArrayList errorMessages = (ArrayList)PortletMessaging.consume((PortletRequest)request, (String)"user", (String)"errorMessages");
        if (errorMessages != null) {
            request.setAttribute("errorMessages", (Object)errorMessages);
        }
        super.doView(request, response);
    }

    protected void initPrefsAndAttr(PortletRequest request) {
        TabBean tb;
        this.initPrefsAndAttr = true;
        if (this.userTabMap == null) {
            this.userTabMap = new LinkedHashMap();
            this.anonymousUserTabMap = new LinkedHashMap();
        } else {
            this.userTabMap.clear();
            this.anonymousUserTabMap.clear();
        }
        PortletPreferences prefs = request.getPreferences();
        if ("true".equals(prefs.getValue("showUserTab", "true"))) {
            tb = new TabBean("user");
            this.userTabMap.put(tb.getId(), tb);
        }
        if ("true".equals(prefs.getValue("showAttributesTab", "true"))) {
            tb = new TabBean("user_attributes");
            this.userTabMap.put(tb.getId(), tb);
        }
        if ("true".equals(prefs.getValue("showPasswordTab", "true"))) {
            tb = new TabBean("user_credential");
            this.userTabMap.put(tb.getId(), tb);
        }
        if ("true".equals(prefs.getValue("showRoleTab", "true"))) {
            tb = new TabBean("user_role");
            this.userTabMap.put(tb.getId(), tb);
            this.anonymousUserTabMap.put(tb.getId(), tb);
        }
        if ("true".equals(prefs.getValue("showGroupTab", "true"))) {
            tb = new TabBean("user_group");
            this.userTabMap.put(tb.getId(), tb);
            this.anonymousUserTabMap.put(tb.getId(), tb);
        }
        if ("true".equals(prefs.getValue("showProfileTab", "true"))) {
            tb = new TabBean("user_profile");
            this.userTabMap.put(tb.getId(), tb);
            this.anonymousUserTabMap.put(tb.getId(), tb);
        }
        this.paUserAttributes = this.registry.getPortletApplicationByIdentifier(this.paIdentifier).getUserAttributes();
    }

    protected void renderRoleInformation(RenderRequest request) throws PortletException {
        String refreshRoles = (String)PortletMessaging.consume((PortletRequest)request, (String)"users", (String)"refresh.roles");
        LinkedList<String> roles = null;
        if (refreshRoles == null) {
            roles = (LinkedList<String>)request.getPortletSession().getAttribute("jetspeedRoles");
        }
        try {
            if (roles == null) {
                String adminName = this.configuration.getString("default.admin.role", "admin");
                String managerName = this.configuration.getString("default.manager.role", "manager");
                roles = new LinkedList<String>();
                Iterator fullRoles = this.roleManager.getRoles("");
                while (fullRoles.hasNext()) {
                    Role role = (Role)fullRoles.next();
                    String roleName = role.getPrincipal().getName();
                    String username = request.getUserPrincipal().getName();
                    if (roleName.equals(adminName)) {
                        if (!this.roleManager.isUserInRole(username, adminName)) continue;
                        roles.add(roleName);
                        continue;
                    }
                    if (roleName.equals(managerName)) {
                        if (!this.roleManager.isUserInRole(username, managerName)) continue;
                        roles.add(roleName);
                        continue;
                    }
                    roles.add(roleName);
                }
                request.getPortletSession().setAttribute("jetspeedRoles", roles);
            }
        }
        catch (SecurityException se) {
            throw new PortletException((Throwable)se);
        }
        request.setAttribute("jetspeedRoles", (Object)roles);
    }

    protected void renderProfileInformation(RenderRequest request) {
        String refreshProfiles = (String)PortletMessaging.consume((PortletRequest)request, (String)"users", (String)"refresh.profiles");
        Collection rules = null;
        if (refreshProfiles == null) {
            rules = (Collection)request.getPortletSession().getAttribute("jetspeedRules");
        }
        if (rules == null) {
            rules = this.profiler.getRules();
            request.getPortletSession().setAttribute("jetspeedRules", (Object)rules);
        }
        request.setAttribute("jetspeedRules", (Object)rules);
    }

    protected void renderSubsiteInformation(RenderRequest request) {
        String refreshSubsites = (String)PortletMessaging.consume((PortletRequest)request, (String)"users", (String)"refresh.subsites");
        ArrayList<SubsiteInfo> subsites = null;
        if (refreshSubsites == null) {
            subsites = (ArrayList<SubsiteInfo>)request.getPortletSession().getAttribute("jetspeedSubsites");
        }
        if (subsites == null) {
            subsites = new ArrayList<SubsiteInfo>();
            SubsiteInfo emptyone = new SubsiteInfo("", "");
            subsites.add(emptyone);
            String subsiteRoot = request.getPreferences().getValue("subsiteRootFolder", "");
            if (!subsiteRoot.equals("")) {
                try {
                    Folder subsiteFolder = this.pageManager.getFolder(subsiteRoot);
                    NodeSet set = this.pageManager.getFolders(subsiteFolder);
                    if (set != null && !set.isEmpty()) {
                        Iterator setIterator = set.iterator();
                        while (setIterator.hasNext()) {
                            Folder f = (Folder)setIterator.next();
                            subsites.add(new SubsiteInfo(f.getPath(), f.getTitle()));
                        }
                    }
                }
                catch (FolderNotFoundException fnfe) {
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            request.getPortletSession().setAttribute("jetspeedSubsites", subsites);
        }
        request.setAttribute("jetspeedSubsites", subsites);
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        this.renderRoleInformation(request);
        this.renderProfileInformation(request);
        this.renderSubsiteInformation(request);
        super.doEdit(request, response);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String action;
        TabBean tab;
        if (actionRequest.getPortletMode() == PortletMode.EDIT) {
            PortletPreferences prefs = actionRequest.getPreferences();
            PreferencesHelper.requestParamsToPreferences((ActionRequest)actionRequest);
            prefs.store();
            actionResponse.setPortletMode(PortletMode.VIEW);
            this.initPrefsAndAttr((PortletRequest)actionRequest);
            actionRequest.getPortletSession().removeAttribute("jetspeedSubsites");
            return;
        }
        String selectedTab = actionRequest.getParameter("selected_tab");
        if (selectedTab != null && (tab = (TabBean)this.userTabMap.get(selectedTab)) != null) {
            actionRequest.getPortletSession().setAttribute("selected_tab", (Object)tab);
        }
        if ((action = actionRequest.getParameter("portlet_action")) != null && action.equals("remove.user")) {
            this.removeUser(actionRequest, actionResponse);
        } else if (action != null && action.equals("add.new.user")) {
            PortletMessaging.cancel((PortletRequest)actionRequest, (String)"users", (String)"selected");
        } else if (action != null && action.equals("add.user")) {
            this.addUser(actionRequest);
        } else if (action != null && this.isUserPortletAction(action)) {
            if ((action = this.getAction("security_user.", action)).endsWith("edit_user")) {
                this.editUser(actionRequest, actionResponse);
            } else if (action.endsWith("update_user_attribute")) {
                this.updateUserAttribute(actionRequest, actionResponse);
            } else if (action.endsWith("remove_user_attribute")) {
                this.removeUserAttributes(actionRequest, actionResponse);
            } else if (action.endsWith("add_user_attribute")) {
                this.addUserAttribute(actionRequest, actionResponse);
            } else if (action.endsWith("remove_user_role")) {
                this.removeUserRoles(actionRequest, actionResponse);
            } else if (action.endsWith("add_user_role")) {
                this.addUserRole(actionRequest, actionResponse);
            } else if (action.endsWith("remove_user_group")) {
                this.removeUserGroups(actionRequest, actionResponse);
            } else if (action.endsWith("add_user_group")) {
                this.addUserGroup(actionRequest, actionResponse);
            } else {
                this.getClass();
                if (action.endsWith("add_rule")) {
                    this.addUserProfile(actionRequest, actionResponse);
                } else {
                    this.getClass();
                    if (action.endsWith("remove_user_rule")) {
                        this.removeUserProfile(actionRequest, actionResponse);
                    } else {
                        this.getClass();
                        if (action.endsWith("update_user_credential")) {
                            this.updateUserCredential(actionRequest, actionResponse);
                        }
                    }
                }
            }
        }
    }

    public void removeUser(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        String userName = (String)PortletMessaging.receive((PortletRequest)actionRequest, (String)"users", (String)"selected");
        User user = this.lookupUser((PortletRequest)actionRequest, userName);
        if (user != null) {
            try {
                Preferences attributes = user.getUserAttributes();
                String subsite = attributes.get("subsite", null);
                String firstName = attributes.get("user.name.given", "n/a");
                String lastName = attributes.get("user.name.family", "n/a");
                this.userManager.removeUser(userName);
                PortletMessaging.publish((PortletRequest)actionRequest, (String)"users", (String)"refresh", (Object)"true");
                if (subsite == null) {
                    subsite = "/_user/" + userName;
                }
                if (this.pageManager.folderExists(subsite)) {
                    Folder folder = this.pageManager.getFolder(subsite);
                    this.pageManager.removeFolder(folder);
                }
                this.audit.logAdminAttributeActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "user-delete", "", firstName, lastName, "J2 User Administration");
                PortletMessaging.cancel((PortletRequest)actionRequest, (String)"users", (String)"selected");
            }
            catch (Exception ex) {
                SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"user", (String)ex.getMessage());
            }
        }
    }

    public Principal createPrincipal(Subject subject, Class classe) {
        Principal principal = null;
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal p = principals.next();
            if (!classe.isInstance(p)) continue;
            principal = p;
            break;
        }
        return principal;
    }

    private void updateUserCredential(ActionRequest actionRequest, ActionResponse actionResponse) {
        ResourceBundle bundle = ResourceBundle.getBundle("org.apache.jetspeed.portlets.security.resources.UsersResources", actionRequest.getLocale());
        String userName = (String)PortletMessaging.receive((PortletRequest)actionRequest, (String)"users", (String)"selected");
        User user = this.lookupUser((PortletRequest)actionRequest, userName);
        if (user != null) {
            try {
                PasswordCredential credential;
                String password = actionRequest.getParameter("user_cred_value");
                boolean passwordSet = false;
                if (password != null && password.trim().length() > 0) {
                    this.userManager.setPassword(userName, null, password);
                    this.audit.logAdminCredentialActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "password-reset", "J2 User Administration");
                    passwordSet = true;
                }
                if ((credential = this.getCredential((PortletRequest)actionRequest, userName)) != null) {
                    String expiredFlagStr;
                    boolean enabled;
                    String enabledStr;
                    boolean updateRequired;
                    String updateRequiredStr = actionRequest.getParameter("user_cred_updreq");
                    if (updateRequiredStr != null && (updateRequired = Boolean.valueOf(updateRequiredStr).booleanValue()) != credential.isUpdateRequired()) {
                        this.userManager.setPasswordUpdateRequired(userName, updateRequired);
                        this.audit.logAdminCredentialActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "password-update-req", "J2 User Administration");
                    }
                    if ((enabledStr = actionRequest.getParameter("user_cred_enabled")) != null && (enabled = Boolean.valueOf(enabledStr).booleanValue()) != credential.isEnabled()) {
                        this.userManager.setPasswordEnabled(userName, enabled);
                        String activity = enabled ? "password-enabled" : "password-disabled";
                        this.audit.logAdminCredentialActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, activity, "J2 User Administration");
                    }
                    if ((expiredFlagStr = actionRequest.getParameter("user_expired_flag")) != null) {
                        if (!passwordSet && expiredFlagStr.equals("expired")) {
                            Date today = new Date(new java.util.Date().getTime());
                            this.userManager.setPasswordExpiration(userName, today);
                            this.audit.logAdminCredentialActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "password-expire", "J2 User Administration");
                        } else if (expiredFlagStr.equals("extend")) {
                            this.userManager.setPasswordExpiration(userName, null);
                            this.audit.logAdminCredentialActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "password-extend", "J2 User Administration");
                        } else if (expiredFlagStr.equals("unlimited")) {
                            this.userManager.setPasswordExpiration(userName, InternalCredential.MAX_DATE);
                            this.audit.logAdminCredentialActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "password-unlimited", "J2 User Administration");
                        }
                    }
                }
            }
            catch (InvalidPasswordException ipe) {
                SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"user", (String)bundle.getString("chgpwd.error.invalidPassword"));
            }
            catch (InvalidNewPasswordException inpe) {
                SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"user", (String)bundle.getString("chgpwd.error.invalidNewPassword"));
            }
            catch (PasswordAlreadyUsedException paue) {
                SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"user", (String)bundle.getString("chgpwd.error.passwordAlreadyUsed"));
            }
            catch (SecurityException e) {
                SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"user", (String)e.getMessage());
            }
        }
    }

    private void editUser(ActionRequest actionRequest, ActionResponse actionResponse) {
        String userName = (String)PortletMessaging.receive((PortletRequest)actionRequest, (String)"users", (String)"selected");
        User user = this.lookupUser((PortletRequest)actionRequest, userName);
        if (user != null) {
            Iterator attrIter = this.paUserAttributes.iterator();
            while (attrIter.hasNext()) {
                UserAttribute attr = (UserAttribute)attrIter.next();
                String value = actionRequest.getParameter("attr_" + attr.getName());
                if (value == null) continue;
                user.getUserAttributes().put(attr.getName(), value);
                this.audit.logAdminAttributeActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "user-add-attr", attr.getName(), value, value, "J2 User Administration");
            }
        }
        if ("true".equals(actionRequest.getPreferences().getValue("showPasswordOnUserTab", "false"))) {
            this.updateUserCredential(actionRequest, actionResponse);
        }
    }

    private void updateUserAttribute(ActionRequest actionRequest, ActionResponse actionResponse) {
        String[] userAttrNames;
        String userName = (String)PortletMessaging.receive((PortletRequest)actionRequest, (String)"users", (String)"selected");
        User user = this.lookupUser((PortletRequest)actionRequest, userName);
        if (user != null && (userAttrNames = actionRequest.getParameterValues("user_attr_id")) != null) {
            for (int i = 0; i < userAttrNames.length; ++i) {
                String userAttrName = userAttrNames[i];
                String value = actionRequest.getParameter(userAttrName + ":value");
                String before = user.getUserAttributes().get(userAttrName, "");
                user.getUserAttributes().put(userAttrName, value);
                this.audit.logAdminAttributeActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "user-update-attr", userAttrName, before, value, "J2 User Administration");
            }
        }
    }

    private void addUserAttribute(ActionRequest actionRequest, ActionResponse actionResponse) {
        String userName = (String)PortletMessaging.receive((PortletRequest)actionRequest, (String)"users", (String)"selected");
        User user = this.lookupUser((PortletRequest)actionRequest, userName);
        if (user != null) {
            String userAttrName = actionRequest.getParameter("user_attr_name");
            String userAttrValue = actionRequest.getParameter("user_attr_value");
            if (userAttrName != null && userAttrName.trim().length() > 0) {
                Preferences attributes = user.getUserAttributes();
                attributes.put(userAttrName, userAttrValue);
                this.audit.logAdminAttributeActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "user-add-attr", userAttrName, "", userAttrValue, "J2 User Administration");
            }
        }
    }

    private void removeUserAttributes(ActionRequest actionRequest, ActionResponse actionResponse) {
        String[] userAttrNames;
        String userName = (String)PortletMessaging.receive((PortletRequest)actionRequest, (String)"users", (String)"selected");
        User user = this.lookupUser((PortletRequest)actionRequest, userName);
        if (user != null && (userAttrNames = actionRequest.getParameterValues("user_attr_id")) != null) {
            Preferences attributes = user.getUserAttributes();
            for (int ix = 0; ix < userAttrNames.length; ++ix) {
                try {
                    String before = attributes.get(userAttrNames[ix], "");
                    attributes.remove(userAttrNames[ix]);
                    this.audit.logAdminAttributeActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "user-delete-attr", userAttrNames[ix], before, "", "J2 User Administration");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void removeUserRoles(ActionRequest actionRequest, ActionResponse actionResponse) {
        String[] roleNames;
        String userName = (String)PortletMessaging.receive((PortletRequest)actionRequest, (String)"users", (String)"selected");
        User user = this.lookupUser((PortletRequest)actionRequest, userName);
        if (user != null && (roleNames = actionRequest.getParameterValues("user_role_id")) != null) {
            for (int ix = 0; ix < roleNames.length; ++ix) {
                try {
                    if (!this.roleManager.roleExists(roleNames[ix])) continue;
                    this.roleManager.removeRoleFromUser(userName, roleNames[ix]);
                    this.audit.logAdminAuthorizationActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "user-delete-role", roleNames[ix], "J2 User Administration");
                    continue;
                }
                catch (SecurityException e) {
                    SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"user", (String)e.getMessage());
                }
            }
        }
    }

    private void addUserRole(ActionRequest actionRequest, ActionResponse actionResponse) {
        String roleName;
        String userName = (String)PortletMessaging.receive((PortletRequest)actionRequest, (String)"users", (String)"selected");
        User user = this.lookupUser((PortletRequest)actionRequest, userName);
        if (user != null && (roleName = actionRequest.getParameter("role_name")) != null && roleName.trim().length() > 0) {
            try {
                this.roleManager.addRoleToUser(userName, roleName);
                this.audit.logAdminAuthorizationActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "user-add-role", roleName, "J2 User Administration");
            }
            catch (SecurityException e) {
                SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"user", (String)e.getMessage());
            }
        }
    }

    private void removeUserGroups(ActionRequest actionRequest, ActionResponse actionResponse) {
        String[] groupNames;
        String userName = (String)PortletMessaging.receive((PortletRequest)actionRequest, (String)"users", (String)"selected");
        User user = this.lookupUser((PortletRequest)actionRequest, userName);
        if (user != null && (groupNames = actionRequest.getParameterValues("user_group_id")) != null) {
            for (int ix = 0; ix < groupNames.length; ++ix) {
                try {
                    if (!this.groupManager.groupExists(groupNames[ix])) continue;
                    this.groupManager.removeUserFromGroup(userName, groupNames[ix]);
                    this.audit.logAdminAuthorizationActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "user-delete-group", groupNames[ix], "J2 User Administration");
                    continue;
                }
                catch (SecurityException e) {
                    SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"user", (String)e.getMessage());
                }
            }
        }
    }

    private void addUserGroup(ActionRequest actionRequest, ActionResponse actionResponse) {
        String groupName;
        String userName = (String)PortletMessaging.receive((PortletRequest)actionRequest, (String)"users", (String)"selected");
        User user = this.lookupUser((PortletRequest)actionRequest, userName);
        if (user != null && (groupName = actionRequest.getParameter("group_name")) != null && groupName.trim().length() > 0) {
            try {
                this.groupManager.addUserToGroup(userName, groupName);
                this.audit.logAdminAuthorizationActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "user-add-group", groupName, "J2 User Administration");
            }
            catch (SecurityException e) {
                SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"user", (String)e.getMessage());
            }
        }
    }

    private String getAction(String prefix, String action) {
        return action.substring(prefix.length());
    }

    private boolean isUserPortletAction(String action) {
        return action.startsWith("security_user.");
    }

    private Collection getRoles(PortletRequest request, String userName) {
        try {
            return this.roleManager.getRolesForUser(userName);
        }
        catch (SecurityException e) {
            SecurityUtil.publishErrorMessage((PortletRequest)request, (String)"user", (String)e.getMessage());
            return new LinkedList();
        }
    }

    private Collection getGroups(PortletRequest request, String userName) {
        try {
            return this.groupManager.getGroupsForUser(userName);
        }
        catch (SecurityException e) {
            SecurityUtil.publishErrorMessage((PortletRequest)request, (String)"user", (String)e.getMessage());
            return new LinkedList();
        }
    }

    private PasswordCredential getCredential(User user) {
        PasswordCredential credential = null;
        Set<Object> credentials = user.getSubject().getPrivateCredentials();
        Iterator<Object> iter = credentials.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof PasswordCredential)) continue;
            credential = (PasswordCredential)o;
            break;
        }
        return credential;
    }

    private PasswordCredential getCredential(PortletRequest request, String userName) {
        return this.getCredential(this.lookupUser(request, userName));
    }

    private User lookupUser(PortletRequest request, String userName) {
        User user = null;
        try {
            user = this.userManager.getUser(userName);
        }
        catch (Exception e) {
            SecurityUtil.publishErrorMessage((PortletRequest)request, (String)"user", (String)e.getMessage());
        }
        return user;
    }

    private Collection getProfilerRules() {
        return this.profiler.getRules();
    }

    private Collection getRules(User user) {
        Principal userPrincipal = this.createPrincipal(user.getSubject(), class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = UserDetailsPortlet.class$((String)"org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal);
        return this.profiler.getRulesForPrincipal(userPrincipal);
    }

    private void addUserProfile(ActionRequest actionRequest, ActionResponse actionResponse) {
        String locatorName;
        String userName = (String)PortletMessaging.receive((PortletRequest)actionRequest, (String)"users", (String)"selected");
        User user = this.lookupUser((PortletRequest)actionRequest, userName);
        if (user != null && (locatorName = actionRequest.getParameter("locator_name")) != null && locatorName.trim().length() > 0) {
            try {
                Principal userPrincipal = this.createPrincipal(user.getSubject(), class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = UserDetailsPortlet.class$((String)"org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal);
                String ruleName = actionRequest.getParameter("select_rule");
                this.profiler.setRuleForPrincipal(userPrincipal, this.profiler.getRule(ruleName), locatorName);
                this.audit.logAdminAuthorizationActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "user-add-profile", ruleName + "-" + locatorName, "J2 User Administration");
            }
            catch (Exception e) {
                SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"user", (String)e.getMessage());
            }
        }
    }

    private void removeUserProfile(ActionRequest actionRequest, ActionResponse actionResponse) {
        String[] locatorNames;
        String userName = (String)PortletMessaging.receive((PortletRequest)actionRequest, (String)"users", (String)"selected");
        User user = this.lookupUser((PortletRequest)actionRequest, userName);
        if (user != null && (locatorNames = actionRequest.getParameterValues("user_profile_id")) != null) {
            Principal userPrincipal = this.createPrincipal(user.getSubject(), class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = UserDetailsPortlet.class$((String)"org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal);
            Collection rules = this.profiler.getRulesForPrincipal(userPrincipal);
            for (int ix = 0; ix < locatorNames.length; ++ix) {
                try {
                    Iterator it = rules.iterator();
                    while (it.hasNext()) {
                        PrincipalRule rule = (PrincipalRule)it.next();
                        if (!rule.getLocatorName().equals(locatorNames[ix])) continue;
                        this.profiler.deletePrincipalRule(rule);
                        this.audit.logAdminAuthorizationActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "user-delete-profile", rule.getProfilingRule().getId() + "-" + rule.getLocatorName(), "J2 User Administration");
                    }
                    continue;
                }
                catch (Exception e) {
                    SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"user", (String)e.getMessage());
                }
            }
        }
    }

    protected void addUser(ActionRequest actionRequest) {
        String userName = actionRequest.getParameter("jetspeed.user");
        String password = actionRequest.getParameter("jetspeed.password");
        if (!SecurityUtil.isEmpty((String)userName)) {
            try {
                String rule;
                String role;
                String requiredRole;
                boolean updateRequired;
                String updateRequiredStr;
                if (SecurityUtil.isEmpty((String)password)) {
                    throw new SecurityException(SecurityException.PASSWORD_REQUIRED);
                }
                this.userManager.addUser(userName, password);
                this.audit.logAdminUserActivity(actionRequest.getUserPrincipal().getName(), this.getIPAddress((PortletRequest)actionRequest), userName, "user-create", "J2 User Administration");
                PortletMessaging.publish((PortletRequest)actionRequest, (String)"users", (String)"refresh", (Object)"true");
                PortletMessaging.publish((PortletRequest)actionRequest, (String)"users", (String)"selected", (Object)userName);
                User user = this.userManager.getUser(userName);
                PasswordCredential credential = this.getCredential(user);
                if (credential != null && (updateRequiredStr = actionRequest.getParameter("user_cred_updreq")) != null && (updateRequired = Boolean.valueOf(updateRequiredStr).booleanValue()) != credential.isUpdateRequired()) {
                    this.userManager.setPasswordUpdateRequired(userName, updateRequired);
                }
                if (!SecurityUtil.isEmpty((String)(requiredRole = actionRequest.getPreferences().getValue("requiredRole", ""))) && user != null) {
                    this.roleManager.addRoleToUser(userName, requiredRole);
                }
                if (!SecurityUtil.isEmpty((String)(role = actionRequest.getParameter("jetspeedRoles"))) && user != null) {
                    this.roleManager.addRoleToUser(userName, role);
                }
                String templateFolder = actionRequest.getPreferences().getValue("newUserTemplateDirectory", "/_user/template/");
                String subsite = actionRequest.getParameter("jetspeedSubsites");
                if (SecurityUtil.isEmpty((String)subsite)) {
                    subsite = "/_user/" + userName;
                } else {
                    subsite = subsite + "/_user/" + userName;
                    Preferences attributes = user.getUserAttributes();
                    attributes.put("subsite", subsite);
                }
                if (templateFolder != null && templateFolder.trim().length() != 0) {
                    Folder source = this.pageManager.getFolder(templateFolder);
                    this.pageManager.deepCopyFolder(source, subsite, userName);
                }
                if (!SecurityUtil.isEmpty((String)(rule = actionRequest.getParameter("jetspeedRules"))) && user != null) {
                    Principal principal = SecurityUtil.getPrincipal((Subject)user.getSubject(), (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = UserDetailsPortlet.class$((String)"org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal));
                    this.profiler.setRuleForPrincipal(principal, this.profiler.getRule(rule), "page");
                }
            }
            catch (SecurityException sex) {
                SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"user", (String)sex.getMessage());
            }
            catch (Exception ex) {
                SecurityUtil.publishErrorMessage((PortletRequest)actionRequest, (String)"user", (String)ex.getMessage());
            }
        }
    }

    protected String getIPAddress(PortletRequest request) {
        RequestContext context = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        if (context == null) {
            return "";
        }
        return context.getRequest().getRemoteAddr();
    }
}

