/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.users;

import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.security.auth.Subject;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.portals.bridges.common.GenericServletPortlet;
import org.apache.portals.messaging.PortletMessaging;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserBrowserPortlet
extends GenericServletPortlet {
    private UserManager userManager;
    private RoleManager roleManager;
    private Profiler profiler;
    private static final String TREE_CONTROL = "j2_tree";
    private static final String ROLES_CONTROL = "jetspeedRoles";
    private static final String RULES_CONTROL = "jetspeedRules";
    private static final String USER_FILTER = "";
    private static final String SECURITY_NODE_ID = "SECURITY-NODE";
    private static final String SECURITY_DOMAIN = "SECURITY_DOMAIN";
    private static final String USER_NODE_ID = "USER-NODE";
    private static final String USER_DOMAIN = "USER_DOMAIN";
    private static final String USER_DETAIL_DOMAIN = "USER_DETAIL_DOMAIN";
    private static final String MSG_SECURITY_ROOT = "tree.security.root";
    private static final String MSG_USER_ROOT = "tree.user.root";
    static /* synthetic */ Class class$org$apache$jetspeed$security$UserPrincipal;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.userManager = (UserManager)this.getPortletContext().getAttribute("cps:UserManager");
        if (null == this.userManager) {
            throw new PortletException("Failed to find the User Manager on portlet initialization");
        }
        this.roleManager = (RoleManager)this.getPortletContext().getAttribute("cps:RoleManager");
        if (null == this.roleManager) {
            throw new PortletException("Failed to find the Role Manager on portlet initialization");
        }
        this.profiler = (Profiler)this.getPortletContext().getAttribute("cps:Profiler");
        if (null == this.profiler) {
            throw new PortletException("Failed to find the Profiler on portlet initialization");
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        String errorMessage = (String)PortletMessaging.consume((PortletRequest)request, (String)"user.error");
        if (errorMessage != null) {
            request.setAttribute("errorMessage", (Object)errorMessage);
        }
        TreeControl control = null;
        String refresh = (String)PortletMessaging.consume((PortletRequest)request, (String)"users", (String)"refresh");
        if (refresh == null) {
            control = (TreeControl)request.getPortletSession().getAttribute("j2_tree");
        }
        try {
            if (control == null) {
                Iterator users = this.userManager.getUsers("");
                control = this.buildTree(users, request.getLocale());
                request.getPortletSession().setAttribute("j2_tree", (Object)control);
            }
        }
        catch (SecurityException se) {
            throw new PortletException((Throwable)se);
        }
        request.setAttribute("j2_tree", (Object)control);
        String refreshRoles = (String)PortletMessaging.consume((PortletRequest)request, (String)"roles", (String)"refresh");
        LinkedList<String> roles = null;
        if (refreshRoles == null) {
            roles = (LinkedList<String>)request.getPortletSession().getAttribute("jetspeedRoles");
        }
        try {
            if (roles == null) {
                roles = new LinkedList<String>();
                Iterator fullRoles = this.roleManager.getRoles("");
                while (fullRoles.hasNext()) {
                    Role role = (Role)fullRoles.next();
                    roles.add(role.getPrincipal().getName());
                }
                request.getPortletSession().setAttribute("jetspeedRoles", roles);
            }
        }
        catch (SecurityException se) {
            throw new PortletException((Throwable)se);
        }
        request.setAttribute("jetspeedRoles", roles);
        String refreshProfiles = (String)PortletMessaging.consume((PortletRequest)request, (String)"profiles", (String)"refresh");
        Collection rules = null;
        if (refreshProfiles == null) {
            rules = (Collection)request.getPortletSession().getAttribute("jetspeedRules");
        }
        if (rules == null) {
            rules = this.profiler.getRules();
            request.getPortletSession().setAttribute("jetspeedRules", (Object)rules);
        }
        request.setAttribute("jetspeedRules", (Object)rules);
        super.doView(request, response);
    }

    private boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().equals("");
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String browserAction = actionRequest.getParameter("browser.action");
        if (browserAction != null) {
            String userName = actionRequest.getParameter("jetspeed.user");
            String password = actionRequest.getParameter("jetspeed.password");
            if (!this.isEmpty(userName) && !this.isEmpty(password)) {
                try {
                    String rule;
                    this.userManager.addUser(userName, password);
                    TreeControl control = (TreeControl)actionRequest.getPortletSession().getAttribute("j2_tree");
                    Iterator users = this.userManager.getUsers("");
                    control = this.buildTree(users, actionRequest.getLocale());
                    actionRequest.getPortletSession().setAttribute("j2_tree", (Object)control);
                    this.selectNode(actionRequest, control, userName);
                    User user = this.userManager.getUser(userName);
                    String role = actionRequest.getParameter("jetspeedRoles");
                    if (!this.isEmpty(role) && user != null) {
                        this.roleManager.addRoleToUser(userName, role);
                    }
                    if (!this.isEmpty(rule = actionRequest.getParameter("jetspeedRules")) && user != null) {
                        Principal principal = this.getPrincipal(user.getSubject(), class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = UserBrowserPortlet.class$((String)"org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal);
                        this.profiler.setRuleForPrincipal(principal, this.profiler.getRule(rule), "page");
                    }
                }
                catch (SecurityException se) {
                    PortletMessaging.publish((PortletRequest)actionRequest, (String)"user.error", (Object)se.getMessage());
                }
            }
            return;
        }
        TreeControl control = (TreeControl)actionRequest.getPortletSession().getAttribute("j2_tree");
        if (control != null) {
            String selectedNode;
            TreeControlNode controlNode;
            String node = actionRequest.getParameter("node");
            if (node != null && (controlNode = control.findNode(node)) != null) {
                controlNode.setExpanded(!controlNode.isExpanded());
            }
            if ((selectedNode = actionRequest.getParameter("select_node")) != null) {
                this.selectNode(actionRequest, control, selectedNode);
            }
        }
    }

    private void selectNode(ActionRequest actionRequest, TreeControl control, String selectedNode) {
        String domain;
        control.selectNode(selectedNode);
        TreeControlNode child = control.findNode(selectedNode);
        if (child != null && (domain = child.getDomain()).equals("USER_DETAIL_DOMAIN") && selectedNode != null) {
            actionRequest.getPortletSession().setAttribute("org.apache.jetspeed.pam.user", (Object)selectedNode, 1);
        }
    }

    private TreeControl buildTree(Iterator users, Locale locale) {
        TreeControlNode root = new TreeControlNode("SECURITY-NODE", null, this.getMessage("tree.security.root", locale), "portlet_url", null, true, "SECURITY_DOMAIN");
        TreeControl control = new TreeControl(root);
        TreeControlNode userTree = new TreeControlNode("USER-NODE", null, this.getMessage("tree.user.root", locale), "portlet_url", null, false, "USER_DOMAIN");
        root.addChild(userTree);
        while (users.hasNext()) {
            User user = (User)users.next();
            Principal principal = this.getPrincipal(user.getSubject(), class$org$apache$jetspeed$security$UserPrincipal == null ? UserBrowserPortlet.class$((String)"org.apache.jetspeed.security.UserPrincipal") : class$org$apache$jetspeed$security$UserPrincipal);
            TreeControlNode userNode = new TreeControlNode(principal.getName(), null, principal.getName(), "portlet_url", null, false, "USER_DETAIL_DOMAIN");
            userTree.addChild(userNode);
        }
        return control;
    }

    private Principal getPrincipal(Subject subject, Class classe) {
        Principal principal = null;
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal p = principals.next();
            if (!classe.isInstance(p)) continue;
            principal = p;
            break;
        }
        return principal;
    }

    private String getMessage(String key, Locale locale) {
        return this.getResourceBundle(locale).getString(key);
    }
}

